package com.ecom.park_jy;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import java.io.*;
import java.io.FilenameFilter;


class FilesFilter implements FilenameFilter {
    boolean bImgList;
    String szUserId;
    String szDate;
    String szExtended;


    public FilesFilter(String szId, String szDate, String szExt, boolean bImgList) {
        this.szUserId = szId;
        this.szDate = szDate;
        this.szExtended = szExt;
        this.bImgList = bImgList;
    }

    public boolean accept(File dir, String name) {
        if (this.bImgList)
            return (name.regionMatches(0, szUserId, 0, 11) && name.endsWith("." + szExtended));
        else if (szExtended.compareTo("jpg") == 0)
            return (name.regionMatches(0, szUserId, 0, 2) && name.endsWith("." + szExtended));
        else if (szExtended.compareTo(".txt") == 0)
            return (name.regionMatches(0, szUserId, 0, 2) && name.endsWith(szExtended));
        else
            return (name.regionMatches(1, szUserId, 0, 2) && name.endsWith("." + szExtended));
        //return (name.endsWith(".txt"));
    }
}

public class Total extends AppCompatActivity {
    private Bundle bundle;

    private Button back_button;

    private TextView totalbillsToday_textView;
    private TextView totalbillsMonth_textView;
    private TextView totalCanceledToday_textView;
    private TextView totalCanceledMonth_textView;
    private TextView totalTimesToday_textView;
    private TextView totalTimesMonth_textView;
    private TextView totalExpensesToday_textView;
    private TextView totalExpensesMonth_textView;

    int nTotalMonth;
    int nCanceledMonth;
    int nExpensesMonth;
    double dTimesMonth;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_total);

        back_button = (Button) findViewById(R.id.button68);
        back_button.setOnClickListener(backPARK);

        totalbillsToday_textView = (TextView) findViewById(R.id.textView35);
        totalbillsMonth_textView = (TextView) findViewById(R.id.textView39);
        totalCanceledToday_textView = (TextView) findViewById(R.id.textView36);
        totalCanceledMonth_textView = (TextView) findViewById(R.id.textView40);
        totalTimesToday_textView = (TextView) findViewById(R.id.textView37);
        totalTimesMonth_textView = (TextView) findViewById(R.id.textView41);
        totalExpensesToday_textView = (TextView) findViewById(R.id.textView38);
        totalExpensesMonth_textView = (TextView) findViewById(R.id.textView42);

        Init();
    }

    private Button.OnClickListener backPARK = (new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            finish();
        }
    });

    private void Init() {
        bundle = this.getIntent().getExtras();

        String szUserId = bundle.getString("USER_ID");
        String szTmpPath = bundle.getString("FILES_PATH");
        String szYYMMDD = bundle.getString("YYYYMMDD");

        CalcToday(szUserId, szTmpPath, szYYMMDD, false);
        CalcMonth(szUserId, szTmpPath, szYYMMDD);
    }

    private void CalcToday(String szUserId, String szPath, String szYYMMDD, boolean bMonth) {
        int nTotalToday = 0;
        int nCanceledToday = 0;
        int nExpensesToday = 0;
        double dTimesToday = 0.0;

        boolean bError = false;

        File fileTemp = new File(szPath);

        if (!fileTemp.isDirectory())
            return;

        if (fileTemp.listFiles(new FilesFilter(szUserId, szYYMMDD, "txt", false)).length > 0) {
            for (File file : fileTemp.listFiles(new FilesFilter(szUserId, szYYMMDD, "txt", false))) {
                try {
                    String szPathTemp = szPath + "/" + file.getName();

                    String[] arrayCars = Commin.readTXT(szPathTemp, "\n");

                    for (int i = 0; i < arrayCars.length; i++) {
                        bError = false;

                        String[] arrayItem = arrayCars[i].split(";");

                        if (arrayItem.length < 12)
                            continue;

                        for (int j = 0; j < 12; ++j) {
                            if (arrayItem[j].length() < 1) {
                                bError = true;
                                break;
                            }
                        }

                        if (bError)
                            continue;

                        nTotalToday++;
                        dTimesToday += Double.parseDouble(arrayItem[10]);
                        nExpensesToday += Integer.parseInt(arrayItem[11]);

                        if (arrayItem.length < 14)
                            nCanceledToday += 0;
                        else
                            nCanceledToday += (Integer.parseInt(arrayItem[13]) > 0) ? 0 : 1;

                    }
                } catch (Exception e) {
                    continue;
                }
                //	nCanceledToday++;
            }

            if (!bMonth) {
                totalbillsToday_textView.setText(String.valueOf(nTotalToday));
                totalCanceledToday_textView.setText(String.valueOf(nCanceledToday));
                totalTimesToday_textView.setText(String.valueOf(dTimesToday));
                totalExpensesToday_textView.setText(String.valueOf(nExpensesToday));
            } else {
                nTotalMonth += nTotalToday;
                nCanceledMonth += nCanceledToday;
                nExpensesMonth += nExpensesToday;
                dTimesMonth += dTimesToday;
            }
        }
    }

    private void CalcMonth(String szUserId, String szPath, String szYYMMDD) {
        String szPathMonth;

        nTotalMonth = 0;
        nCanceledMonth = 0;
        nExpensesMonth = 0;
        dTimesMonth = 0.0;

        for (int i = 1; i < 32; ++i) {
            szPathMonth = String.format("%s%02d", szPath.substring(0, szPath.length() - 2), i);

            CalcToday(szUserId, szPathMonth, szYYMMDD, true);
            //	Toast.makeText(Total.this, szPathMonth, Toast.LENGTH_LONG).show();
        }

        totalbillsMonth_textView.setText(String.valueOf(nTotalMonth));
        totalCanceledMonth_textView.setText(String.valueOf(nCanceledMonth));
        totalTimesMonth_textView.setText(String.valueOf(dTimesMonth));
        totalExpensesMonth_textView.setText(String.valueOf(nExpensesMonth));
    }
}
