package com.ecom.park_jy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;

public class Commin {
    public Commin() {
    }

    public static boolean isWorkTime(String isMorning, Calendar nowCalendar) {
        Calendar tmpCalendar1 = Calendar.getInstance();
        Calendar tmpCalendar2 = Calendar.getInstance();
        if (isMorning.equals("A")) {

            tmpCalendar1.set(Calendar.HOUR_OF_DAY, 16);
            tmpCalendar1.set(Calendar.MINUTE, 30);
            tmpCalendar1.set(Calendar.SECOND, 0);
            tmpCalendar1.set(Calendar.MILLISECOND, 0);

            tmpCalendar2.set(Calendar.HOUR_OF_DAY, 8);
            tmpCalendar2.set(Calendar.MINUTE, 0);
            tmpCalendar2.set(Calendar.SECOND, 0);
            tmpCalendar2.set(Calendar.MILLISECOND, 0);
        } else {
            tmpCalendar1.set(Calendar.HOUR_OF_DAY, 22);
            tmpCalendar1.set(Calendar.MINUTE, 0);
            tmpCalendar1.set(Calendar.SECOND, 0);
            tmpCalendar1.set(Calendar.MILLISECOND, 0);

            tmpCalendar2.set(Calendar.HOUR_OF_DAY, 13);
            tmpCalendar2.set(Calendar.MINUTE, 0);
            tmpCalendar2.set(Calendar.SECOND, 30);
            tmpCalendar2.set(Calendar.MILLISECOND, 0);
        }
        if (nowCalendar.after(tmpCalendar2) && nowCalendar.before(tmpCalendar1))
            return true;
        else
            return false;
    }

    public static String getHoursAndMinute(Calendar calendar) {
        String time = null;
        if (calendar.get(Calendar.HOUR_OF_DAY) < 10)
            time = "0" + calendar.get(Calendar.HOUR_OF_DAY) + ":";
        else
            time = calendar.get(Calendar.HOUR_OF_DAY) + ":";
        if (calendar.get(Calendar.MINUTE) < 10)
            time += "0" + calendar.get(Calendar.MINUTE);
        else
            time += calendar.get(Calendar.MINUTE);
        return time;
    }

    /*1987-09-28 12:20*/
    public static String getDateAndTime(Calendar calendar) {
        String dateAndTime = "";
        dateAndTime += calendar.get(Calendar.YEAR) + "-";
        if ((calendar.get(Calendar.MONTH) + 1) < 10)
            dateAndTime += "0";
        dateAndTime += (calendar.get(Calendar.MONTH) + 1) + "-";
        if (calendar.get(Calendar.DATE) < 10)
            dateAndTime += "0";
        dateAndTime += calendar.get(Calendar.DATE) + " ";
        if (calendar.get(Calendar.HOUR_OF_DAY) < 10)
            dateAndTime += "0";
        dateAndTime += calendar.get(Calendar.HOUR_OF_DAY);
        dateAndTime += ":";
        if (calendar.get(Calendar.MINUTE) < 10)
            dateAndTime += "0";
        dateAndTime += calendar.get(Calendar.MINUTE);
        return dateAndTime;
    }

    /*19870928*/
    public static String getDate(Calendar calendar, boolean bExChange) {
        String dateAndTime = "";
        dateAndTime = String.format("%03d", bExChange ? (calendar.get(Calendar.YEAR) - 1911) : calendar.get(Calendar.YEAR));

        if ((calendar.get(Calendar.MONTH) + 1) < 10)
            dateAndTime += "0";
        dateAndTime += (calendar.get(Calendar.MONTH) + 1);
        if (calendar.get(Calendar.DATE) < 10)
            dateAndTime += "0";
        dateAndTime += calendar.get(Calendar.DATE);
        return dateAndTime;
    }

    public static String updateTXT(String path, String szBillNo, String szUpdate) {
        String szSS = null;
        try {
            File temp = new File(path);
            if (!temp.isFile())
                return "";

            String[] dataArray = Commin.readTXT(path, "\n");


            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(path), "UTF-8");

            if (0 == szBillNo.compareTo("00"))
                out.append(szUpdate + "\n");
            else
                for (int i = 0; i < dataArray.length; ++i) {
                    String[] arrayItem = dataArray[i].split(";");

                    String szData = (0 == szBillNo.compareTo(arrayItem[1])) ? szUpdate : (dataArray[i] + "\n");
                    out.append(szData);
                }

            out.flush();
            out.close();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return szSS;
    }

    public static String[] readTXT(String path, String szSplit) {
        String data;
        String[] line = null;
        try {
            FileReader fr = new FileReader(path);
            StringBuffer sb = new StringBuffer();
            int c;
            while ((c = fr.read()) != -1) {
                sb.append((char) c);
            }
            fr.close();
            data = sb.toString();
            data = data.substring(0, data.length());
            line = data.split(szSplit);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            String[] error = {path};
            return error;
        } catch (IOException e) {
            e.printStackTrace();
            String[] error = {path};
            return error;
        }
        return line;
    }

    public static void writeTXT(String path, String name, String data) {
        try {
            File temp = new File(path);
            if (!temp.exists()) {
                temp.mkdirs();
            }
            data = Commin.read(path + name) + data;
            OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(path + name), "UTF-8");
            out.write(data);
            out.flush();
            out.close();
            //System.out.println("success...");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String read(String path) {
        String data;
        try {
            FileReader fr = new FileReader(path);
            StringBuffer sb = new StringBuffer();
            int c;
            while ((c = fr.read()) != -1) {
                sb.append((char) c);
            }
            fr.close();
            data = sb.toString();
            data = data.substring(0, data.length());
        } catch (FileNotFoundException e) {
            return "";
        } catch (IOException e) {
            return "";
        }
        return data;
    }

    public static void FileBackup(File mF1, File mF2) throws Exception {
        int nLen = (int) mF1.length();
        byte[] nBuf = new byte[nLen];

        FileInputStream inF = new FileInputStream(mF1);
        FileOutputStream outF = new FileOutputStream(mF2);


        while (true) {
            int ins = inF.read(nBuf);
            if (ins == -1) {
                inF.close();
                outF.flush();
                outF.close();
                return;
            } else
                outF.write(nBuf, 0, ins);
        }
    }

    public static String getOneNumber(int number) {
        String string = "";
        switch (number) {
            case 1:
                string = "1";
                break;
            case 2:
                string = "2";
                break;
            case 3:
                string = "3";
                break;
            case 4:
                string = "4";
                break;
            case 5:
                string = "5";
                break;
            case 6:
                string = "6";
                break;
            case 7:
                string = "7";
                break;
            case 8:
                string = "8";
                break;
            case 9:
                string = "9";
                break;
            case 10:
                string = "A";
                break;
            case 11:
                string = "B";
                break;
            case 12:
                string = "C";
                break;
            case 13:
                string = "D";
                break;
            case 14:
                string = "E";
                break;
            case 15:
                string = "F";
                break;
            case 16:
                string = "G";
                break;
            case 17:
                string = "H";
                break;
            case 18:
                string = "J";
                break;
            case 19:
                string = "K";
                break;
            case 20:
                string = "L";
                break;
            case 21:
                string = "M";
                break;
            case 22:
                string = "N";
                break;
            case 23:
                string = "P";
                break;
            case 24:
                string = "Q";
                break;
            case 25:
                string = "R";
                break;
            case 26:
                string = "S";
                break;
            case 27:
                string = "T";
                break;
            case 28:
                string = "U";
                break;
            case 29:
                string = "V";
                break;
            case 30:
                string = "W";
                break;
            case 31:
                string = "X";
                break;
        }
        return string;
    }

    public static String getTwoNumber(int number) {
        int temp = number;
        String string = "";
        temp /= 10;
        switch (temp) {
            case 0:
                string = "0";
                break;
            case 1:
                string = "1";
                break;
            case 2:
                string = "2";
                break;
            case 3:
                string = "3";
                break;
            case 4:
                string = "4";
                break;
            case 5:
                string = "5";
                break;
            case 6:
                string = "6";
                break;
            case 7:
                string = "7";
                break;
            case 8:
                string = "8";
                break;
            case 9:
                string = "9";
                break;
            case 10:
                string = "A";
                break;
            case 11:
                string = "B";
                break;
            case 12:
                string = "C";
                break;
            case 13:
                string = "D";
                break;
            case 14:
                string = "E";
                break;
            case 15:
                string = "F";
                break;
            case 16:
                string = "G";
                break;
            case 17:
                string = "H";
                break;
            case 18:
                string = "I";
                break;
            case 19:
                string = "J";
                break;
            case 20:
                string = "K";
                break;
            case 21:
                string = "L";
                break;
            case 22:
                string = "M";
                break;
            case 23:
                string = "N";
                break;
            case 24:
                string = "O";
                break;
            case 25:
                string = "P";
                break;
            case 26:
                string = "Q";
                break;
            case 27:
                string = "R";
                break;
            case 28:
                string = "S";
                break;
            case 29:
                string = "T";
                break;
            case 30:
                string = "U";
                break;
            case 31:
                string = "V";
                break;
            case 32:
                string = "W";
                break;
            case 33:
                string = "X";
                break;
            case 34:
                string = "Y";
                break;
            case 35:
                string = "Z";
                break;
        }
        string += number % 10;

        return string;
    }

    public static String check(String string1, String string2) {
        char[] s1, s2;
        int check1 = 0, check2 = 0;
        String ans;

        s1 = string1.toCharArray();
        s2 = string2.toCharArray();
        for (int temp = 0; temp < 9; temp++) {
            if (temp % 2 == 0)    //基數位數
            {
                check1 += change(s1[temp]);
                check1 += change(s2[temp]);
            } else {
                check2 += change(s1[temp]);
                check2 += change(s2[temp]);
            }
        }
        check1 %= 11;
        if (check1 == 10)
            check1 = 1;

        check2 %= 11;
        if (check2 == 10)
            check2 = 9;
        else if (check2 == 0)
            check2 = 8;

        ans = String.valueOf(check1) + String.valueOf(check2);
        return ans;
    }

    private static int change(char ch) {
        int num = 0;

        switch (ch) {
            case '0':
                num = 0;
                break;
            case '1':
                num = 1;
                break;
            case '2':
                num = 2;
                break;
            case '3':
                num = 3;
                break;
            case '4':
                num = 4;
                break;
            case '5':
                num = 5;
                break;
            case '6':
                num = 6;
                break;
            case '7':
                num = 7;
                break;
            case '8':
                num = 8;
                break;
            case '9':
                num = 9;
                break;
            case 'A':
                num = 1;
                break;
            case 'B':
                num = 2;
                break;
            case 'C':
                num = 3;
                break;
            case 'D':
                num = 4;
                break;
            case 'E':
                num = 5;
                break;
            case 'F':
                num = 6;
                break;
            case 'G':
                num = 7;
                break;
            case 'H':
                num = 8;
                break;
            case 'I':
                num = 9;
                break;
            case 'J':
                num = 1;
                break;
            case 'K':
                num = 2;
                break;
            case 'L':
                num = 3;
                break;
            case 'M':
                num = 4;
                break;
            case 'N':
                num = 5;
                break;
            case 'O':
                num = 6;
                break;
            case 'P':
                num = 7;
                break;
            case 'Q':
                num = 8;
                break;
            case 'R':
                num = 9;
                break;
            case 'S':
                num = 2;
                break;
            case 'T':
                num = 3;
                break;
            case 'U':
                num = 4;
                break;
            case 'V':
                num = 5;
                break;
            case 'W':
                num = 6;
                break;
            case 'X':
                num = 7;
                break;
            case 'Y':
                num = 8;
                break;
            case 'Z':
                num = 9;
                break;
        }
        return num;
    }
}
