package com.ecom.park_jy;

import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import java.util.Calendar;

public class Cumulative extends AppCompatActivity {
    private Intent intent = new Intent();
    private Bundle bundle = new Bundle();

    private Calendar nowCalendar;
    private Calendar cumulativeCalendar;
    private Calendar billingCalendar;
    private String billingTime;
    private int type;
    private int nStatus;
    private String carType;
    private Double hours;
    private int expenses;
    private int count = 0;
    private int GG = 1; //0未啟用 1啟用 3殘障車位

    Button cumulativeBack_button;
    private TextView cumulativeTime_textView;
    Button periodSub_button;
    Button periodAdd_button;
    private TextView BillingTime_textView;
    private TextView parkingHours_textView;
    private TextView parkingExpenses_textView;
    private Button off_button;
    private Button confirm_button;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_cumulative);

        init();
        findViews();
        setListeners();
    }

    private void init() {
        bundle = this.getIntent().getExtras();
        nowCalendar = Calendar.getInstance();
        cumulativeCalendar = Calendar.getInstance();
        billingCalendar = Calendar.getInstance();
        GG = bundle.getInt("GG");
        type = bundle.getInt("TYPE");
        nStatus = bundle.getInt("STATUS");
        carType = bundle.getString("CARTYPE");
        billingTime = bundle.getString("BILLING_TIME");
        billingCalendar.set(Calendar.HOUR_OF_DAY, Integer.valueOf(billingTime.substring(0, 2)));
        billingCalendar.set(Calendar.MINUTE, Integer.valueOf(billingTime.substring(3)));
        switch (type) {
            case 1:
                hours = 1.0;
                if ((Integer.valueOf(carType) == 12) || (Integer.valueOf(carType) == 13) || (Integer.valueOf(carType) == 14)) {
                    expenses = 10;
                } else if (Integer.valueOf(carType) == 6 ||
                        Integer.valueOf(carType) == 7 ||
                        Integer.valueOf(carType) == 8 ||
                        Integer.valueOf(carType) == 11)
                    expenses = 40;
                else {
                    expenses = 20;
                }
                do {
                    billingCalendar.add(Calendar.MINUTE, 60);
                    count += 1;
                } while (billingCalendar.before(nowCalendar));
                break;
            case 2:
                hours = 0.5;
                if ((Integer.valueOf(carType) == 12) || (Integer.valueOf(carType) == 13) || (Integer.valueOf(carType) == 14)) {
                    expenses = 15;
                } else if (Integer.valueOf(carType) == 6 ||
                        Integer.valueOf(carType) == 7 ||
                        Integer.valueOf(carType) == 8 ||
                        Integer.valueOf(carType) == 11)
                    expenses = 50;
                else
                    expenses = 25;

                do {
                    billingCalendar.add(Calendar.MINUTE, 30);
                    count += 1;
                } while (billingCalendar.before(nowCalendar));
                break;
        }
        billingCalendar.set(Calendar.HOUR_OF_DAY, Integer.valueOf(billingTime.substring(0, 2)));
        billingCalendar.set(Calendar.MINUTE, Integer.valueOf(billingTime.substring(3)));
    }


    private void findViews() {
        cumulativeBack_button = (Button) findViewById(R.id.button24);
        cumulativeTime_textView = (TextView) findViewById(R.id.textView23);
        cumulativeTime_textView.setText(Commin.getHoursAndMinute(cumulativeCalendar));
        periodSub_button = (Button) findViewById(R.id.button26);
        periodAdd_button = (Button) findViewById(R.id.button25);
        BillingTime_textView = (TextView) findViewById(R.id.textView25);
        BillingTime_textView.setText(billingTime);
        parkingHours_textView = (TextView) findViewById(R.id.hour);
        parkingHours_textView.setText(String.valueOf(hours * count));
        parkingExpenses_textView = (TextView) findViewById(R.id.parkExp);
        parkingExpenses_textView.setText(String.valueOf(expenses * count));
        if (type == 1) {// 小時計費
            if (GG == 3 && (Integer.valueOf(carType) == 12)) { //殘障車格兩小時免費
                expenses = ((hours * count) <= 2) ? 0 : 10;
                parkingExpenses_textView.setText(String.valueOf(expenses * (count - 2)));
            }
            if (GG == 3 && (Integer.valueOf(carType) == 13)) { //殘障車格四小時免費
                expenses = ((hours * count) <= 4) ? 0 : 10;
                parkingExpenses_textView.setText(String.valueOf(expenses * (count - 4)));
            }
        } else {//半小時計費
            if (GG == 3 && (Integer.valueOf(carType) == 12)) { //殘障車格兩小時免費
                expenses = ((hours * count) <= 2) ? 0 : 15;
                parkingExpenses_textView.setText(String.valueOf(expenses * (count - 4)));
            }
            if (GG == 3 && (Integer.valueOf(carType) == 13)) { //殘障車格四小時免費
                expenses = ((hours * count) <= 4) ? 0 : 15;
                parkingExpenses_textView.setText(String.valueOf(expenses * (count - 8)));
            }
        }

        off_button = (Button) findViewById(R.id.button27);
        confirm_button = (Button) findViewById(R.id.addCheck);

        off_button.setText((nStatus == 1) ? "註銷本單" : "恢復本單");
        off_button.setTextColor((nStatus == 1) ? android.graphics.Color.BLACK : android.graphics.Color.RED);
    }

    private void setListeners() {
        cumulativeBack_button.setOnClickListener(backPARK);
        periodSub_button.setOnClickListener(subCumulative);
        periodAdd_button.setOnClickListener(AddCumulative);
        off_button.setOnClickListener(off);
        confirm_button.setOnClickListener(confirm);
    }

    private Button.OnClickListener backPARK = new Button.OnClickListener() {
        public void onClick(View v) {
            finish();
        }
    };

    private Button.OnClickListener subCumulative = new Button.OnClickListener() {
        public void onClick(View v) {
            switch (type) {

                case 1:
                    cumulativeCalendar.add(Calendar.MINUTE, -60);
                    if (cumulativeCalendar.before(billingCalendar)) {
                        cumulativeCalendar.add(Calendar.MINUTE, 60);
                    } else {
                        count -= 1;
                        cumulativeTime_textView.setText(Commin.getHoursAndMinute(cumulativeCalendar));
                        parkingHours_textView.setText(String.valueOf(hours * count));
                        parkingExpenses_textView.setText(String.valueOf(expenses * count));
                        if (GG == 3 && (Integer.valueOf(carType) == 12)) {
                            expenses = ((hours * count) <= 2) ? 0 : 10;
                            parkingExpenses_textView.setText(String.valueOf(expenses * (count - 2)));
                        }
                        if (GG == 3 && (Integer.valueOf(carType) == 13)) {
                            expenses = ((hours * count) <= 4) ? 0 : 10;
                            parkingExpenses_textView.setText(String.valueOf(expenses * (count - 4)));
                        }
                    }
                    break;
                case 2:
                    cumulativeCalendar.add(Calendar.MINUTE, -30);
                    if (cumulativeCalendar.before(billingCalendar)) {
                        cumulativeCalendar.add(Calendar.MINUTE, 30);
                    } else {
                        count -= 1;
                        cumulativeTime_textView.setText(Commin.getHoursAndMinute(cumulativeCalendar));
                        parkingHours_textView.setText(String.valueOf(hours * count));
                        parkingExpenses_textView.setText(String.valueOf(expenses * count));
                        if (GG == 3 && (Integer.valueOf(carType) == 12)) {
                            expenses = ((hours * count) <= 2) ? 0 : 15;
                            parkingExpenses_textView.setText(String.valueOf(expenses * (count - 4)));
                        }
                        if (GG == 3 && (Integer.valueOf(carType) == 13)) {
                            expenses = ((hours * count) <= 4) ? 0 : 15;
                            parkingExpenses_textView.setText(String.valueOf(expenses * (count - 8)));
                        }
                    }
                    break;
            }
        }

    };

    private Button.OnClickListener AddCumulative = new Button.OnClickListener() {
        public void onClick(View v) {
            nowCalendar = Calendar.getInstance();
            switch (type) {
                case 1:
                    cumulativeCalendar.add(Calendar.MINUTE, 60);
                    if (cumulativeCalendar.after(nowCalendar)) {
                        cumulativeCalendar.add(Calendar.MINUTE, -60);
                    } else {
                        count += 1;
                        cumulativeTime_textView.setText(Commin.getHoursAndMinute(cumulativeCalendar));
                        parkingHours_textView.setText(String.valueOf(hours * count));
                        parkingExpenses_textView.setText(String.valueOf(expenses * count));
                        if (GG == 3 && (Integer.valueOf(carType) == 12)) {
                            expenses = ((hours * count) <= 2) ? 0 : 10;
                            parkingExpenses_textView.setText(String.valueOf(expenses * (count - 2)));
                        }
                        if (GG == 3 && (Integer.valueOf(carType) == 13)) {
                            expenses = ((hours * count) <= 4) ? 0 : 10;
                            parkingExpenses_textView.setText(String.valueOf(expenses * (count - 4)));
                        }
                    }
                    break;
                case 2:
                    cumulativeCalendar.add(Calendar.MINUTE, 30);
                    if (cumulativeCalendar.after(nowCalendar)) {
                        cumulativeCalendar.add(Calendar.MINUTE, -30);
                    } else {
                        count += 1;
                        cumulativeTime_textView.setText(Commin.getHoursAndMinute(cumulativeCalendar));
                        parkingHours_textView.setText(String.valueOf(hours * count));
                        parkingExpenses_textView.setText(String.valueOf(expenses * count));
                        if (GG == 3 && (Integer.valueOf(carType) == 12)) {
                            expenses = ((hours * count) <= 2) ? 0 : 15;
                            parkingExpenses_textView.setText(String.valueOf(expenses * (count - 4)));
                        }
                        if (GG == 3 && (Integer.valueOf(carType) == 13)) {
                            expenses = ((hours * count) <= 4) ? 0 : 15;
                            parkingExpenses_textView.setText(String.valueOf(expenses * (count - 8)));
                        }
                    }
                    break;
            }
        }
    };

    private Button.OnClickListener off = new Button.OnClickListener() {
        public void onClick(View v) {
            if (nStatus == 1)
                nStatus = 0;
            else
                nStatus = 1;

            off_button.setText((nStatus == 1) ? "註銷本單" : "恢復本單");
            off_button.setTextColor((nStatus == 1) ? android.graphics.Color.BLACK : android.graphics.Color.RED);

            bundle.putInt("COUNT", count);
            bundle.putInt("EXPENSES", expenses);
            bundle.putInt("BILL_STATUS", nStatus);
            intent.putExtras(bundle);
            setResult(RESULT_OK, intent);
            finish();
        }
    };

    private Button.OnClickListener confirm = new Button.OnClickListener() {
        public void onClick(View v) {
            bundle.putInt("COUNT", count);
            bundle.putString("CARTYPE", carType);
            bundle.putInt("GG", GG);
            bundle.putInt("EXPENSES", expenses);
            bundle.putInt("BILL_STATUS", nStatus);
            intent.putExtras(bundle);
            setResult(RESULT_OK, intent);
            finish();
        }
    };
}
