package com.ecom.park_jy;

import java.io.IOException;
import java.io.OutputStream;

public class BluetoothPrint {
    public void InitPrinter(OutputStream out){
        byte[] bInit = {0x1b,0x40};
        try {
            out.write(bInit);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void ToBlackMark(OutputStream out){
        byte[] bBM = {0x0c};
        try {
            out.write(bBM);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void PrintChangeLine(OutputStream out, int lines){
        try {
            for(int i = 0; i < lines; i++){
                out.write(0x0a);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void PrintString(OutputStream out, String sCode){
        byte[] bs = {0x1b,0x5a,1};
        try {
            out.write(bs);
            out.write(sCode.getBytes("BIG5"));
            out.write(0x0a);
            bs[2] = 0;
            out.write(bs);
            out.write(0x0a);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void PrintUpLine(OutputStream out,String string){
        byte[] uL = {0x1b,0x5f,1};
        byte[] bString = {0x1b,0x5a,1};
        try {
            out.write(bString);
            out.write(uL);
            out.write(string.getBytes("BIG5"));
            out.write(0x0a);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void PrintBarCode(OutputStream out, String barCode, boolean bSecond){
        byte[] bString = {0x1b,0x5a,1};

        byte[] bCodeHRI = {0x1d,0x48,0,0x0a};
        byte[] bCodeWidth = {0x1d,0x77,1,0x0a};
        byte[] bCodeHigh = {0x1d,0x68,64,0x0a};
        byte[] bCodeType = {0x1d,0x6b,0x45};

        try {
            out.write(bString);

            if(bSecond){
                out.write(bCodeHRI);
            }

            out.write(bCodeHigh);
            out.write(bCodeWidth);
            out.write(bCodeType);
            out.write(barCode.length());
            out.write(barCode.getBytes());
            out.write(0x0a);

        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
