package com.ecom.park_jy;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import java.io.File;
import java.util.ArrayList;

public class FileList extends AppCompatActivity {
    private Intent intent = new Intent();
    private Bundle bundle;

    private String  szFilePath;
    private String  szSpace;
    private boolean bSearch;
    private int gidsearch;

    private static ArrayList<String> szFileList = new ArrayList<String>();


    public void bt_back(View v){
        finish();
    }

    private void Init()
    {
        bundle 	= this.getIntent().getExtras();

        String	szTmpPath  = bundle.getString("FILES_PATH");
        String	szTmpSpace = bundle.getString("SEARCH_FILE");

        szSpace = bundle.getString("ADDR_SPACE");

        if(szTmpPath.length() < 4)
            bSearch = true;

        if(bSearch)
        {
            szFilePath = szTmpSpace;
            searchFiles();
        }
        else
        {
            szFilePath = szTmpPath;
            listingFiles();
        }

        if(szFileList.size() == 0)
            Toast.makeText(FileList.this,"沒有相關檔案，請開單", Toast.LENGTH_LONG).show();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_file_list);

        Init();

        ListView list = (ListView) findViewById(R.id.fileList);
        list.setAdapter(new MyColorListAdapter(this));

        list.setOnItemClickListener(new AdapterView.OnItemClickListener()
        {
            @Override
            public void onItemClick(AdapterView<?> parent, View v,int position, long id)
            {
                String[] arrayItem = Commin.readTXT(szFilePath, "\n");
                bundle.putInt("positionid", gidsearch);//給予特定數
                bundle.putStringArray("INVENTORY", arrayItem);
                bundle.putInt("INVENTOR2", position);
                bundle.putStringArrayList("FILE_LIST", szFileList);
                intent.putExtras(bundle);
                setResult(RESULT_OK, intent);
                finish();
            }
        });

        AdapterView.OnItemSelectedListener OnItemSelected = new AdapterView.OnItemSelectedListener()
        {
            @Override
            public void onItemSelected(AdapterView<?> parent, View v,int position, long id)
            {
                int nLen = szFileList.get(position).length();
                setTitle(szFileList.get(position).substring(nLen-17, nLen-6));
            }
            @Override
            public void onNothingSelected(AdapterView<?> arg0)
            {
            }

        };

        list.setOnItemSelectedListener(OnItemSelected);
    }

    public static class MyColorListAdapter extends BaseAdapter
    {
        private LayoutInflater mLayIfl;

        public MyColorListAdapter(Context context)
        {
            mLayIfl = LayoutInflater.from(context);
        }

        @Override
        public int getCount()
        {
            return szFileList.size();
        }

        @Override
        public Object getItem(int position)
        {
            return position;
        }

        @Override
        public long getItemId(int position)
        {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent)
        {
            TextView mItemView;

            if (convertView == null)
            {
                convertView = mLayIfl.inflate(R.layout.file_item, null);

                mItemView = (TextView) convertView.findViewById(R.id.text);

                convertView.setTag(mItemView);
                convertView.setBackgroundResource((position & 1) == 1 ? R.color.gray: R.color.white);

            } else
            {
                mItemView = (TextView) convertView.getTag();

                convertView.setBackgroundResource((position & 1) == 1 ? R.color.gray: R.color.white);
            }

            mItemView.setText(szFileList.get(position));

            int nLen = szFileList.get(position).length();
            if(Integer.parseInt(szFileList.get(position).substring(nLen-3, nLen)) == 0)
                convertView.setBackgroundResource(R.color.red);


            return convertView;
        }
    }

    public void searchFiles()
    {
        String  szTemp;

        szFileList.clear();

        File tmpFile = new File(szFilePath);

        if(!tmpFile.isFile())
            return;

        String[] arrayCars = Commin.readTXT(szFilePath, "\n");

        for(int i=0; i<arrayCars.length; ++i)
        {
            String[] arrayItem = arrayCars[i].split(";");

            if(arrayItem.length < 13)
                continue;

            if(arrayItem.length < 12)
                continue;
            String[] szTmpSpace = arrayItem[5].split(" ");


            if(0 != szSpace.compareTo(szTmpSpace[0]))
                continue;

            String szForamt = String.format("%-8s", arrayItem[7]);
            szTemp = String.format("%03d | %s| %s| %s| %s          %s|  %03d",i+1,arrayItem[3],
                    arrayItem[5].split(" ")[0],szForamt, arrayItem[10],arrayItem[1],Integer.parseInt(arrayItem[13]));
            gidsearch=i;
            szFileList.clear();
            szFileList.add(szTemp);
        }

    }

    public void listingFiles()
    {
        String szTemp;

        szFileList.clear();

        File tmpFile = new File(szFilePath);

        if(!tmpFile.isFile())
            return;

        String[] arrayCars = Commin.readTXT(szFilePath, "\n");

        for (int i = 0; i < arrayCars.length; i++)
        {
            String[] arrayItem = arrayCars[i].split(";");

            if(arrayItem.length < 13){
                continue;
            }
            String szForamt = String.format("%-8s", arrayItem[7]);
            szTemp = String.format("%03d  |  %s| %s| %s| %s          %s|  %03d",i+1,arrayItem[3],
                    arrayItem[5].split(" ")[0],szForamt.replaceAll("  ", "   "), arrayItem[10],arrayItem[1],Integer.parseInt(arrayItem[13]));

            szFileList.add(szTemp);
        }
    }
}
