package com.ecom.park_jy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.StringTokenizer;

public class FtpConn {
    private static Socket socket 		 = null;
    private static BufferedReader reader = null;
    private static BufferedWriter writer = null;

    InputStream is 	= null;
    OutputStream os = null;

    public synchronized static Boolean connect(String host, int port, String user, String pass) throws IOException
    {
        if (socket != null)
        {
            return false;
        }
        socket = new Socket(host, port);
        reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));

        String response = readLine();
        if(response.startsWith("220-"))
            response = readLine();
        if(response.startsWith("220-"))
            response = readLine();
        if (!response.startsWith("220"))
        {
            disconnect();
            return false;
        }
        sendLine("USER " + user);

        response = readLine();
        if (!response.startsWith("331 "))
        {
            disconnect();
            return false;
        }

        sendLine("PASS " + pass);

        response = readLine();
        if (!response.startsWith("230"))
        {
            throw new IOException("SimpleFTP was unable to log in with the supplied password: "+ response);
        }

        return true;
    }

    public synchronized static void disconnect() throws IOException
    {
        try
        {
            sendLine("QUIT");
        } finally
        {
            socket = null;
        }
    }

    public synchronized static boolean stor(File file) throws IOException
    {
        if (file.isDirectory())
        {
        }

        String filename = file.getName();

        return stor(new FileInputStream(file), filename);

    }

    public synchronized static boolean stor(InputStream inputStream, String filename)throws IOException
    {
        bin();
        BufferedInputStream input = new BufferedInputStream(inputStream);

        sendLine("PASV");
        String response = readLine();
        if (!response.startsWith("227"))
        {
        }

        String ip = null;
        int port = -1;
        int opening = response.indexOf('(');
        int closing = response.indexOf(')', opening + 1);
        if (closing > 0)
        {
            String dataLink = response.substring(opening + 1, closing);
            StringTokenizer tokenizer = new StringTokenizer(dataLink, ",");
            try
            {
                ip = tokenizer.nextToken() + "." + tokenizer.nextToken() + "."
                        + tokenizer.nextToken() + "." + tokenizer.nextToken();

                port = Integer.parseInt(tokenizer.nextToken()) * 256
                        + Integer.parseInt(tokenizer.nextToken());
            } catch (Exception e)
            {
                e.printStackTrace();
            }
        }

        sendLine("STOR " + filename);

        Socket dataSocket = new Socket(ip, port);

        response = readLine();
        if (!response.startsWith("125"))
        {
        }

        BufferedOutputStream output = new BufferedOutputStream(dataSocket.getOutputStream());

        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        while ((bytesRead = input.read(buffer)) != -1)
        {
            output.write(buffer, 0, bytesRead);
        }
        output.flush();
        output.close();
        input.close();

        response = readLine();

        return response.startsWith("226");
    }

    public synchronized static boolean bin() throws IOException
    {
        sendLine("TYPE I");
        String response = readLine();
        return (response.startsWith("200"));
    }

    public synchronized boolean ascii() throws IOException
    {
        sendLine("TYPE A");
        String response = readLine();
        return (response.startsWith("200"));
    }

    private static void sendLine(String line) throws IOException
    {
        if (socket == null)
        {
            throw new IOException("SimpleFTP is not connected.");
        }
        try
        {
            writer.write(line + "\r\n");
            writer.flush();
        } catch (IOException e)
        {
            disconnect();
            throw e;
        }
    }

    private static String readLine() throws IOException
    {
        String line = reader.readLine();

        return line;
    }
}
