package com.ecom.park_jy;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Gallery;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.TextView;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class ImageViewer extends AppCompatActivity {

    private Bundle bundle;
    int count = 0;
    String szPath;
    String szCale;
    String szUser;

    private TextView name_textView;

    private GridView mGallery;

    private ImageView photoViewer;

    private ImageAdapter imageAdapter;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_image_viewer);

        bundle = this.getIntent().getExtras();
        szPath = bundle.getString("PATH");
        szCale = bundle.getString("CALE");
        szUser = bundle.getString("USER");

        photoViewer = (ImageView) findViewById(R.id.imageView2);
        mGallery = (GridView)findViewById(R.id.showImg);

        findViews();

        try
        {
            imageAdapter = new ImageAdapter(this,szPath,szCale,szUser);
            mGallery.setAdapter(imageAdapter);
        } catch (IOException e)
        {
            e.printStackTrace();
        }

        mGallery.setOnItemClickListener(new AdapterView.OnItemClickListener()
        {
            public void onItemClick(AdapterView parent, View v, int position,long id)
            {
                photoViewer.setImageBitmap(imageAdapter.imgBmps.get(position));

                name_textView.setText(imageAdapter.GetPath(position));
            }
        });
    }

    private void findViews()
    {
        name_textView = (TextView) findViewById(R.id.img_name);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event)
    {
        if (keyCode == KeyEvent.KEYCODE_BACK)
        {
            imageAdapter.ClearAll();
            finish();
        }
        return true;
    }


    public class ImageAdapter extends BaseAdapter
    {
        private int mItemBG;
        private Context mContext;
        public ArrayList<String> imageList = new ArrayList<String>();
        public ArrayList<String> nameList  = new ArrayList<String>();
        public ArrayList<Bitmap> imgBmps   = new ArrayList<Bitmap>();


        public ImageAdapter(Context c,String szPath,String szCale,String szUser) throws IOException
        {
            mContext = c;

            TypedArray a = c.obtainStyledAttributes(R.styleable.Gallery);
            mItemBG = a.getResourceId(R.styleable.Gallery_android_galleryItemBackground,0);

            try
            {
                ListImages(szPath,szCale,szUser);
            } catch (IOException e)
            {
                e.printStackTrace();
            }
        }

        public void ClearAll()
        {
            imgBmps.clear();
            imageList.clear();
        }

        public String GetPath(int pos)
        {
            return nameList.get(pos);
        }

        @Override
        public int getCount()
        {
            return imageList.size();
        }

        @Override
        public Object getItem(int position)
        {
            return position;
        }

        @Override
        public long getItemId(int position)
        {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent)
        {
            ImageView imgTemp = new ImageView(mContext);

            if(imgBmps.size()<(position+1))
            {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inSampleSize = 2;
                Bitmap bm = BitmapFactory.decodeFile(imageList.get(position),options);

                imgBmps.add(bm);
            }

            imgTemp.setImageBitmap(imgBmps.get(position));
            imgTemp.setLayoutParams(new Gallery.LayoutParams(270, 180));
            imgTemp.setScaleType(ImageView.ScaleType.FIT_XY);
            imgTemp.setBackgroundResource(mItemBG);


            return imgTemp;
        }

        private void ListImages(String szPath,String szCale,String szUser) throws IOException
        {
            File fileTemp = new File(szPath);

            if(!fileTemp.isDirectory())
                return;

            if(fileTemp.listFiles(new FilesFilter(szUser,szCale,"jpg",false)).length > 0)
            {
                for(File file : fileTemp.listFiles(new FilesFilter(szUser,szCale,"jpg",true)))
                {
                    String szPathTemp = szPath +"/"+ file.getName();
                    File fTemp = new File(szPathTemp);

                    if(!fTemp.isFile())
                        return;

                    nameList.add(file.getName());
                    imageList.add(szPathTemp);
                }
            }

            if(imageList.size() <1)
                name_textView.setText("沒有照片，請拍照");
        }
    };

    public void img_touch(View v){
        Intent intent = new Intent(ImageViewer.this,img_demo.class);
        Bundle bundle = new Bundle();
        if(!name_textView.getText().toString().equals("沒有照片，請拍照")){
            bundle.putString("Img_name",name_textView.getText().toString());
            intent.putExtras(bundle);
            startActivity(intent);
        }
    }
}
