﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ETC_App1
{
    
    public partial class Form1 : Form
    {
        private int index = 0;

        public Form1()
        {
            InitializeComponent();
        }

        private int ToolStripWidth
        {
            set
            {
                int width = value;

                toolStripComboBox1.Size = new Size(etcToolStrip1.UnusedWidth / 7, toolStripTextBox1.Size.Height);

                toolStripTextBox1.Size = new Size(etcToolStrip1.UnusedWidth / 7, toolStripTextBox1.Size.Height);

                toolStripTextBox2.Size = new Size(etcToolStrip1.UnusedWidth / 7, toolStripTextBox1.Size.Height);

                width = width - toolStripComboBox1.Size.Width - toolStripTextBox1.Size.Width - toolStripTextBox2.Size.Width;

                toolStripTextBox3.Size = new Size(width / 2, toolStripTextBox1.Size.Height);

                toolStripTextBox4.Size = new Size(width / 2, toolStripTextBox1.Size.Height);
            }
        }

        private bool IsLock
        {
            set
            {
                etcPictureCheckBox1.Visible = !value;

                toolStripTextBox1.Enabled = toolStripTextBox2.Enabled = value;

                toolStripButton1.Text = value ? "登入" : "登出";

                toolStripTextBox3.Enabled = toolStripTextBox4.Enabled = toolStripComboBox1.Enabled = !value;

                toolStripButton2.Enabled = toolStripButton3.Enabled = !value;

                toolStripButton4.Enabled = toolStripButton6.Enabled = !value;

                toolStripButton5.Enabled = false;
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            TextBox textBox = toolStripTextBox2.Control as TextBox;
            
            textBox.PasswordChar = '*';

            ToolStripWidth = etcToolStrip1.UnusedWidth;

            //StatusStripWidth = etcStatusStrip1.Size.Width;

            IsLock = true;

            Text = "E-Eye 電子眼圖像辨識系統";
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
            //Clipboard.SetText(Size.Width + "," + Size.Height);

            //Text = ClientSize.Width + "x" + ClientSize.Height;
        }

        private void EtcToolStrip1_Resize(object sender, EventArgs e)
        {
            ToolStripWidth = etcToolStrip1.UnusedWidth;
        }

        private void ToolStripButton1_Click(object sender, EventArgs e)
        {
            //int change=0;
            string ID = toolStripTextBox1.Text;
            string Password = toolStripTextBox2.Text;       //取得輸入的帳密
                                                            //if (change == 0)
                                                            //{
            if (Authentication.Authentication_1(ID, Password))
            {
                //change = 1;
                etcPictureCheckBox1.UsingID = ID;
                IsLock = false;                         //登入成功
            }
            //}
            /*
            else if (change == 1)
            {
                change = 0;
                IsLock = true;
            }
            */
        }


        private void ToolStripButton2_Click(object sender, EventArgs e)
        {
            string text = toolStripTextBox3.Text;

            toolStripTextBox3.Text = openFileDialog1.ShowDialog() == DialogResult.OK ? openFileDialog1.FileName : text;
        }

        private void ToolStripTextBox3_TextChanged(object sender, EventArgs e)
        {
            string text = toolStripTextBox3.Text;

            if (File.Exists(text) && !etcBackgroundWorker11.IsBusy)
            {
                toolStripTextBox3.ToolTipText = Path.GetFileName(text);

                toolStripTextBox4.Text = Path.GetDirectoryName(text);

                etcPictureCheckBox1.Clear();

                etcBackgroundWorker11.RunWorkerAsync(text);
            }
            else
                toolStripTextBox3.Text = etcBackgroundWorker11.Filename;
        }

        private void EtcBackgroundWorker11_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            etcPictureCheckBox1.ToolStripStatusLabel1 = e.UserState as string;

            toolStripButton1.Enabled = toolStripButton2.Enabled = false;

            toolStripComboBox1.Enabled = false;

            toolStripButton4.Enabled = toolStripButton5.Enabled = toolStripButton6.Enabled = false;
        }

        private void EtcBackgroundWorker11_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            Dictionary<string, List<Dictionary<string, string>>> data = e.Result as Dictionary<string, List<Dictionary<string, string>>>;

            etcBackgroundWorker31.Data.Clear();

            etcBackgroundWorker31.Data = data;

            toolStripButton1.Enabled = toolStripButton2.Enabled = true;

            toolStripComboBox1.Enabled = true;

            toolStripComboBox1.Items.AddRange(etcBackgroundWorker31.Data.Keys.ToArray());

            toolStripComboBox1.SelectedIndex = toolStripComboBox1.Items.Count > 0 ? 0 : -1;

            toolStripButton4.Enabled = toolStripButton6.Enabled = true;
        }

        private void ToolStripComboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            int index = toolStripComboBox1.SelectedIndex;

            string key = index > -1 ? toolStripComboBox1.Items[index].ToString() : etcBackgroundWorker31.SelectedKey;

            etcBackgroundWorker31.SelectedKey = key;
        }
        private void toolStripButton3_Click(object sender, EventArgs e)
        {
            string text = toolStripTextBox4.Text;

            toolStripTextBox4.Text = folderBrowserDialog1.ShowDialog() == DialogResult.OK ? folderBrowserDialog1.SelectedPath : text;
        }

        private void toolStripTextBox4_TextChanged(object sender, EventArgs e)
        {
            string text = toolStripTextBox4.Text;

            if (Directory.Exists(text) && !etcBackgroundWorker21.IsBusy)
            {
                toolStripTextBox4.ToolTipText = Path.GetFileName(text);

                etcBackgroundWorker21.RunWorkerAsync(text);
            }
            else
                toolStripTextBox4.Text = etcBackgroundWorker21.Filename;
        }

        private void etcBackgroundWorker21_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            etcPictureCheckBox1.ToolStripStatusLabel2 = e.UserState as string;

            toolStripButton1.Enabled = toolStripButton3.Enabled = false;

            toolStripButton4.Enabled = toolStripButton5.Enabled = toolStripButton6.Enabled = false;
        }

        private void etcBackgroundWorker21_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            etcBackgroundWorker31.Images.Clear();

            etcBackgroundWorker31.Images = e.Result as Dictionary<string, string>;

            toolStripButton1.Enabled = toolStripButton3.Enabled = true;

            toolStripButton4.Enabled = toolStripButton6.Enabled = true;
        }

        private void ToolStripButton4_Click(object sender, EventArgs e)
        {
            toolStripComboBox1.Items.Clear();
            if (!etcBackgroundWorker31.IsBusy)
            {
                etcBackgroundWorker31.RunWorkerAsync(index);
            }
        }
        private void EtcBackgroundWorker31_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            if (e.UserState is Json)
            {
                etcPictureCheckBox1.Add(e.UserState as Json);
            }
            else
            {
                etcPictureCheckBox1.ToolStripStatusLabel4 = e.UserState as string;
            }

            etcPictureCheckBox1.ToolStripProgressBar = e.ProgressPercentage;

            etcPictureCheckBox1.ToolStripStatusLabel1 = "完成正確：" + etcPictureCheckBox1.Success;

            etcPictureCheckBox1.ToolStripStatusLabel2 = "資料異常：" + etcPictureCheckBox1.Failed;

            etcPictureCheckBox1.ToolStripStatusLabel3 = "影像遺失：" + etcPictureCheckBox1.Lost;

            toolStripButton1.Enabled = toolStripButton3.Enabled = false;

            toolStripButton4.Enabled = toolStripButton6.Enabled = false;

            toolStripButton5.Enabled = true;
        }

        private void EtcBackgroundWorker31_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            toolStripButton1.Enabled = toolStripButton3.Enabled = true;

            toolStripButton4.Enabled = toolStripButton6.Enabled = true;

            toolStripButton5.Enabled = false;

            index = Convert.ToInt32(e.Result);
        }

        private void ToolStripButton5_Click(object sender, EventArgs e)
        {
            etcBackgroundWorker11.CancelAsync();

            etcBackgroundWorker21.CancelAsync();

            etcBackgroundWorker31.CancelAsync();
        }

        private void ToolStripButton6_Click(object sender, EventArgs e)
        {
            etcPictureCheckBox1.SaveLogs(toolStripTextBox4.Text);
        }
    }
}
