from sklearn.externals import joblib
from sklearn.preprocessing import LabelEncoder
import numpy as np
import os

svm_path=os.path.abspath('./nas/Face/model/svm')
svm_version=max(os.listdir(svm_path))
print('svm version:',svm_version)
# 載入SVM分類器
clf=joblib.load(os.path.join(svm_path,svm_version,svm_version+'.pkl'))
# 載入LabelEncoder
le=LabelEncoder()
le.classes_ =np.load(os.path.join(svm_path,svm_version,'classes.npy'))
print("SVM分類器載入完成")

# Labels 解析回傳結果與分數
def get_labelsNconfidence(le,clf,embs):
    socres=clf.predict_proba(embs)
    results=[]
    confidences=[]
    for s in socres:
        results.append(le.inverse_transform([s.argmax()])[0])
        confidences.append(s[s.argmax()])
    return results,confidences

def result(embs):
    global le
    global clf
    return get_labelsNconfidence(le,clf,embs)