
# coding: utf-8

# In[ ]:


import tkinter as tk
import cv2
from PIL import Image,ImageTk
import time
from datetime import datetime 
from face_predict import *
from influxdb import InfluxDBClient


# In[ ]:


#Set up GUI
window = tk.Tk()  #Makes main window
window.wm_title("人臉辨識打卡系統")
window.config(background="#FFFFFF")


# In[ ]:


#Graphics window
imageFrame = tk.Frame(window, width=600, height=500)
imageFrame.grid(row=1, column=0,rowspan=4, padx=10, pady=2)


# In[ ]:


#Capture video frames
lmain = tk.Label(imageFrame)
lmain.grid(row=0, column=0)
cap = cv2.VideoCapture(0)


# In[ ]:


# result
status_label=tk.Label(window,text='歡迎使用本系統',font=("標楷體", 20))
status_label.grid(row=0,column=0,columnspan=3)
time_label=tk.Label(window,text='時間:',font=("標楷體", 20))
time_label.grid(row=1,column=1)
t=tk.Label(window,text='2019-06-19',font=("Times New Roman", 20))
t.grid(row=2,column=1)
name_label=tk.Label(window,text='姓名: ',font=("標楷體", 20))
name_label.grid(row=3,column=1)
name=tk.Label(window,text='Allen',font=("Times New Roman", 20))
name.grid(row=4,column=1)


# In[ ]:


def clock(status):
    if(status=='login_'):
        msg='開始上班辨識打卡'
    else:
        msg='開始下班辨識打卡'
    status_label['text']=msg
    login_time=time.time()
    ret,frame=cap.read()
    if(ret):
        frame = cv2.flip(frame, 1)
        result=infer(le,clf,frame)
        if(len(result)==2):
            status_label['text']='辨識完成 請確認資料'
            t['text']=time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(login_time))
            name['text']=str(result[1])
            login_button.configure(text="是",command=lambda:submit(status,result[1],login_time))
            logout_button.configure(text="否",command=retry)
        else:
            status_label['text']='偵測不到請重新調整位置' 

def submit(measurments,name,time):
    if(measurments=='login_'):
        msg='上班加油!!'
        influxdb_insert(measurments,name,time)
    else:
        msg='上班辛苦了 下班好好休息吧!!'
    status_label['text']=msg
    status_label.after(3000,func=empty_result)
def empty_result():
    status_label['text']='歡迎使用本系統'
    t['text']=''
    name['text']=''
    login_button.configure(text="上班打卡",command=lambda:clock('login_'))
    logout_button.configure(text="下班打卡",command=lambda:clock('logout_'))
def retry():
    error_window=tk.Toplevel(window)
    error_window.geometry('300x200')
    error_window.title('請輸入您的姓名 以利後續訓練')
    tk.Label(error_window,text='姓名: ',font=("標楷體", 20)).grid(row=0,column=0)
    currect_name=tk.StringVar()
    entry_currect_name = tk.Entry(error_window, textvariable=currect_name)
    entry_currect_name.grid(row=0,column=1)
    button_submit=tk.Button(error_window,text='提交',font=("標楷體", 20))
    button_submit.grid(row=1,column=0,columnspan=2)


# In[ ]:


def influxdb_insert(measurments,name,time):
    # 建立資料庫連線
    client=InfluxDBClient(host='192.168.5.17',port=8086,username='root',password='root',database='RD')
    json_body = [
        {
            "measurement": measurments,
            "time": datetime.utcfromtimestamp(time),
            "fields": {
                "name": name[0],
                'snapshot':name[0]+'.jpg'
            }
        }
    ]
    client.write_points(json_body)
    client.close()


# In[ ]:


# button
login_button= tk.Button(window,text="上班打卡",command=lambda:clock('login_'),font=("標楷體", 20))
login_button.grid(row=5,column=0)
logout_button= tk.Button(window,text="下班打卡",command=lambda:clock('logout_'),font=("標楷體", 20))
logout_button.grid(row=5,column=1)


# In[ ]:


def show_frame():
    _, frame = cap.read()
    frame = cv2.flip(frame, 1)
    
    faces = face_cascade.detectMultiScale(frame,scaleFactor=1.1,minNeighbors=3)
    if(len(faces)>0):
        for f in faces:
            x,y,w,h=f
            margin=10
            cv2.rectangle(frame,(x-margin//2,y-margin//2),(x+w+margin//2,y+h+margin//2),(0,0,255))
    cv2.putText(frame,time.strftime("%Y-%m-%d %H:%M:%S", time.localtime()),(0,30)
    ,cv2.FONT_HERSHEY_TRIPLEX,1, (0, 255, 255), 1, cv2.LINE_AA)        
    cv2image = cv2.cvtColor(frame, cv2.COLOR_BGR2RGBA)
    img = Image.fromarray(cv2image)
    imgtk = ImageTk.PhotoImage(image=img)
    lmain.imgtk = imgtk
    lmain.configure(image=imgtk)
    lmain.after(10, show_frame)


# In[ ]:


show_frame()  #Display 2
window.mainloop()  #Starts GUI


# In[ ]:


#Slider window (slider controls stage position)
# sliderFrame = tk.Frame(window, width=600, height=100)
# sliderFrame.grid(row = 600, column=0, padx=10, pady=2)


# In[ ]:


img=cv2.imread('../data/Test/test1.jpg')
cv2img=cv2.cvtColor(img,cv2.COLOR_BGR2RGB)
imgtk=ImageTk.PhotoImage(Image.fromarray(cv2img))
lmain.imgtk = imgtk
lmain.configure(image=imgtk)
root.mainloop()


# In[ ]:


from influxdb import InfluxDBClient


# In[ ]:


# 建立資料庫連線
client=InfluxDBClient(host='192.168.5.17',port=8086,username='root',password='root',database='RD')


# In[ ]:


json_body = [
    {
        "measurement": "login_",
        "time": datetime.utcfromtimestamp(time.time()),
        "fields": {
            "name": 'test2',
            'snapshot':"test.jpg"
        }
    }
]
client.write_points(json_body)
client.close()


# In[ ]:


from datetime import datetime


# In[ ]:


datetime.utcfromtimestamp(time.time())


# In[ ]:


time.strftime("%Y-%m-%d %H:%M:%S", time.localtime(time.time()))

