from datetime import datetime
import pytz 
import time
from threading import Thread

class OSD:
    def __init__(self,local='Asia/Taipei',str_format="%Y-%m-%d %H:%M:%S"):
        self.tz = pytz.timezone(local)
        self.utc = datetime.utcnow()
        self.local_time = pytz.utc.localize(self.utc, is_dst=None).astimezone(self.tz)
        self.str_format = str_format
        self.str_time = self.local_time.strftime(self.str_format)
        self.isOpened = False
        self.thread = Thread(target=self.update_job)
    def update_job(self):
        while(self.isOpened):
            self.utc = datetime.utcnow()
            self.local_time = pytz.utc.localize(self.utc, is_dst=None).astimezone(self.tz)
            self.str_time = self.local_time.strftime(self.str_format)
            time.sleep(0.1)
    def set_local(self,local):
        self.tz = pytz.timezone(local)
    def get_lcaol(self):
        return self.local
    def set_str_format(self,str_format):
        self.str_format = pytz.timezone(str_format)
    def get_str_format(self):
        return self.str_format
    def start(self):
        print("start OSD")
        self.isOpened = True
        self.thread.start()
    def stop(self):
        print("stop OSD")
        self.isOpened = False