#!/usr/bin/env python
# coding: utf-8

from PyQt5 import QtWidgets
from PyQt5.QtWidgets import *
from PyQt5.QtCore import *
from PyQt5.QtGui import *

import Ui_MainWindow as ui

from uvc_thermal import Thermal
from camera import Camera
from detector import FaceDetector
from anti import AntiSpoofing
from heater import Heater
from aligner import BoxAligner
from correcter import Correcter

import cv2
import numpy as np
import time

class Main(QMainWindow, ui.Ui_MainWindow):
    def __init__(self):
        super().__init__()
        self.setupUi(self)
        self.resize(640,480)
        self.label.setScaledContents(True)
        self.label_2.setScaledContents(True)
        #self.thermal = Thermal(width=160, height=120, framerate=9, frame_width=160, frame_height=120, log=None)
        self.camera = Camera(width=640, height=480, framerate=30, log=None, channel=0, flip=1)
        #self.thermal.start()
        time.sleep(2)
        self.camera.start()
        time.sleep(2)
        self.num_frame = 0
        self.painter = QPainter(self)
    def paintEvent(self, QPaintEvent):
        # 繪圖事件
        ret, frame = self.camera.capture()
        #thermal_ret,thermal_frame, thermal_row = self.thermal.capture()
        thermal_ret = True
        if(thermal_ret and ret):
            self.num_frame+=1
            # 顯示至UI
            frame=cv2.cvtColor(frame,cv2.COLOR_BGR2RGB)
            #thermal_frame=cv2.cvtColor(thermal_frame,cv2.COLOR_BGR2RGB)
            Qframe=QImage(frame.data,frame.shape[1],frame.shape[0],frame.shape[1]*3,QImage.Format_RGB888)
            #Qthermal_frame=QImage(thermal_frame.data,thermal_frame.shape[1],thermal_frame.shape[0],thermal_frame.shape[1]*3,QImage.Format_RGB888)
            pixMap=QPixmap.fromImage(Qframe)
            #thermal_pixMap=QPixmap.fromImage(Qthermal_frame)
            self.label.setPixmap(pixMap)
            #self.label_2.setPixmap(thermal_pixMap)
            self.update()
    def closeEvent(self,event):
        # 關閉程式後執行
        #self.thermal.stop()
        self.camera.stop()


if __name__ == '__main__':
    import sys
    import os
    app = QtWidgets.QApplication(sys.argv)
    window = Main()
    window.show()
    status = app.exec_()
    time.sleep(1)
#     sys.exit(app.exec_())
    os._exit(status)

