import cv2
import numpy as np

class BoxAligner:
    def __init__(self,img_h,img_w):
        self.img_h = img_h
        self.img_w = img_w
        # 120*160 usb theraml
#         self.M = np.array([[ 8.13802980e-01, -2.63523694e-02, 9.30324875e+01],
#                            [ 2.10292692e-02, 7.84319221e-01,  7.70246127e+01],
#                            [ 1.48500793e-04, -1.53618915e-04, 1.00000000e+00]])

        self.M = np.array([[ 9.71130799e-01,  1.34161454e-02,  1.56875961e-01],
                           [-2.63476275e-03,  9.22184449e-01,  5.15727605e-01],
                           [-3.24243700e-05, -1.80459430e-04,  1.00000000e+00]])
        # IRM 80*62
#         self.M = np.array([[ 9.85839634e-01,  7.87864361e-01, -1.84091518e+02],
#                            [-2.12006655e-02,  2.12582929e+00, -2.34772300e+02],
#                            [-1.22150683e-03,  1.38217520e-03,  1.00000000e+00]])

        
    def box_aligment(self,boxes):
        aliged_boxes = []
        for b in boxes:
            x1,y1,w1 = np.dot(self.M,[b[0],b[1],1])
            x2,y2,w2 = np.dot(self.M,[b[2],b[3],1])
            x1 = max(int(x1),0)
            y1 = max(int(y1),0)
            x2 = min(int(x2),self.img_w)
            y2 = min(int(y2),self.img_h)
            aliged_boxes.append([x1,y1,x2,y2])
        return aliged_boxes
    def get_omography_matrix(self,rgb_points, thermal_points):
        h, mask = cv2.findHomography(rgb_points, thermal_points, cv2.RANSAC)
        self.M = h
