import cv2
import numpy as np
from keras.models import Sequential
from keras.layers import Dense, Dropout, Activation, Flatten
from keras.layers import Conv2D, MaxPool2D
from keras.optimizers import SGD
from keras import backend as K
import tensorflow as tf

def constructmodel(nb_classes):
 # nb_classes = len(charset)
    img_rows, img_cols = 9, 34
    # number of convolutional filters to use
    nb_filters = 32
    # size of pooling area for max pooling
    nb_pool = 2
    # convolution kernel size
    nb_conv = 3
    model = Sequential()
    model.add(Conv2D(16, (5, 5),input_shape=(img_rows, img_cols,3)))
    model.add(Activation('relu'))
    model.add(MaxPool2D(pool_size=(nb_pool, nb_pool)))
    model.add(Flatten())
    model.add(Dense(64))
    model.add(Activation('relu'))
    model.add(Dropout(0.5))
    model.add(Dense(nb_classes))
    model.add(Activation('softmax'))
    model.compile(loss='categorical_crossentropy',
                  optimizer='adam',
                  metrics=['accuracy'])
#     model.summary()

    return model

def load_model():
    global model1
    model1.load_weights("./model/two_type_judge.h5")
    # this is key : save the graph after loading the model
    global graph1
    graph1 = tf.get_default_graph()
    
model1 = constructmodel(2)
load_model()

def SimplePredict(image):
    image = cv2.resize(image, (34, 9))
    image = image.astype(np.float) / 255
    with graph1.as_default():
        res = np.array(model1.predict(np.array([image]))[0])
#     print(res)
    return res.argmax()