#coding=utf-8
import cv2
import numpy as np
import tensorflow as tf

# from matplotlib import pyplot as plt
import scipy.ndimage.filters as f
import scipy

import time
import scipy.signal as l


import os
os.environ["CUDA_DEVICE_ORDER"] = "PCI_BUS_ID"   # see issue #152
os.environ["CUDA_VISIBLE_DEVICES"] = ""



from keras.models import Sequential
from keras.layers import Dense, Dropout, Activation, Flatten
from keras.layers import Conv2D, MaxPool2D
from keras.optimizers import SGD
from keras import backend as K

K.set_image_dim_ordering('tf')


def Getmodel_tensorflow(nb_classes):
    # nb_classes = len(charset)
    img_rows, img_cols = 23, 23
    # number of convolutional filters to use
    nb_filters = 16
    # size of pooling area for max pooling
    nb_pool = 2
    # convolution kernel size
    nb_conv = 3
    # x = np.load('x.npy')
    # y = np_utils.to_categorical(range(3062)*45*5*2, nb_classes)
    # weight = ((type_class - np.arange(type_class)) / type_class + 1) ** 3
    # weight = dict(zip(range(3063), weight / weight.mean()))  # 调整权重，高频字优先

    model = Sequential()
    model.add(Conv2D(nb_filters, (nb_conv, nb_conv),input_shape=(img_rows, img_cols,1)))
    model.add(Activation('relu'))
    model.add(MaxPool2D(pool_size=(nb_pool, nb_pool)))
    model.add(Conv2D(nb_filters, (nb_conv, nb_conv)))
    model.add(Activation('relu'))
    model.add(MaxPool2D(pool_size=(nb_pool, nb_pool)))
    model.add(Flatten())
    model.add(Dense(256))
    model.add(Dropout(0.5))

    model.add(Activation('relu'))
    model.add(Dense(nb_classes))
    model.add(Activation('softmax'))
    model.compile(loss='categorical_crossentropy',
                  optimizer='sgd',
                  metrics=['accuracy'])
    return model

def load_model():
    global model2
    model2.load_weights("./model/char_judgement_0723.h5") ##0722
    # this is key : save the graph after loading the model
    global graph
    graph = tf.get_default_graph()

model2  = Getmodel_tensorflow(3)
import os
load_model()


def get_median(data):
    data = sorted(data)
    size = len(data)
#     print(data)
   # print size

    if size % 2 == 0: # 判断列表长度为偶数
        median = (data[size//2]+data[size//2-1])//2
        data[0] = median
    if size % 2 == 1: # 判断列表长度为奇数
        median = data[(size-1)//2]
        data[0] = median
    return data[0]
import time

  

from hyperlpr import recognizer as cRP
from hyperlpr import niblack_thresholding as nt


def py_cpu_nms(dets, thresh):
    """Pure Python NMS baseline."""
    x1 = dets[:, 0]  #xmin
    y1 = dets[:, 1]  #ymin
    x2 = dets[:, 2]  #xmax
    y2 = dets[:, 3]  #ymax
    scores = dets[:, 4]  #confidence

    areas = (x2 - x1 + 1) * (y2 - y1 + 1)  #the size of bbox
    order = scores.argsort()[::-1]  #sort bounding boxes by decreasing order, returning array([3, 1, 2, 0])

    keep = []        # store the final bounding boxes
    while order.size > 0:
        i = order[0] #the index of the bbox with highest confidence
        if scores[i]<0.3:
            break
        keep.append(i)    #save it to keep
        xx1 = np.maximum(x1[i], x1[order[1:]]) #array([ 257.,  280.,  255.])
        yy1 = np.maximum(y1[i], y1[order[1:]]) #array([ 118.,  135.,  118.])
        xx2 = np.minimum(x2[i], x2[order[1:]]) #array([ 360.,  360.,  358.])
        yy2 = np.minimum(y2[i], y2[order[1:]]) #array([ 235.,  235.,  235.])

        w = np.maximum(0.0, xx2 - xx1 + 1)   #array([ 104.,   81.,  104.])
        h = np.maximum(0.0, yy2 - yy1 + 1)   #array([ 118.,  101.,  118.])
        inter = w * h   #array([ 12272.,   8181.,  12272.])

        # Cross Area / (bbox + particular area - Cross Area)
        ovr = inter / (areas[i] + areas[order[1:]] - inter)
        #reserve all the boundingbox whose ovr less than thresh
        inds = np.where(ovr <= thresh)[0]
        order = order[inds + 1]

    return keep
    
def cutWords_withScore(keep,mid,image):
    point=keep
    w=mid
    refined=[]
    for i in point:
        img1=image[0:36,i:i+w+3]
#             cv2.imshow('s',img1)
#             cv2.waitKey(0)
#             cv2.destroyAllWindows()
        refined.append(img1)
    return refined

def nms_get_point(p,mid):
    dets=[]
    for j,i in enumerate(p):
        dets.append([j,36,23+j,36,i])
    dets=np.array(dets)
    if mid > 18:
        thresh = 0.25
    elif mid <=14:
        thresh=0.35
    else:
        thresh=0.3
    keep=py_cpu_nms(dets,thresh)
    keep=sorted(keep)
    return keep


def slidingWindowsEval(image,nums):
#     image=slidingWindowsRough(image)
#     image = cv2.imread("test10.png",cv2.IMREAD_GRAYSCALE)
    width_test=image.shape[1]    
    image = cv2.resize(image,(136,36),interpolation = cv2.INTER_AREA)

    cv2.bitwise_not(image,image)
    
    windows_size = 23;
    stride = 1
    height= image.shape[0]
    t0 = time.time()
    data_sets = []

    for i in range(0,image.shape[1]-windows_size+1,stride):
        data = image[0:height,i:i+windows_size]
        data = cv2.resize(data,(23,23))
        # cv2.imshow("image",data)
        data = cv2.equalizeHist(data)
        data = data.astype(np.float)/255
        data=  np.expand_dims(data,3)
        data_sets.append(data)
        
    with graph.as_default():
        res = model2.predict(np.array(data_sets))
#     print("分割",time.time() - t0)

    pin = res
    p = 1 -  (res.T)[1]
#     pin[:,2]=f.gaussian_filter1d(np.array(pin[:,2],dtype=np.float),3)
#     dash=[]
#     for i in range(len(pin[:,2])):
#         if pin[i,2] >= 0.12:
#             dash.append([pin[i,2],i])
#     dash=sorted(dash,key=lambda x:x[0],reverse = True)
#     for j,k in enumerate(dash):
#         if j >=6:
#             break
#         p[k[1]]=0
    p=p-pin[:,2]
    p = f.gaussian_filter1d(np.array(p,dtype=np.float),3)
    

    lmin = l.argrelmax(np.array(p),order = 3)[0]
    interval = []
    for i in range(len(lmin)-1):
        interval.append(lmin[i+1]-lmin[i])

    if(len(interval)>2):
        mid  = get_median(interval)
#         print('mid',mid)
    else:
        print('mid none')
#         cv2.imwrite("./mid_none/"+str(filename),image)
        return None,None,None,None,None,None,None,None
    keep=nms_get_point(p,mid)
    
    cut_data=p,lmin,pin
    
    refined=cutWords_withScore(keep,mid,image)
    
    
    confidence=0.00
    name = ""
    new_LP=False
    temp=[]

    t0 = time.time()
    nums=len(refined)

    for i,one in enumerate(refined):
#         cv2.imwrite(os.path.join("./Train",str(i)+'.jpg'),one)
        if len(temp)==3:
            if temp[2]-temp[1] == temp[1]-temp[0]:
                new_LP=True
#                 print('new_LP',temp)
            else:
                temp=[]
        res_pre = cRP.SimplePredict(one, i ,nums,new_LP)
        if  res_pre[1].encode( 'UTF-8' ).isalpha():
            temp.append(i)
                
#             print(res_pre[1])
        confidence+=res_pre[0]
        name+= res_pre[1]
    if nums > 7:
        print('check_new_LP')
        for j,k in enumerate(name):
            if k.encode( 'UTF-8' ).isalpha() and j+7<=len(name):
                print('ok')
                if name[j+1].encode( 'UTF-8' ).isalpha() and name[j+2].encode( 'UTF-8' ).isalpha():
                        if name[j+3] == "-":
                            name=name[j:j+8]
                        else:
                            name=name[j:j+7]
                        nums=7
                        break
           
               
            
    
#    print("字符识别",time.time() - t0)
    
    return refined,name,confidence,nums,cut_data,mid,lmin,width_test
