from base_resource import BaseResource
from test_model import UserFeatureModel
import os

# ========== 新增 ==========
class UserFeatureInsert(BaseResource):
    def __init__(self):
        super().__init__("InsertUserFeature")
        self.parser.add_argument('id', required=True, help="使用者編號，上限10字")
        self.parser.add_argument('features', help="使用者特徵")
        self.parser.add_argument('description', help="使用者特徵描述，上限20字")
    def post(self):
        args = self.parser.parse_args()
        model = UserFeatureModel.FromDB(args['id'], self.log.SetMessage)
        if not model.isExist:
            model.SetID(args['id'])
            model.SetFeatures(args['features'])
            model.SetDescription(args['description'])
            if model.InsertToDB(self.log.SetMessage):
                self.message = "{0} inserted".format(args['id'])
            else:
                self.message = "{0} insert failed".format(args['id'])
        else:
            self.message = "{0} is exist in database".format(args['id'])
        return self.GetResponse()

# ========== 更新 ==========
class UserFeatureUpdate(BaseResource):
    def __init__(self):
        super().__init__("UpdateUserFeature")
        self.parser.add_argument('id', required=True, help="使用者編號")
        self.parser.add_argument('features', help="使用者特徵")
        self.parser.add_argument('description', help="使用者特徵描述")
    def post(self):
        args = self.parser.parse_args()
        model = UserFeatureModel.FromDB(args['id'], self.log.SetMessage)
        if model.isExist:
            model.SetFeatures(args['features'])
            model.SetDescription(args['description'])
            if model.UpdateToDB(self.log.SetMessage):
                self.message = []
                if model.HasChangeFeatures():
                    self.message.append(
                        "Features: {0} -> {1}".format(model.GetOldFeatures(), model.GetFeatures())
                    )
                if model.HasChangeDescription():
                    self.message.append(
                        "Description: {0} -> {1}".format(model.GetOldDescription(), model.GetDescription())
                    )
                self.message = ", ".join(self.message) if len(self.message) > 0 else ""
            else:
                self.message = "{0} failed".format(args['id'])
        else:
            self.message = "{0} isn't exist in database".format(args['id'])
        return self.GetResponse()
# ========== 刪除裝置資源 ==========
class UserFeatureDelete(BaseResource):
    def __init__(self):
        super().__init__("DeleteUserFeature")
        self.parser.add_argument('id', required=True)
    def post(self):
        args = self.parser.parse_args()
        model = UserFeatureModel.FromDB(args['id'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "{0} deleted".format(args['id'], model.GetNow())
            else:
                self.message = "{0} delete failed".format(args['id'])
        else:
            self.message = "{0} isn't exist in database".format(args['id'])
        return self.GetResponse()
# ========== 查詢所有裝置資源 ==========
class UserFeatureSelectAll(BaseResource):
    def __init__(self):
        super().__init__("SelectAllUserFeature")
    def post(self, ID=None):
        models = UserFeatureModel.AllFromDB(self.log.SetMessage)
        if len(models) > 0:
            self.data = []
            for model in models:
                self.data.append(model.ToDict())
            self.message = "{0} selected".format(len(self.data))
        else:
            self.message = "no data in database"
        return self.GetResponse()
        
# date time set
class SetDateTime(BaseResource):
    def __init__(self):
        super().__init__("SetDateTime")
    def get(self, dt):
        os.system('date -s \"{}\"'.format(dt.replace("-"," ")))
        return self.GetResponse()
