from base_resource import BaseResource
from mysql_model import UserRoleModel

# ========== 新增使用者角色資源 ==========
class UserRoleInsert(BaseResource):
    def __init__(self):
        super().__init__()
        self.parser.add_argument('name', required=True, help="上限 10 字")
    def post(self):
        args = self.parser.parse_args()
        model = UserRoleModel.FromName(args['name'], self.log.SetMessage)
        if not model.isExist:
            model.SetName(args['name'])
            if model.InsertToDB(self.log.SetMessage):
                self.message = "User role {0} insert to database at {1}".format(args['name'], model.GetNow())
            else:
                self.message = "User role {0} insert to database failed".format(args['name'])
        else:
            self.message = "User role {0} is exist in database".format(args['name'])
        return self.GetResponse()
# ========== 更新使用者角色資源 ==========
class UserRoleUpdate(BaseResource):
    def __init__(self):
        super().__init__()
        self.parser.add_argument('id', required=True, help="上限 10 字")
        self.parser.add_argument('name', help="上限 10 字")
    def post(self):
        args = self.parser.parse_args()
        model = UserRoleModel.FromDB(args['id'], self.log.SetMessage)
        if model.isExist:
            model.SetName(args['name'])
            if model.UpdateToDB(self.log.SetMessage):
                if model.HasChangeName():
                    self.message.append(
                        "Name: {0} -> {1}".format(model.GetOldName(), model.GetName())
                    )
                self.message = ", ".join(self.message) if len(self.message) > 0 else ""
            else:
                self.message = "{0} update failed".format(args['id'])
        else:
            self.message = "{0} isn't exist in database".format(args['id'])
        return self.GetResponse()
# ========== 刪除使用者角色資源 ==========
class UserRoleDelete(BaseResource):
    def __init__(self):
        super().__init__()
        self.parser.add_argument('id')
    def post(self):
        args = self.parser.parse_args()
        model = UserRoleModel.FromDB(args['id'], self.log.SetMessage)
        if model.isExist:
            if model.DeleteFromDB(self.log.SetMessage):
                self.message = "{0} deleted".format(args['id'])
            else:
                self.message = "{0} delete failed".format(args['id'])
        else:
            self.message = "{0} isn't exist in database".format(args['id'])
        return self.GetResponse()
# ========== 查詢所有使用者角色資源 ==========
class UserRoleSelectAll(BaseResource):
    def __init__(self):
        super().__init__()
    def post(self):
        args = self.parser.parse_args()
        model = UserRoleModel.SelectAllFromDB(self.log.SetMessage)
        json_data_list=[]
        for line in model:
            json_data={}
            json_data["id"]=line[0]
            json_data["name"]=line[1]
            json_data_list.append(json_data)
        self.data=json_data_list
        return self.GetResponse()