/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.ajp.AjpProcessor;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractAjpProtocol<S>
extends AbstractProtocol<S> {
    protected static final StringManager sm = StringManager.getManager(AbstractAjpProtocol.class);
    private boolean ajpFlush = true;
    private boolean tomcatAuthentication = true;
    private boolean tomcatAuthorization = false;
    private String requiredSecret = null;
    private int packetSize = 8192;

    public AbstractAjpProtocol(AbstractEndpoint<S, ?> endpoint) {
        super(endpoint);
        this.setConnectionTimeout(-1);
        this.getEndpoint().setUseSendfile(false);
        AbstractProtocol.ConnectionHandler cHandler = new AbstractProtocol.ConnectionHandler(this);
        this.setHandler(cHandler);
        this.getEndpoint().setHandler(cHandler);
    }

    @Override
    protected String getProtocolName() {
        return "Ajp";
    }

    @Override
    protected AbstractEndpoint<S, ?> getEndpoint() {
        return super.getEndpoint();
    }

    @Override
    protected UpgradeProtocol getNegotiatedProtocol(String name) {
        return null;
    }

    @Override
    protected UpgradeProtocol getUpgradeProtocol(String name) {
        return null;
    }

    public boolean getAjpFlush() {
        return this.ajpFlush;
    }

    public void setAjpFlush(boolean ajpFlush) {
        this.ajpFlush = ajpFlush;
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public boolean getTomcatAuthorization() {
        return this.tomcatAuthorization;
    }

    public void setTomcatAuthorization(boolean tomcatAuthorization) {
        this.tomcatAuthorization = tomcatAuthorization;
    }

    public void setRequiredSecret(String requiredSecret) {
        this.requiredSecret = requiredSecret;
    }

    protected String getRequiredSecret() {
        return this.requiredSecret;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize < 8192 ? 8192 : packetSize;
    }

    @Override
    public void addSslHostConfig(SSLHostConfig sslHostConfig) {
        this.getLog().warn(sm.getString("ajpprotocol.noSSL", sslHostConfig.getHostName()));
    }

    @Override
    public SSLHostConfig[] findSslHostConfigs() {
        return new SSLHostConfig[0];
    }

    @Override
    public void addUpgradeProtocol(UpgradeProtocol upgradeProtocol) {
        this.getLog().warn(sm.getString("ajpprotocol.noUpgrade", upgradeProtocol.getClass().getName()));
    }

    @Override
    public UpgradeProtocol[] findUpgradeProtocols() {
        return new UpgradeProtocol[0];
    }

    @Override
    protected Processor createProcessor() {
        AjpProcessor processor = new AjpProcessor(this, this.getAdapter());
        return processor;
    }

    @Override
    protected Processor createUpgradeProcessor(SocketWrapperBase<?> socket, UpgradeToken upgradeToken) {
        throw new IllegalStateException(sm.getString("ajpprotocol.noUpgradeHandler", upgradeToken.getHttpUpgradeHandler().getClass().getName()));
    }
}

