/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mockwebserver;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.TlsVersion;
import okio.Buffer;

public final class RecordedRequest {
    private final String requestLine;
    private final String method;
    private final String path;
    private final Headers headers;
    private final Handshake handshake;
    private final List<Integer> chunkSizes;
    private final long bodySize;
    private final Buffer body;
    private final int sequenceNumber;
    private final HttpUrl requestUrl;

    public RecordedRequest(String requestLine, Headers headers, List<Integer> chunkSizes, long bodySize, Buffer body, int sequenceNumber, Socket socket) {
        this.requestLine = requestLine;
        this.headers = headers;
        this.chunkSizes = chunkSizes;
        this.bodySize = bodySize;
        this.body = body;
        this.sequenceNumber = sequenceNumber;
        if (socket instanceof SSLSocket) {
            try {
                this.handshake = Handshake.get((SSLSession)((SSLSocket)socket).getSession());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            this.handshake = null;
        }
        if (requestLine != null) {
            int methodEnd = requestLine.indexOf(32);
            int pathEnd = requestLine.indexOf(32, methodEnd + 1);
            this.method = requestLine.substring(0, methodEnd);
            String path = requestLine.substring(methodEnd + 1, pathEnd);
            if (!path.startsWith("/")) {
                path = "/";
            }
            this.path = path;
            String scheme = socket instanceof SSLSocket ? "https" : "http";
            InetAddress inetAddress = socket.getLocalAddress();
            String hostname = inetAddress.getHostName();
            if (inetAddress instanceof Inet6Address) {
                hostname = "[" + hostname + "]";
            }
            int localPort = socket.getLocalPort();
            this.requestUrl = HttpUrl.parse((String)String.format("%s://%s:%s%s", scheme, hostname, localPort, path));
        } else {
            this.requestUrl = null;
            this.method = null;
            this.path = null;
        }
    }

    public HttpUrl getRequestUrl() {
        return this.requestUrl;
    }

    public String getRequestLine() {
        return this.requestLine;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        List values = this.headers.values(name);
        return values.isEmpty() ? null : (String)values.get(0);
    }

    public List<Integer> getChunkSizes() {
        return this.chunkSizes;
    }

    public long getBodySize() {
        return this.bodySize;
    }

    public Buffer getBody() {
        return this.body;
    }

    public String getUtf8Body() {
        return this.getBody().readUtf8();
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public TlsVersion getTlsVersion() {
        return this.handshake != null ? this.handshake.tlsVersion() : null;
    }

    public Handshake getHandshake() {
        return this.handshake;
    }

    public String toString() {
        return this.requestLine;
    }
}

