/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.time.Duration;
import javax.annotation.Nullable;
import reactor.netty.Metrics;
import reactor.netty.channel.ChannelMetricsRecorder;

public class MicrometerChannelMetricsRecorder
implements ChannelMetricsRecorder {
    protected static final MeterRegistry registry = io.micrometer.core.instrument.Metrics.globalRegistry;
    protected final String name;
    protected final String remoteAddress;
    final DistributionSummary.Builder dataReceivedBuilder;
    DistributionSummary dataReceived;
    final DistributionSummary.Builder dataSentBuilder;
    DistributionSummary dataSent;
    final Counter.Builder errorCountBuilder;
    Counter errorCount;

    protected MicrometerChannelMetricsRecorder(String name, @Nullable String remoteAddress, String protocol) {
        this.name = name;
        this.remoteAddress = remoteAddress;
        if (remoteAddress == null && !"udp".equals(protocol)) {
            throw new IllegalArgumentException("remoteAddress is null for protocol " + protocol);
        }
        this.dataReceivedBuilder = DistributionSummary.builder((String)(name + ".data.received")).baseUnit("bytes").description("Amount of the data that is received, in bytes").tag("uri", protocol);
        this.dataSentBuilder = DistributionSummary.builder((String)(name + ".data.sent")).baseUnit("bytes").description("Amount of the data that is sent, in bytes").tag("uri", protocol);
        this.errorCountBuilder = Counter.builder((String)(name + ".errors")).description("Number of the errors that are occurred").tag("uri", protocol);
        if (remoteAddress != null) {
            this.dataReceivedBuilder.tag("remote.address", remoteAddress);
            this.dataReceived = this.dataReceivedBuilder.register(registry);
            this.dataSentBuilder.tag("remote.address", remoteAddress);
            this.dataSent = this.dataSentBuilder.register(registry);
            this.errorCountBuilder.tag("remote.address", remoteAddress);
            this.errorCount = this.errorCountBuilder.register(registry);
        }
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, long bytes) {
        if (this.dataReceived != null) {
            this.dataReceived.record((double)bytes);
        } else {
            this.dataReceivedBuilder.tag("remote.address", Metrics.formatSocketAddress(remoteAddress)).register(registry).record((double)bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, long bytes) {
        if (this.dataSent != null) {
            this.dataSent.record((double)bytes);
        } else {
            this.dataSentBuilder.tag("remote.address", Metrics.formatSocketAddress(remoteAddress)).register(registry).record((double)bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress) {
        if (this.errorCount != null) {
            this.errorCount.increment();
        } else {
            this.errorCountBuilder.tag("remote.address", Metrics.formatSocketAddress(remoteAddress)).register(registry).increment();
        }
    }

    @Override
    public void recordTlsHandshakeTime(SocketAddress remoteAddress, Duration time, String status) {
        Timer.builder((String)(this.name + ".tls.handshake.time")).tags(new String[]{"remote.address", Metrics.formatSocketAddress(remoteAddress), "status", status}).description("Time that is spent for TLS handshake").register(registry).record(time);
    }

    @Override
    public void recordConnectTime(SocketAddress remoteAddress, Duration time, String status) {
        Timer.builder((String)(this.name + ".connect.time")).tags(new String[]{"remote.address", Metrics.formatSocketAddress(remoteAddress), "status", status}).description("Time that is spent for connecting to the remote address").register(registry).record(time);
    }

    @Override
    public void recordResolveAddressTime(SocketAddress remoteAddress, Duration time, String status) {
        MicrometerChannelMetricsRecorder._recordResolveAddressTime(remoteAddress, time, status);
    }

    public MeterRegistry registry() {
        return registry;
    }

    public String name() {
        return this.name;
    }

    public String remoteAddress() {
        return this.remoteAddress;
    }

    static void _recordResolveAddressTime(SocketAddress remoteAddress, Duration time, String status) {
        Timer.builder((String)"reactor.netty.address.resolver").tags(new String[]{"remote.address", Metrics.formatSocketAddress(remoteAddress), "status", status}).description("Time that is spent for resolving the address").register(registry).record(time);
    }
}

