/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.net.SocketAddress;
import java.time.Duration;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.http.client.HttpClientOperations;

final class HttpClientMetricsHandler
extends ChannelDuplexHandler {
    HttpRequest request;
    HttpResponse response;
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final HttpClientMetricsRecorder recorder;

    HttpClientMetricsHandler(HttpClientMetricsRecorder recorder) {
        this.recorder = recorder;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpRequest) {
            this.request = (HttpRequest)msg;
            this.dataSentTime = System.currentTimeMillis();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataSent += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataSent += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            promise.addListener(future -> {
                SocketAddress address = ctx.channel().remoteAddress();
                this.recorder.recordDataSentTime(address, this.request.uri(), this.request.method().name(), Duration.ofMillis(System.currentTimeMillis() - this.dataSentTime));
                this.recorder.recordDataSent(address, this.request.uri(), this.dataSent);
            });
        }
        ctx.write(msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            this.response = (HttpResponse)msg;
            this.dataReceivedTime = System.currentTimeMillis();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataReceived += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataReceived += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            SocketAddress address = ctx.channel().remoteAddress();
            this.recorder.recordDataReceivedTime(address, this.request.uri(), this.request.method().name(), this.response.status().codeAsText().toString(), Duration.ofMillis(System.currentTimeMillis() - this.dataReceivedTime));
            this.recorder.recordResponseTime(address, this.request.uri(), this.request.method().name(), this.response.status().codeAsText().toString(), Duration.ofMillis(System.currentTimeMillis() - this.dataSentTime));
            this.recorder.recordDataReceived(address, this.request.uri(), this.dataReceived);
            this.reset();
        }
        ctx.fireChannelRead(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.recorder.incrementErrorsCount(ctx.channel().remoteAddress(), this.request != null ? this.request.uri() : this.resolveUri(ctx));
        ctx.fireExceptionCaught(cause);
    }

    private String resolveUri(ChannelHandlerContext ctx) {
        ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
        if (channelOps instanceof HttpClientOperations) {
            return ((HttpClientOperations)channelOps).uri();
        }
        return "unknown";
    }

    private void reset() {
        this.request = null;
        this.response = null;
        this.dataReceived = 0L;
        this.dataSent = 0L;
        this.dataReceivedTime = 0L;
        this.dataSentTime = 0L;
    }
}

