/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.bridge;

import com.google.caliper.bridge.CaliperControlLogMessage;
import com.google.caliper.bridge.LogMessageVisitor;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;

public class FailureLogMessage
extends CaliperControlLogMessage {
    private final String exceptionClassName;
    private final String message;
    private final ImmutableList<StackTraceElement> stackTrace;

    public FailureLogMessage(Exception e) {
        this(e.getClass().getName(), Strings.nullToEmpty((String)e.getMessage()), Arrays.asList(e.getStackTrace()));
    }

    public FailureLogMessage(String exceptionClassName, String message, Iterable<StackTraceElement> stackTrace) {
        this.exceptionClassName = (String)Preconditions.checkNotNull((Object)exceptionClassName);
        this.message = (String)Preconditions.checkNotNull((Object)message);
        this.stackTrace = ImmutableList.copyOf(stackTrace);
    }

    public String exceptionClassName() {
        return this.exceptionClassName;
    }

    public String message() {
        return this.message;
    }

    public ImmutableList<StackTraceElement> stackTrace() {
        return this.stackTrace;
    }

    @Override
    public void accept(LogMessageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.exceptionClassName, this.message, this.stackTrace});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FailureLogMessage) {
            FailureLogMessage that = (FailureLogMessage)obj;
            return this.exceptionClassName.equals(that.exceptionClassName) && this.message.equals(that.message) && this.stackTrace.equals(that.stackTrace);
        }
        return false;
    }
}

