/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.bridge;

import com.google.caliper.bridge.CaliperControlLogMessage;
import com.google.caliper.bridge.FailureLogMessage;
import com.google.caliper.bridge.GcLogMessage;
import com.google.caliper.bridge.GenericLogMessage;
import com.google.caliper.bridge.HotspotLogMessage;
import com.google.caliper.bridge.LogMessage;
import com.google.caliper.bridge.StartMeasurementLogMessage;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.bridge.VmOptionLogMessage;
import com.google.caliper.bridge.VmPropertiesLogMessage;
import com.google.caliper.util.Parser;
import com.google.caliper.util.ShortDuration;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class LogMessageParser
implements Parser<LogMessage> {
    private final Gson gson;
    private final ImmutableBiMap<Class<? extends CaliperControlLogMessage>, String> typeMap;
    private static final Pattern GC_PATTERN = Pattern.compile(".*\\[(?:(Full) )?GC.*(\\d+\\.\\d+) secs\\]");
    private static final Pattern JIT_PATTERN = Pattern.compile(".*::.*( \\(((\\d+ bytes)|(static))\\))?");
    private static final Pattern VM_OPTION_PATTERN = Pattern.compile("\\s*(\\w+)\\s+(\\w+)\\s+:?=\\s+([^\\s]*)\\s+\\{([^}]*)\\}\\s*");

    @Inject
    LogMessageParser(Gson gson) {
        this.gson = gson;
        this.typeMap = LogMessageParser.createMapForTypes((Set<Class<? extends CaliperControlLogMessage>>)ImmutableSet.of(FailureLogMessage.class, StartMeasurementLogMessage.class, StopMeasurementLogMessage.class, VmPropertiesLogMessage.class));
    }

    private static ImmutableBiMap<Class<? extends CaliperControlLogMessage>, String> createMapForTypes(Set<Class<? extends CaliperControlLogMessage>> messageTypes) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (Class<? extends CaliperControlLogMessage> messageType : messageTypes) {
            builder.put(messageType, (Object)messageType.getSimpleName());
        }
        return builder.build();
    }

    @Override
    public LogMessage parse(CharSequence text) {
        String string = text.toString();
        if (string.startsWith("//\u0279\u01ddd\u0131\u0283\u0250\u2183//")) {
            ImmutableList parts = ImmutableList.copyOf((Iterable)CaliperControlLogMessage.CONTROL_TYPE_SPLITTER.split((CharSequence)string.substring("//\u0279\u01ddd\u0131\u0283\u0250\u2183//".length())));
            Class messageType = (Class)this.typeMap.inverse().get(parts.get(0));
            return (LogMessage)this.gson.fromJson((String)parts.get(1), messageType);
        }
        Matcher gcMatcher = GC_PATTERN.matcher(string);
        if (gcMatcher.matches()) {
            return new GcLogMessage("Full".equals(gcMatcher.group(1)) ? GcLogMessage.Type.FULL : GcLogMessage.Type.INCREMENTAL, ShortDuration.of(BigDecimal.valueOf(Double.parseDouble(gcMatcher.group(2))), TimeUnit.SECONDS));
        }
        Matcher jitMatcher = JIT_PATTERN.matcher(string);
        if (jitMatcher.matches()) {
            return new HotspotLogMessage();
        }
        Matcher vmOptionMatcher = VM_OPTION_PATTERN.matcher(string);
        if (vmOptionMatcher.matches()) {
            return new VmOptionLogMessage(vmOptionMatcher.group(2), vmOptionMatcher.group(3));
        }
        return new GenericLogMessage();
    }
}

