/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.json;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeParameter;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ImmutableMultimapTypeAdapterFactory
implements TypeAdapterFactory {
    ImmutableMultimapTypeAdapterFactory() {
    }

    private static <K, V> com.google.common.reflect.TypeToken<Map<K, List<V>>> getMapOfListsToken(com.google.common.reflect.TypeToken<ListMultimap<K, V>> from) {
        ParameterizedType rawType = (ParameterizedType)from.getSupertype(ListMultimap.class).getType();
        com.google.common.reflect.TypeToken keyType = com.google.common.reflect.TypeToken.of((Type)rawType.getActualTypeArguments()[0]);
        com.google.common.reflect.TypeToken valueType = com.google.common.reflect.TypeToken.of((Type)rawType.getActualTypeArguments()[1]);
        return new com.google.common.reflect.TypeToken<Map<K, List<V>>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    private static <K, V> com.google.common.reflect.TypeToken<Map<K, Set<V>>> getMapOfSetsToken(com.google.common.reflect.TypeToken<SetMultimap<K, V>> from) {
        ParameterizedType rawType = (ParameterizedType)from.getSupertype(SetMultimap.class).getType();
        com.google.common.reflect.TypeToken keyType = com.google.common.reflect.TypeToken.of((Type)rawType.getActualTypeArguments()[0]);
        com.google.common.reflect.TypeToken valueType = com.google.common.reflect.TypeToken.of((Type)rawType.getActualTypeArguments()[1]);
        return new com.google.common.reflect.TypeToken<Map<K, Set<V>>>(){}.where(new TypeParameter<K>(){}, keyType).where(new TypeParameter<V>(){}, valueType);
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        if (ImmutableListMultimap.class.isAssignableFrom(typeToken.getRawType())) {
            com.google.common.reflect.TypeToken mapToken = ImmutableMultimapTypeAdapterFactory.getMapOfListsToken(com.google.common.reflect.TypeToken.of((Type)typeToken.getType()));
            final TypeAdapter adapter = gson.getAdapter(TypeToken.get((Type)mapToken.getType()));
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    ImmutableListMultimap multimap = (ImmutableListMultimap)value;
                    adapter.write(out, (Object)multimap.asMap());
                }

                public T read(JsonReader in) throws IOException {
                    Map value = (Map)adapter.read(in);
                    ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
                    for (Map.Entry entry : value.entrySet()) {
                        builder.putAll(entry.getKey(), (Iterable)entry.getValue());
                    }
                    return builder.build();
                }
            };
        }
        if (ImmutableSetMultimap.class.isAssignableFrom(typeToken.getRawType())) {
            com.google.common.reflect.TypeToken mapToken = ImmutableMultimapTypeAdapterFactory.getMapOfSetsToken(com.google.common.reflect.TypeToken.of((Type)typeToken.getType()));
            final TypeAdapter adapter = gson.getAdapter(TypeToken.get((Type)mapToken.getType()));
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    ImmutableSetMultimap multimap = (ImmutableSetMultimap)value;
                    adapter.write(out, (Object)multimap.asMap());
                }

                public T read(JsonReader in) throws IOException {
                    Map value = (Map)adapter.read(in);
                    ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
                    for (Map.Entry entry : value.entrySet()) {
                        builder.putAll(entry.getKey(), (Iterable)entry.getValue());
                    }
                    return builder.build();
                }
            };
        }
        return null;
    }
}

