/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.caliper.model.ExcludeFromJson;
import com.google.caliper.model.PersistentHashing;
import com.google.caliper.model.StringMapFunnel;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Map;
import java.util.SortedMap;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;

@Entity
@Access(value=AccessType.FIELD)
@Immutable
@Cacheable
@NamedQuery(name="listBenchmarkSpecsForHash", query="SELECT b FROM BenchmarkSpec b WHERE hash = :hash", hints={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.readOnly", value="true")})
public final class BenchmarkSpec {
    static final BenchmarkSpec DEFAULT = new BenchmarkSpec();
    @Id
    @GeneratedValue
    @ExcludeFromJson
    private int id;
    @Basic(optional=false)
    private String className;
    @Basic(optional=false)
    private String methodName;
    @ElementCollection
    @Sort(type=SortType.NATURAL)
    private SortedMap<String, String> parameters;
    @ExcludeFromJson
    private int hash;

    private BenchmarkSpec() {
        this.className = "";
        this.methodName = "";
        this.parameters = Maps.newTreeMap();
        this.hash = 0;
    }

    private BenchmarkSpec(Builder builder) {
        this.className = builder.className;
        this.methodName = builder.methodName;
        this.parameters = Maps.newTreeMap((SortedMap)builder.parameters);
        this.hash = PersistentHashing.getPersistentHashFunction().newHasher().putObject((Object)this, (Funnel)BenchmarkSpecFunnel.INSTANCE).hash().asInt();
    }

    public String className() {
        return this.className;
    }

    public String methodName() {
        return this.methodName;
    }

    public ImmutableSortedMap<String, String> parameters() {
        return ImmutableSortedMap.copyOf(this.parameters);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BenchmarkSpec) {
            BenchmarkSpec that = (BenchmarkSpec)obj;
            return this.hash == that.hash && this.className.equals(that.className) && this.methodName.equals(that.methodName) && this.parameters.equals(that.parameters);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("className", (Object)this.className).add("methodName", (Object)this.methodName).add("parameters", this.parameters).toString();
    }

    public static final class Builder {
        private String className;
        private String methodName;
        private final SortedMap<String, String> parameters = Maps.newTreeMap();

        public Builder className(String className) {
            this.className = (String)Preconditions.checkNotNull((Object)className);
            return this;
        }

        public Builder methodName(String methodName) {
            this.methodName = (String)Preconditions.checkNotNull((Object)methodName);
            return this;
        }

        public Builder addParameter(String parameterName, String value) {
            this.parameters.put((String)Preconditions.checkNotNull((Object)parameterName), (String)Preconditions.checkNotNull((Object)value));
            return this;
        }

        public Builder addAllParameters(Map<String, String> parameters) {
            this.parameters.putAll(parameters);
            return this;
        }

        public BenchmarkSpec build() {
            Preconditions.checkState((this.className != null ? 1 : 0) != 0);
            Preconditions.checkState((this.methodName != null ? 1 : 0) != 0);
            return new BenchmarkSpec(this);
        }
    }

    static enum BenchmarkSpecFunnel implements Funnel<BenchmarkSpec>
    {
        INSTANCE;


        public void funnel(BenchmarkSpec from, PrimitiveSink into) {
            into.putString((CharSequence)from.className).putString((CharSequence)from.methodName);
            StringMapFunnel.INSTANCE.funnel(from.parameters, into);
        }
    }
}

