/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.caliper.model.ExcludeFromJson;
import com.google.caliper.model.PersistentHashing;
import com.google.caliper.model.StringMapFunnel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashFunction;
import com.google.common.hash.PrimitiveSink;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Logger;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;

@Entity
@Access(value=AccessType.FIELD)
@Immutable
@Cacheable
@NamedQuery(name="listHostsForHash", query="SELECT h FROM Host h WHERE hash = :hash", hints={@QueryHint(name="org.hibernate.cacheable", value="true"), @QueryHint(name="org.hibernate.readOnly", value="true")})
public final class Host {
    static final Host DEFAULT = new Host();
    private static final Logger logger = Logger.getLogger(Host.class.getName());
    @Id
    @GeneratedValue
    @ExcludeFromJson
    private int id;
    @ElementCollection
    @Sort(type=SortType.NATURAL)
    private SortedMap<String, String> properties;
    @ExcludeFromJson
    private int hash;

    private Host() {
        this.properties = Maps.newTreeMap();
        this.hash = 0;
    }

    private Host(Builder builder) {
        this.properties = Maps.newTreeMap((SortedMap)builder.properties);
        this.hash = builder.hashFunction.newHasher().putObject((Object)this, (Funnel)HostFunnel.INSTANCE).hash().asInt();
    }

    public ImmutableSortedMap<String, String> properties() {
        return ImmutableSortedMap.copyOf(this.properties);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Host) {
            Host that = (Host)obj;
            return this.hash == that.hash && this.properties.equals(that.properties);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("properties", this.properties).toString();
    }

    public static final class Builder {
        private final SortedMap<String, String> properties = Maps.newTreeMap();
        private HashFunction hashFunction = PersistentHashing.getPersistentHashFunction();

        public Builder addProperty(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder addAllProperies(Map<String, String> properties) {
            this.properties.putAll(properties);
            return this;
        }

        @VisibleForTesting
        public Builder hashFunctionForTesting(HashFunction hashFunction) {
            logger.warning("somebody is setting the hash function. this should only be used in tests");
            this.hashFunction = (HashFunction)Preconditions.checkNotNull((Object)hashFunction);
            return this;
        }

        public Host build() {
            return new Host(this);
        }
    }

    static enum HostFunnel implements Funnel<Host>
    {
        INSTANCE;


        public void funnel(Host from, PrimitiveSink into) {
            StringMapFunnel.INSTANCE.funnel(from.properties, into);
        }
    }
}

