/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.Benchmark;
import com.google.caliper.api.ResultProcessor;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.bridge.AbstractLogMessageVisitor;
import com.google.caliper.bridge.CaliperControlLogMessage;
import com.google.caliper.bridge.FailureLogMessage;
import com.google.caliper.bridge.LogMessage;
import com.google.caliper.bridge.LogMessageVisitor;
import com.google.caliper.bridge.VmOptionLogMessage;
import com.google.caliper.bridge.VmPropertiesLogMessage;
import com.google.caliper.bridge.WorkerSpec;
import com.google.caliper.model.BenchmarkSpec;
import com.google.caliper.model.Host;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Run;
import com.google.caliper.model.Scenario;
import com.google.caliper.model.Trial;
import com.google.caliper.model.VmSpec;
import com.google.caliper.options.CaliperOptions;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.CaliperRun;
import com.google.caliper.runner.Experiment;
import com.google.caliper.runner.ExperimentSelector;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.ProxyWorkerException;
import com.google.caliper.runner.TrialFailureException;
import com.google.caliper.runner.VirtualMachine;
import com.google.caliper.runner.WorkerProcess;
import com.google.caliper.util.Parser;
import com.google.caliper.util.Pipes;
import com.google.caliper.util.ShortDuration;
import com.google.caliper.util.Stderr;
import com.google.caliper.util.Stdout;
import com.google.caliper.worker.WorkerMain;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.io.Closeables;
import com.google.common.io.LineReader;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@VisibleForTesting
public final class ExperimentingCaliperRun
implements CaliperRun {
    private static final Logger logger = Logger.getLogger(ExperimentingCaliperRun.class.getName());
    private final CaliperOptions options;
    private final PrintWriter stdout;
    private final PrintWriter stderr;
    private final BenchmarkClass benchmarkClass;
    private final ImmutableSet<Instrument> instruments;
    private final ImmutableSet<ResultProcessor> resultProcessors;
    private final Parser<LogMessage> logMessageParser;
    private final ExperimentSelector selector;
    private final Host host;
    private final Run run;
    private final Gson gson;
    private final ListeningExecutorService consumerExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("line-processor-%d").setDaemon(true).build()));
    private final ListeningExecutorService processExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("process-watcher-%d").setDaemon(true).build()));
    private final Stopwatch trialStopwatch = new Stopwatch();
    private volatile int trialNumber = 1;
    private static final int NUM_WORKER_STREAMS = 3;
    private static final String POISON_PILL = new String("Bel Biv Devoe");

    @Inject
    @VisibleForTesting
    public ExperimentingCaliperRun(CaliperOptions options, @Stdout PrintWriter stdout, @Stderr PrintWriter stderr, BenchmarkClass benchmarkClass, ImmutableSet<Instrument> instruments, ImmutableSet<ResultProcessor> resultProcessors, Parser<LogMessage> logMessageParser, ExperimentSelector selector, Host host, Run run, Gson gson) {
        this.options = options;
        this.stdout = stdout;
        this.stderr = stderr;
        this.benchmarkClass = benchmarkClass;
        this.instruments = instruments;
        this.resultProcessors = resultProcessors;
        this.logMessageParser = logMessageParser;
        this.selector = selector;
        this.host = host;
        this.run = run;
        this.gson = gson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws InvalidBenchmarkException {
        this.stdout.println("Experiment selection: ");
        this.stdout.println("  Instruments:   " + FluentIterable.from(this.selector.instruments()).transform((Function)new Function<Instrument, String>(){

            public String apply(Instrument instrument) {
                return instrument.name();
            }
        }));
        this.stdout.println("  User parameters:   " + this.selector.userParameters());
        this.stdout.println("  Virtual machines:  " + FluentIterable.from(this.selector.vms()).transform((Function)new Function<VirtualMachine, String>(){

            public String apply(VirtualMachine vm) {
                return vm.name;
            }
        }));
        this.stdout.println("  Selection type:    " + this.selector.selectionType());
        this.stdout.println();
        ImmutableSet<Experiment> allExperiments = this.selector.selectExperiments();
        if (allExperiments.isEmpty()) {
            throw new InvalidBenchmarkException("There were no experiments to be peformed for the class %s using the instruments %s", this.benchmarkClass.benchmarkClass().getSimpleName(), this.instruments);
        }
        this.stdout.format("This selection yields %s experiments.%n", allExperiments.size());
        this.stdout.flush();
        ImmutableSet<Experiment> experimentsToRun = this.dryRun((Iterable<Experiment>)allExperiments);
        if (experimentsToRun.size() != allExperiments.size()) {
            this.stdout.format("%d experiments were skipped.%n", allExperiments.size() - experimentsToRun.size());
        }
        if (experimentsToRun.isEmpty()) {
            throw new InvalidBenchmarkException("All experiements were skipped.", new Object[0]);
        }
        if (this.options.dryRun()) {
            return;
        }
        this.stdout.flush();
        int totalTrials = experimentsToRun.size() * this.options.trialsPerScenario();
        Stopwatch stopwatch = new Stopwatch().start();
        try {
            for (int i = 0; i < this.options.trialsPerScenario(); ++i) {
                for (Experiment experiment : experimentsToRun) {
                    this.stdout.printf("Starting experiment %d of %d: %s%n", this.trialNumber, totalTrials, experiment);
                    try {
                        Trial trial = this.measure(experiment);
                        this.stdout.println("Complete!");
                        for (ResultProcessor resultProcessor : this.resultProcessors) {
                            resultProcessor.processTrial(trial);
                        }
                    }
                    catch (TrialFailureException e) {
                        this.stderr.println("ERROR: Trial failed to complete (its results will not be included in the run):\n  " + e.getMessage());
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                    finally {
                        ++this.trialNumber;
                    }
                }
            }
        }
        finally {
            this.consumerExecutor.shutdown();
        }
        this.stdout.print("\n");
        this.stdout.format("Execution complete: %s.%n", ShortDuration.of(stopwatch.stop().elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS));
        for (ResultProcessor resultProcessor : this.resultProcessors) {
            try {
                resultProcessor.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not close a result processor: " + resultProcessor, e);
            }
        }
    }

    private ProcessBuilder createWorkerProcessBuilder(Experiment experiment, BenchmarkSpec benchmarkSpec, File pipeFile) {
        Instrument instrument = experiment.instrument();
        WorkerSpec request = new WorkerSpec(instrument.workerClass().getName(), instrument.workerOptions(), benchmarkSpec, pipeFile.getAbsolutePath());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).redirectErrorStream(false);
        List<String> args = processBuilder.command();
        String jvmName = experiment.vm().name;
        String jdkPath = experiment.vm().config.javaExecutable().getAbsolutePath();
        args.add(jdkPath);
        logger.fine(String.format("Java(%s) Path: %s", jvmName, jdkPath));
        ImmutableList<String> jvmOptions = experiment.vm().config.options();
        args.addAll((Collection<String>)jvmOptions);
        logger.fine(String.format("Java(%s) args: %s", jvmName, jvmOptions));
        ImmutableSet<String> benchmarkJvmOptions = this.benchmarkClass.vmOptions();
        args.addAll((Collection<String>)benchmarkJvmOptions);
        logger.fine(String.format("Benchmark(%s) Java args: %s", this.benchmarkClass.name(), benchmarkJvmOptions));
        String classPath = System.getProperty("java.class.path");
        Collections.addAll(args, "-cp", classPath);
        logger.finer(String.format("Class path: %s", classPath));
        ImmutableSet<String> instrumentJvmOptions = instrument.getExtraCommandLineArgs();
        Iterables.addAll(args, instrumentJvmOptions);
        logger.fine(String.format("Instrument(%s) Java args: %s", instrument.getClass().getName(), instrumentJvmOptions));
        args.add("-XX:+PrintFlagsFinal");
        args.add("-XX:+PrintCompilation");
        args.add("-XX:+PrintGC");
        args.add(WorkerMain.class.getName());
        args.add(this.gson.toJson((Object)request));
        logger.finest(String.format("Full JVM (%s) args: %s", jvmName, args));
        return processBuilder;
    }

    private Trial measure(Experiment experiment) throws IOException {
        BenchmarkSpec benchmarkSpec = new BenchmarkSpec.Builder().className(experiment.benchmarkMethod().benchmarkClass().name()).methodName(experiment.benchmarkMethod().name()).addAllParameters((Map<String, String>)experiment.userParameters()).build();
        final File pipeFile = Pipes.createPipe();
        final WorkerProcess process = new WorkerProcess(this.createWorkerProcessBuilder(experiment, benchmarkSpec, pipeFile));
        ListenableFuture processFuture = this.processExecutor.submit((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return process.waitFor();
            }
        });
        this.trialStopwatch.start();
        final ListeningExecutorService producerExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("stream-listener-%d").build()));
        try {
            final LinkedBlockingQueue queue = Queues.newLinkedBlockingQueue();
            Charset processCharset = Charset.defaultCharset();
            ListenableFuture inputFuture = producerExecutor.submit((Callable)new LineProducer(new InputStreamReader(process.getInputStream(), processCharset), queue));
            ListenableFuture errorFuture = producerExecutor.submit((Callable)new LineProducer(new InputStreamReader(process.getErrorStream(), processCharset), queue));
            final ListenableFuture pipeReaderFuture = producerExecutor.submit((Callable)new Callable<Reader>(){

                @Override
                public Reader call() throws IOException {
                    return new InputStreamReader((InputStream)new FileInputStream(pipeFile), Charsets.UTF_8);
                }
            });
            processFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    if (!pipeReaderFuture.isDone()) {
                        ExperimentingCaliperRun.this.stdout.print("The worker exited without producing data. It has likely crashed. Run with --verbose to see any worker output.\n");
                        ExperimentingCaliperRun.this.stdout.flush();
                        System.exit(1);
                    }
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
            Futures.addCallback((ListenableFuture)pipeReaderFuture, (FutureCallback)new FutureCallback<Reader>(){

                public void onSuccess(Reader result) {
                    logger.fine("successfully opened the pipe from the worker");
                    producerExecutor.submit((Callable)new LineProducer(result, queue));
                }

                public void onFailure(Throwable t) {
                    logger.log(Level.SEVERE, "Could not open the pipe from the worker", t);
                }
            });
            Instrument.MeasurementCollectingVisitor measurementCollectingVisitor = experiment.instrument().getMeasurementCollectingVisitor();
            DataCollectingVisitor dataCollectingVisitor = new DataCollectingVisitor();
            ListenableFuture consumerFuture = this.consumerExecutor.submit((Callable)new LineConsumer(queue, measurementCollectingVisitor, (ImmutableSet<? extends LogMessageVisitor>)ImmutableSet.of((Object)dataCollectingVisitor)));
            consumerFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    process.destroy();
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
            process.waitFor();
            consumerFuture.get();
            ImmutableMap vmOptions = dataCollectingVisitor.vmOptionsBuilder.build();
            Preconditions.checkState((!vmOptions.isEmpty() ? 1 : 0) != 0);
            VmSpec vmSpec = new VmSpec.Builder().addAllProperties((Map)dataCollectingVisitor.vmProperties.get()).addAllOptions((Map<String, String>)vmOptions).build();
            Trial trial = new Trial.Builder(UUID.randomUUID()).run(this.run).instrumentSpec(experiment.instrument().getSpec()).scenario(new Scenario.Builder().host(this.host).vmSpec(vmSpec).benchmarkSpec(benchmarkSpec)).addAllMeasurements((Iterable<Measurement>)measurementCollectingVisitor.getMeasurements()).build();
            return trial;
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)cause, TrialFailureException.class);
            throw new RuntimeException(cause);
        }
        finally {
            this.trialStopwatch.reset();
            producerExecutor.shutdownNow();
        }
    }

    private long getRemainingTrialNanos() {
        ShortDuration timeLimit = this.options.timeLimit();
        if (ShortDuration.zero().equals(timeLimit)) {
            return Long.MAX_VALUE;
        }
        return timeLimit.to(TimeUnit.NANOSECONDS) - this.trialStopwatch.elapsed(TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImmutableSet<Experiment> dryRun(Iterable<Experiment> experiments) throws InvalidBenchmarkException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Experiment experiment : experiments) {
            try {
                Benchmark benchmark = this.benchmarkClass.createAndStage(experiment.userParameters());
                try {
                    experiment.instrument().dryRun(benchmark, experiment.benchmarkMethod());
                    builder.add((Object)experiment);
                }
                finally {
                    this.benchmarkClass.cleanup(benchmark);
                }
            }
            catch (SkipThisScenarioException innocuous) {}
        }
        return builder.build();
    }

    private final class LineConsumer
    implements Callable<Void> {
        final BlockingQueue<String> queue;
        final Instrument.MeasurementCollectingVisitor measurementCollectingVisitor;
        final ImmutableSet<? extends LogMessageVisitor> otherVisitors;

        LineConsumer(BlockingQueue<String> queue, Instrument.MeasurementCollectingVisitor measurementCollectingVisitor, ImmutableSet<? extends LogMessageVisitor> otherVisitors) {
            this.queue = queue;
            this.measurementCollectingVisitor = measurementCollectingVisitor;
            this.otherVisitors = otherVisitors;
        }

        @Override
        public Void call() throws InterruptedException {
            int poisonPillsSeen = 0;
            while (poisonPillsSeen < 3 && !this.measurementCollectingVisitor.isDoneCollecting()) {
                String line = this.queue.poll(ExperimentingCaliperRun.this.getRemainingTrialNanos(), TimeUnit.NANOSECONDS);
                if (line == null) {
                    throw new TrialFailureException(String.format("Trial exceeded the total allowable runtime (%s). The limit may be adjusted using the --time-limit flag.", ExperimentingCaliperRun.this.options.timeLimit()));
                }
                if (line == POISON_PILL) {
                    ++poisonPillsSeen;
                    continue;
                }
                this.processLine(line);
            }
            ExperimentingCaliperRun.this.trialStopwatch.stop();
            logger.fine("trial completed in " + ExperimentingCaliperRun.this.trialStopwatch);
            return null;
        }

        void processLine(String line) {
            try {
                LogMessage logMessage = (LogMessage)ExperimentingCaliperRun.this.logMessageParser.parse(line);
                if (ExperimentingCaliperRun.this.options.verbose() && !(logMessage instanceof CaliperControlLogMessage)) {
                    ExperimentingCaliperRun.this.stdout.printf("[trial-%d] %s%n", ExperimentingCaliperRun.this.trialNumber, line);
                }
                logMessage.accept(this.measurementCollectingVisitor);
                for (LogMessageVisitor visitor : this.otherVisitors) {
                    logMessage.accept(visitor);
                }
            }
            catch (ParseException e) {
                throw new AssertionError();
            }
        }
    }

    private static final class LineProducer
    implements Callable<Void> {
        final Reader reader;
        final BlockingQueue<String> queue;

        LineProducer(Reader reader, BlockingQueue<String> queue) {
            this.reader = reader;
            this.queue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws IOException, InterruptedException {
            LineReader lineReader = new LineReader((Readable)this.reader);
            boolean threw = true;
            try {
                String line;
                while ((line = lineReader.readLine()) != null) {
                    this.queue.put(line);
                }
                threw = false;
            }
            finally {
                this.queue.put(POISON_PILL);
                Closeables.close((Closeable)this.reader, (boolean)threw);
            }
            return null;
        }
    }

    private static final class DataCollectingVisitor
    extends AbstractLogMessageVisitor {
        final ImmutableMap.Builder<String, String> vmOptionsBuilder = ImmutableMap.builder();
        Optional<ImmutableMap<String, String>> vmProperties = Optional.absent();
        static final Predicate<String> PROPERTIES_TO_RETAIN = new Predicate<String>(){

            public boolean apply(String input) {
                return input.startsWith("java.vm") || input.startsWith("java.runtime") || input.equals("java.version") || input.equals("java.vendor") || input.equals("sun.reflect.noInflation") || input.equals("sun.reflect.inflationThreshold");
            }
        };

        private DataCollectingVisitor() {
        }

        @Override
        public void visit(FailureLogMessage logMessage) {
            throw new ProxyWorkerException(logMessage.exceptionClassName(), logMessage.message(), logMessage.stackTrace());
        }

        @Override
        public void visit(VmOptionLogMessage logMessage) {
            this.vmOptionsBuilder.put((Object)logMessage.name(), (Object)logMessage.value());
        }

        @Override
        public void visit(VmPropertiesLogMessage logMessage) {
            this.vmProperties = Optional.of((Object)ImmutableMap.copyOf((Map)Maps.filterKeys(logMessage.properties(), PROPERTIES_TO_RETAIN)));
        }
    }
}

