/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.api.ResultProcessor;
import com.google.caliper.config.CaliperConfig;
import com.google.caliper.config.InstrumentConfig;
import com.google.caliper.model.Host;
import com.google.caliper.model.Run;
import com.google.caliper.options.CaliperOptions;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.BenchmarkParameters;
import com.google.caliper.runner.CaliperRun;
import com.google.caliper.runner.EnvironmentGetter;
import com.google.caliper.runner.ExperimentSelector;
import com.google.caliper.runner.ExperimentingCaliperRun;
import com.google.caliper.runner.FullCartesianExperimentSelector;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InstrumentName;
import com.google.caliper.runner.InstrumentOptions;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.InvalidInstrumentException;
import com.google.caliper.runner.NanoTimeGranularity;
import com.google.caliper.runner.NanoTimeGranularityTester;
import com.google.caliper.runner.RunnerModule;
import com.google.caliper.runner.UserCodeException;
import com.google.caliper.util.InvalidCommandException;
import com.google.caliper.util.ShortDuration;
import com.google.caliper.util.Util;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import java.util.UUID;
import org.joda.time.Instant;

final class ExperimentingRunnerModule
extends AbstractModule {
    ExperimentingRunnerModule() {
    }

    protected void configure() {
        this.install((Module)new RunnerModule());
        this.bind(CaliperRun.class).to(ExperimentingCaliperRun.class);
        this.bind(ExperimentSelector.class).to(FullCartesianExperimentSelector.class);
    }

    @Provides
    ImmutableSet<ResultProcessor> provideResultProcessors(CaliperConfig config, Injector injector) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Class processorClass : config.getConfiguredResultProcessors()) {
            builder.add(injector.getInstance(processorClass));
        }
        return builder.build();
    }

    @Provides
    UUID provideUuid() {
        return UUID.randomUUID();
    }

    @Provides
    @BenchmarkParameters
    ImmutableSetMultimap<String, String> provideBenchmarkParameters(BenchmarkClass benchmarkClass, CaliperOptions options) throws InvalidBenchmarkException {
        return benchmarkClass.userParameters().fillInDefaultsFor(options.userParameters());
    }

    @Provides
    @Singleton
    Host provideHost(EnvironmentGetter environmentGetter) {
        return environmentGetter.getHost();
    }

    @Provides
    @Singleton
    Run provideRun(UUID id, CaliperOptions options, Instant startTime) {
        return new Run.Builder(id).label(options.runName()).startTime(startTime).build();
    }

    @Provides
    ImmutableSet<Instrument> provideInstruments(Injector injector, CaliperOptions options, CaliperConfig config) throws InvalidCommandException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableSet<String> configuredInstruments = config.getConfiguredInstruments();
        for (final String instrumentName : options.instrumentNames()) {
            if (!configuredInstruments.contains((Object)instrumentName)) {
                throw new InvalidCommandException("%s is not a configured instrument (%s). use --print-config to see the configured instruments.", instrumentName, configuredInstruments);
            }
            final InstrumentConfig instrumentConfig = config.getInstrumentConfig(instrumentName);
            Injector instrumentInjector = injector.createChildInjector(new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(InstrumentConfig.class).toInstance((Object)instrumentConfig);
                }

                @Provides
                @InstrumentOptions
                ImmutableMap<String, String> provideInstrumentOptions(InstrumentConfig config) {
                    return config.options();
                }

                @Provides
                @InstrumentName
                String provideInstrumentName() {
                    return instrumentName;
                }
            }});
            String className = instrumentConfig.className();
            try {
                builder.add(instrumentInjector.getInstance(Util.lenientClassForName(className).asSubclass(Instrument.class)));
            }
            catch (ClassNotFoundException e) {
                throw new InvalidCommandException("Cannot find instrument class '%s'", className);
            }
            catch (ProvisionException e) {
                throw new InvalidInstrumentException("Could not create the instrument %s", className);
            }
        }
        return builder.build();
    }

    private static Class<?> classForName(String className) throws InvalidCommandException, UserCodeException {
        try {
            return Util.lenientClassForName(className);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidCommandException("Benchmark class not found: " + className, new Object[0]);
        }
        catch (ExceptionInInitializerError e) {
            throw new UserCodeException("Exception thrown while initializing class '" + className + "'", e.getCause());
        }
        catch (NoClassDefFoundError e) {
            throw new UserCodeException("Unable to load " + className, e);
        }
    }

    @Provides
    BenchmarkClass provideBenchmarkClass(CaliperOptions options) throws InvalidBenchmarkException, InvalidCommandException {
        BenchmarkClass benchmarkClass = new BenchmarkClass(ExperimentingRunnerModule.classForName(options.benchmarkClassName()));
        benchmarkClass.validateParameters(options.userParameters());
        return benchmarkClass;
    }

    @Provides
    @Singleton
    @NanoTimeGranularity
    ShortDuration provideNanoTimeGranularity(NanoTimeGranularityTester tester) {
        return tester.testNanoTimeGranularity();
    }

    @Provides
    ImmutableSetMultimap<Instrument, BenchmarkMethod> provideBenchmarkMethodsByInstrument(CaliperOptions options, BenchmarkClass benchmarkClass, ImmutableSet<Instrument> instruments) throws InvalidBenchmarkException {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        final ImmutableSet<String> benchmarkMethodNames = options.benchmarkMethodNames();
        for (Instrument instrument : instruments) {
            builder.putAll((Object)instrument, Iterables.filter(benchmarkClass.findAllBenchmarkMethods(instrument), (Predicate)new Predicate<BenchmarkMethod>(){

                public boolean apply(BenchmarkMethod method) {
                    return benchmarkMethodNames.isEmpty() || benchmarkMethodNames.contains((Object)method.name());
                }
            }));
        }
        return builder.build();
    }
}

