/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.Benchmark;
import com.google.caliper.api.AfterRep;
import com.google.caliper.api.BeforeRep;
import com.google.caliper.api.Macrobenchmark;
import com.google.caliper.api.SkipThisScenarioException;
import com.google.caliper.bridge.AbstractLogMessageVisitor;
import com.google.caliper.bridge.GcLogMessage;
import com.google.caliper.bridge.HotspotLogMessage;
import com.google.caliper.bridge.StartMeasurementLogMessage;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.model.Measurement;
import com.google.caliper.runner.BenchmarkClass;
import com.google.caliper.runner.BenchmarkMethod;
import com.google.caliper.runner.Instrument;
import com.google.caliper.runner.InvalidBenchmarkException;
import com.google.caliper.runner.NanoTimeGranularity;
import com.google.caliper.runner.TrialFailureException;
import com.google.caliper.runner.UserCodeException;
import com.google.caliper.util.ShortDuration;
import com.google.caliper.util.Stderr;
import com.google.caliper.util.Util;
import com.google.caliper.worker.MacrobenchmarkWorker;
import com.google.caliper.worker.Worker;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class MacrobenchmarkInstrument
extends Instrument {
    private final PrintWriter stderr;
    private final ShortDuration nanoTimeGranularity;

    @Inject
    MacrobenchmarkInstrument(@Stderr PrintWriter stderr, @NanoTimeGranularity ShortDuration nanoTimeGranularity) {
        this.stderr = stderr;
        this.nanoTimeGranularity = nanoTimeGranularity;
    }

    @Override
    protected ImmutableSet<String> instrumentOptions() {
        return ImmutableSet.of((Object)"warmup", (Object)"measurements");
    }

    @Override
    public boolean isBenchmarkMethod(Method method) {
        return method.isAnnotationPresent(Macrobenchmark.class);
    }

    @Override
    public BenchmarkMethod createBenchmarkMethod(BenchmarkClass benchmarkClass, Method method) throws InvalidBenchmarkException {
        Preconditions.checkArgument((boolean)this.isBenchmarkMethod(method));
        Object[] parameterTypes = method.getParameterTypes();
        if (!Arrays.equals(parameterTypes, new Class[0])) {
            throw new InvalidBenchmarkException("Macrobenchmark methods must not have parameters: " + method.getName(), new Object[0]);
        }
        if (Util.isStatic(method)) {
            throw new InvalidBenchmarkException("Macrobenchmark methods must not be static: " + method.getName(), new Object[0]);
        }
        String methodName = method.getName();
        return new BenchmarkMethod(benchmarkClass, method, methodName);
    }

    private static ImmutableSet<Method> getAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        Method[] methods = clazz.getDeclaredMethods();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Method method : methods) {
            if (!method.isAnnotationPresent(annotationClass)) continue;
            builder.add((Object)method);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dryRun(Benchmark benchmark, BenchmarkMethod method) throws UserCodeException {
        ImmutableSet<Method> beforeRepMethods = MacrobenchmarkInstrument.getAnnotatedMethods(method.benchmarkClass().benchmarkClass(), BeforeRep.class);
        ImmutableSet<Method> afterRepMethods = MacrobenchmarkInstrument.getAnnotatedMethods(method.benchmarkClass().benchmarkClass(), AfterRep.class);
        try {
            for (Method beforeRepMethod : beforeRepMethods) {
                beforeRepMethod.invoke((Object)benchmark, new Object[0]);
            }
            try {
                method.method().invoke((Object)benchmark, new Object[0]);
            }
            finally {
                for (Method afterRepMethod : afterRepMethods) {
                    afterRepMethod.invoke((Object)benchmark, new Object[0]);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable userException = e.getCause();
            Throwables.propagateIfInstanceOf((Throwable)userException, SkipThisScenarioException.class);
            throw new UserCodeException(userException);
        }
    }

    @Override
    public Class<? extends Worker> workerClass() {
        return MacrobenchmarkWorker.class;
    }

    @Override
    Instrument.MeasurementCollectingVisitor getMeasurementCollectingVisitor() {
        return new RuntimeMeasurementCollector(Integer.parseInt((String)this.options.get((Object)"measurements")), ShortDuration.valueOf((String)this.options.get((Object)"warmup")));
    }

    private final class RuntimeMeasurementCollector
    extends AbstractLogMessageVisitor
    implements Instrument.MeasurementCollectingVisitor {
        int measurementsPerTrial;
        final ShortDuration warmup;
        final List<Measurement> measurements;
        boolean warnedAboutGc = false;
        boolean warnedAboutJit = false;
        boolean warnedAboutTimingJit = false;
        boolean timing = false;
        ShortDuration elapsedWarmup = ShortDuration.zero();

        RuntimeMeasurementCollector(int measurementsPerTrial, ShortDuration warmup) {
            this.measurementsPerTrial = measurementsPerTrial;
            this.measurements = Lists.newArrayListWithCapacity((int)measurementsPerTrial);
            this.warmup = warmup;
        }

        @Override
        public void visit(StartMeasurementLogMessage logMessage) {
            Preconditions.checkState((!this.timing ? 1 : 0) != 0);
            this.timing = true;
        }

        @Override
        public void visit(GcLogMessage logMessage) {
            if (!this.isInWarmup() && this.timing && !this.warnedAboutGc) {
                MacrobenchmarkInstrument.this.stderr.println("WARNING: GC occurred during timing. Depending on the scope of the benchmark, this might significantly impact results. Consider running with a larger heap size.");
                this.warnedAboutGc = true;
            }
        }

        @Override
        public void visit(HotspotLogMessage logMessage) {
            if (!this.isInWarmup()) {
                if (this.timing && !this.warnedAboutTimingJit) {
                    MacrobenchmarkInstrument.this.stderr.println("WARNING: Hotspot compilation occurred during timing. Depending on the scope of the benchmark, this might significantly impact results. Consider running with a longer warmup.");
                    this.warnedAboutTimingJit = true;
                } else if (!this.warnedAboutJit) {
                    MacrobenchmarkInstrument.this.stderr.println("WARNING: Hotspot compilation occurred after warmup, but outside of timing. Depending on the scope of the benchmark, this might significantly impact results. Consider running with a longer warmup.");
                    this.warnedAboutJit = true;
                }
            }
        }

        @Override
        public void visit(StopMeasurementLogMessage logMessage) {
            Preconditions.checkState((boolean)this.timing);
            ImmutableList<Measurement> newMeasurements = logMessage.measurements();
            for (Measurement measurement : newMeasurements) {
                Preconditions.checkArgument((boolean)"ns".equals(measurement.value().unit()));
                double nanos = measurement.value().magnitude() / measurement.weight();
                if (!(nanos / 1000.0 < (double)MacrobenchmarkInstrument.this.nanoTimeGranularity.to(TimeUnit.NANOSECONDS))) continue;
                ShortDuration runtime = ShortDuration.of(BigDecimal.valueOf(nanos), TimeUnit.NANOSECONDS);
                throw new TrialFailureException(String.format("This experiment requires a microbenchmark. The granularity of the timer (%s) is greater than 0.1%% of the measured runtime (%s). Use the microbenchmark instrument for accurate measurements.%n", MacrobenchmarkInstrument.this.nanoTimeGranularity, runtime));
            }
            if (this.isInWarmup()) {
                for (Measurement measurement : newMeasurements) {
                    this.elapsedWarmup = this.elapsedWarmup.plus(ShortDuration.of(BigDecimal.valueOf(measurement.value().magnitude()), TimeUnit.NANOSECONDS));
                }
            } else {
                this.measurements.addAll((Collection<Measurement>)newMeasurements);
            }
            this.timing = false;
        }

        boolean isInWarmup() {
            return this.elapsedWarmup.compareTo(this.warmup) < 0;
        }

        @Override
        public boolean isDoneCollecting() {
            return this.measurements.size() >= this.measurementsPerTrial;
        }

        @Override
        public ImmutableList<Measurement> getMeasurements() {
            return ImmutableList.copyOf(this.measurements);
        }
    }
}

