/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.caliper.config.CaliperConfig;
import com.google.caliper.config.InvalidConfigurationException;
import com.google.caliper.config.VmConfig;
import com.google.caliper.options.CaliperOptions;
import com.google.caliper.runner.VirtualMachine;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;

final class RunnerModule
extends AbstractModule {
    RunnerModule() {
    }

    protected void configure() {
        this.requireBinding(CaliperOptions.class);
        this.requireBinding(CaliperConfig.class);
    }

    @Provides
    ImmutableSet<VirtualMachine> provideVirtualMachines(CaliperOptions options, CaliperConfig config) throws InvalidConfigurationException {
        ImmutableSet<String> vmNames = options.vmNames();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (vmNames.isEmpty()) {
            builder.add((Object)new VirtualMachine("default", config.getDefaultVmConfig()));
        } else {
            for (String vmName : vmNames) {
                VmConfig vmConfig = config.getVmConfig(vmName);
                builder.add((Object)new VirtualMachine(vmName, vmConfig));
            }
        }
        return builder.build();
    }
}

