/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.util;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;

public final class Pipes {
    private Pipes() {
    }

    public static File createPipe() throws IOException {
        File parentDirectory = Files.createTempDir();
        parentDirectory.deleteOnExit();
        File pipeFile = new File(parentDirectory, "pipe");
        pipeFile.deleteOnExit();
        ProcessBuilder mkfifoProcessBuilder = new ProcessBuilder("mkfifo", pipeFile.getAbsolutePath());
        try {
            Process process = mkfifoProcessBuilder.start();
            int exitValue = process.waitFor();
            if (exitValue != 0) {
                Pipes.cleanUpAndFail(pipeFile);
            }
        }
        catch (IOException e) {
            Pipes.cleanUpAndFail(pipeFile);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Pipes.cleanUpAndFail(pipeFile);
        }
        if (!pipeFile.exists()) {
            Pipes.cleanUpAndFail(pipeFile);
        }
        return pipeFile;
    }

    private static void cleanUpAndFail(File pipeFile) throws IOException {
        File parentDirectory;
        if (pipeFile.exists()) {
            pipeFile.delete();
        }
        if ((parentDirectory = pipeFile.getParentFile()).exists()) {
            parentDirectory.delete();
        }
        throw new IOException("could not create pipe: " + pipeFile);
    }
}

