/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.Benchmark;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Value;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerEventLog;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.monitoring.runtime.instrumentation.AllocationRecorder;
import com.google.monitoring.runtime.instrumentation.Sampler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;

public final class AllocationWorker
implements Worker {
    private static final int MAX_BASELINE_REPS = 5;
    private static final int MAX_REPS_ABOVE_BASELINE = 100;
    private final Random random;
    private int allocationCount;
    private long allocationSize;
    private boolean recordAllocations = false;

    @Inject
    AllocationWorker(Random random) {
        this.random = random;
        AllocationRecorder.addSampler((Sampler)new Sampler(){

            public void sampleAllocation(int arrayCount, String desc, Object newObj, long size) {
                if (AllocationWorker.this.recordAllocations) {
                    AllocationWorker.this.allocationCount++;
                    AllocationWorker.this.allocationSize += size;
                }
            }
        });
    }

    @Override
    public synchronized void measure(Benchmark benchmark, String methodName, Map<String, String> options, WorkerEventLog log) throws Exception {
        log.notifyWarmupPhaseStarting();
        this.measureAllocations(benchmark, methodName, 1);
        log.notifyMeasurementPhaseStarting();
        while (true) {
            log.notifyMeasurementStarting();
            int baselineReps = this.random.nextInt(5) + 1;
            AllocationStats baseline = this.measureAllocations(benchmark, methodName, baselineReps);
            int measurementReps = baselineReps + this.random.nextInt(100) + 1;
            AllocationStats measurement = this.measureAllocations(benchmark, methodName, measurementReps);
            try {
                AllocationStats diff = this.diffMeasurements(baseline, measurement);
                log.notifyMeasurementEnding((Iterable<Measurement>)ImmutableList.of((Object)new Measurement.Builder().value(Value.create(diff.allocationCount, "")).description("objects").weight(diff.reps).build(), (Object)new Measurement.Builder().value(Value.create(diff.allocationSize, "B")).weight(diff.reps).description("bytes").build()));
                continue;
            }
            catch (IllegalStateException e) {
                log.notifyMeasurementFailure(e);
                continue;
            }
            break;
        }
    }

    private AllocationStats diffMeasurements(AllocationStats baseline, AllocationStats measurement) {
        try {
            return new AllocationStats(measurement.allocationCount - baseline.allocationCount, measurement.allocationSize - baseline.allocationSize, measurement.reps - baseline.reps);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("The difference between the baseline (%s) and the measurement (%s) is invalid", baseline, measurement), e);
        }
    }

    static Method findMethod(Class<? extends Benchmark> benchmarkClass, String name) {
        for (Method method : benchmarkClass.getDeclaredMethods()) {
            Object[] parameterTypes = method.getParameterTypes();
            if (!method.getName().equals(name) || !Arrays.equals(parameterTypes, new Class[]{Integer.TYPE}) && !Arrays.equals(parameterTypes, new Class[]{Long.TYPE})) continue;
            return method;
        }
        throw new IllegalArgumentException(String.format("no method named %s on %s that takes either an int or a long", name, benchmarkClass));
    }

    private synchronized AllocationStats measureAllocations(Benchmark benchmark, String methodName, int reps) throws Exception {
        Method method = AllocationWorker.findMethod(benchmark.getClass(), "time" + methodName);
        this.clearAccumulatedStats();
        Object[] args = new Object[]{reps};
        this.recordAllocations = true;
        method.invoke((Object)benchmark, args);
        this.recordAllocations = false;
        return new AllocationStats(this.allocationCount, this.allocationSize, reps);
    }

    private synchronized void clearAccumulatedStats() {
        this.recordAllocations = false;
        this.allocationCount = 0;
        this.allocationSize = 0L;
    }

    static class AllocationStats {
        final int allocationCount;
        final long allocationSize;
        final int reps;

        AllocationStats(int allocationCount, long allocationSize, int reps) {
            Preconditions.checkArgument((allocationCount >= 0 ? 1 : 0) != 0, (String)"allocationCount (%s) was negative", (Object[])new Object[]{allocationCount});
            this.allocationCount = allocationCount;
            Preconditions.checkArgument((allocationSize >= 0L ? 1 : 0) != 0, (String)"allocationSize (%s) was negative", (Object[])new Object[]{allocationSize});
            this.allocationSize = allocationSize;
            Preconditions.checkArgument((reps >= 0 ? 1 : 0) != 0, (String)"reps (%s) was negative", (Object[])new Object[]{reps});
            this.reps = reps;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("allocationCount", this.allocationCount).add("allocationSize", this.allocationSize).add("reps", this.reps).toString();
        }
    }
}

