/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.bridge.CaliperControlLogMessage;
import com.google.caliper.bridge.FailureLogMessage;
import com.google.caliper.bridge.Renderer;
import com.google.caliper.bridge.StartMeasurementLogMessage;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.bridge.VmPropertiesLogMessage;
import com.google.caliper.model.Measurement;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.PrintWriter;

public final class WorkerEventLog {
    private final PrintWriter writer;
    private final Renderer<CaliperControlLogMessage> controlLogMessageRenderer;

    @Inject
    WorkerEventLog(PrintWriter writer, Renderer<CaliperControlLogMessage> controlLogMessageRenderer) {
        this.writer = writer;
        this.controlLogMessageRenderer = controlLogMessageRenderer;
    }

    public void notifyWorkerStarted() {
        this.writer.println(this.controlLogMessageRenderer.render(new VmPropertiesLogMessage()));
    }

    public void notifyWarmupPhaseStarting() {
        this.writer.println("Warmup starting.");
    }

    public void notifyMeasurementPhaseStarting() {
        this.writer.println("Measurement phase starting.");
    }

    public void notifyMeasurementStarting() {
        this.writer.println("About to measure.");
        this.writer.println(this.controlLogMessageRenderer.render(new StartMeasurementLogMessage()));
    }

    public void notifyMeasurementEnding(Measurement measurement) {
        this.notifyMeasurementEnding((Iterable<Measurement>)ImmutableList.of((Object)measurement));
    }

    public void notifyMeasurementEnding(Iterable<Measurement> measurements) {
        this.writer.println(this.controlLogMessageRenderer.render(new StopMeasurementLogMessage(measurements)));
        for (Measurement measurement : measurements) {
            this.writer.printf("I got a result! %s: %f%s%n", measurement.description(), measurement.value().magnitude() / measurement.weight(), measurement.value().unit());
        }
    }

    public void notifyMeasurementFailure(Exception e) {
        this.writer.println("MEASUREMENT FAILURE!");
        e.printStackTrace(this.writer);
    }

    public void notifyFailure(Exception e) {
        this.writer.println(this.controlLogMessageRenderer.render(new FailureLogMessage(e.getClass().getName(), Strings.nullToEmpty((String)e.getMessage()), (Iterable<StackTraceElement>)ImmutableList.copyOf((Object[])e.getStackTrace()))));
    }
}

