/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.Benchmark;
import com.google.caliper.bridge.BridgeModule;
import com.google.caliper.bridge.WorkerSpec;
import com.google.caliper.json.GsonModule;
import com.google.caliper.worker.Worker;
import com.google.caliper.worker.WorkerEventLog;
import com.google.caliper.worker.WorkerModule;
import com.google.gson.Gson;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.lang.reflect.Method;
import java.util.Map;

public final class WorkerMain {
    private WorkerMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Injector gsonInjector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new GsonModule()});
        WorkerSpec request = (WorkerSpec)((Gson)gsonInjector.getInstance(Gson.class)).fromJson(args[0], WorkerSpec.class);
        Injector workerInjector = gsonInjector.createChildInjector(new Module[]{new WorkerModule(request), new BridgeModule()});
        Worker worker = (Worker)workerInjector.getInstance(Worker.class);
        Benchmark benchmark = (Benchmark)workerInjector.getInstance(Benchmark.class);
        WorkerEventLog log = (WorkerEventLog)workerInjector.getInstance(WorkerEventLog.class);
        log.notifyWorkerStarted();
        try {
            WorkerMain.runSetUp(benchmark);
            worker.measure(benchmark, request.benchmarkSpec.methodName(), (Map<String, String>)request.workerOptions, log);
        }
        catch (Exception e) {
            log.notifyFailure(e);
        }
        finally {
            System.out.flush();
            WorkerMain.runTearDown(benchmark);
        }
    }

    private static void runSetUp(Benchmark benchmark) throws Exception {
        WorkerMain.runBenchmarkMethod(benchmark, "setUp");
    }

    private static void runTearDown(Benchmark benchmark) throws Exception {
        WorkerMain.runBenchmarkMethod(benchmark, "tearDown");
    }

    private static void runBenchmarkMethod(Benchmark benchmark, String methodName) throws Exception {
        Method method = Benchmark.class.getDeclaredMethod(methodName, new Class[0]);
        method.setAccessible(true);
        method.invoke((Object)benchmark, new Object[0]);
    }
}

