/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.multipart.io;

import java.io.ByteArrayOutputStream;

public class FixedSizeByteArrayOutputStream
extends ByteArrayOutputStream {
    private volatile int remaining;

    public FixedSizeByteArrayOutputStream(int maxSize) {
        super(maxSize);
        this.remaining = maxSize;
    }

    @Override
    public void write(int b) {
        if (this.remaining < 1) {
            throw new IllegalStateException("Cannot write. Output Stream is full. OutputStream size: " + this.buf.length);
        }
        super.write(b);
        --this.remaining;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.remaining < len) {
            throw new IllegalStateException("Cannot write. Not enough space in the OutputStream. Available space " + this.remaining + "/" + this.buf.length);
        }
        super.write(b, off, len);
        this.remaining -= len;
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.remaining = this.buf.length;
    }
}

