/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.multipart.io.buffer;

import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircularBuffer {
    private static final Logger log = LoggerFactory.getLogger(CircularBuffer.class);
    final int size;
    final byte[] buffer;
    volatile int startValidDataIndex = 0;
    volatile int nextAvailablePosition = 0;
    volatile int availableReadLength = 0;

    public CircularBuffer(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Size cannot be zero or negative. Size: " + size);
        }
        this.size = size;
        this.buffer = new byte[size];
    }

    public void write(byte data) {
        this.buffer[this.nextAvailablePosition] = data;
        this.nextAvailablePosition = this.forwards(this.nextAvailablePosition);
        if (this.availableReadLength > 0 && this.nextAvailablePosition == this.startValidDataIndex + 1) {
            this.startValidDataIndex = this.forwards(this.startValidDataIndex);
        }
        this.updateAvailableReadLength(true);
    }

    public void readAll(OutputStream outputStream) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        this.readChunk(outputStream, this.availableReadLength);
    }

    public void readChunk(OutputStream outputStream, int chunkSize) throws IOException {
        if (chunkSize > this.availableReadLength) {
            throw new IllegalArgumentException("The chunk size must be smaller or equal to the amount of available data in the buffer. Available data: " + this.availableReadLength + ", Requested chunk size: " + chunkSize);
        }
        if (chunkSize <= 0) {
            return;
        }
        if (this.startValidDataIndex + chunkSize > this.buffer.length) {
            int firstChunkLength = this.buffer.length - this.startValidDataIndex;
            outputStream.write(this.buffer, this.startValidDataIndex, firstChunkLength);
            outputStream.write(this.buffer, 0, chunkSize - firstChunkLength);
        } else {
            outputStream.write(this.buffer, this.startValidDataIndex, chunkSize);
        }
        this.startValidDataIndex = this.forwards(this.startValidDataIndex, chunkSize);
        outputStream.flush();
        this.updateAvailableReadLength(false);
    }

    public boolean isFull() {
        return this.availableReadLength == this.size;
    }

    public boolean isEmpty() {
        return this.availableReadLength == 0;
    }

    public int getAvailableDataLength() {
        return this.availableReadLength;
    }

    public int getBufferSize() {
        return this.size;
    }

    public void reset() {
        this.startValidDataIndex = 0;
        this.nextAvailablePosition = 0;
        this.availableReadLength = 0;
    }

    int forwards(int currentPosition) {
        if (currentPosition == this.buffer.length - 1) {
            return 0;
        }
        return currentPosition + 1;
    }

    int backwards(int currentPosition) {
        if (currentPosition == 0) {
            return this.buffer.length - 1;
        }
        return currentPosition - 1;
    }

    int forwards(int currentPosition, int positions) {
        int newPosition = currentPosition + positions;
        if (newPosition > this.buffer.length - 1) {
            newPosition = (currentPosition + positions) % this.size;
        }
        return newPosition;
    }

    int backwards(int currentPosition, int positions) {
        int newPosition = currentPosition - positions;
        if (newPosition < 0) {
            newPosition = this.size - Math.abs(currentPosition - positions) % this.size;
        }
        return newPosition;
    }

    void updateAvailableReadLength(boolean isWriteOperation) {
        this.availableReadLength = this.nextAvailablePosition == this.startValidDataIndex ? (isWriteOperation ? this.size : 0) : (this.nextAvailablePosition > this.startValidDataIndex ? this.nextAvailablePosition - this.startValidDataIndex : this.size - this.startValidDataIndex + this.nextAvailablePosition);
    }
}

