/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.benchmarks;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import okhttp3.HttpUrl;
import okhttp3.benchmarks.Benchmark;
import okhttp3.benchmarks.SynchronousHttpClient;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.internal.TlsUtil;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;

class ApacheHttpClient
extends SynchronousHttpClient {
    private static final boolean VERBOSE = false;
    private HttpClient client;

    ApacheHttpClient() {
    }

    @Override
    public void prepare(Benchmark benchmark) {
        super.prepare(benchmark);
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        if (benchmark.tls) {
            HandshakeCertificates handshakeCertificates = TlsUtil.localhost();
            connectionManager.getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(handshakeCertificates.sslContext())));
        }
        this.client = new DefaultHttpClient((ClientConnectionManager)connectionManager);
    }

    @Override
    public Runnable request(HttpUrl url) {
        return new ApacheHttpClientRequest(url);
    }

    class ApacheHttpClientRequest
    implements Runnable {
        private final HttpUrl url;

        ApacheHttpClientRequest(HttpUrl url) {
            this.url = url;
        }

        @Override
        public void run() {
            long start = System.nanoTime();
            try {
                HttpResponse response = ApacheHttpClient.this.client.execute((HttpUriRequest)new HttpGet(this.url.toString()));
                InputStream in = response.getEntity().getContent();
                Header contentEncoding = response.getFirstHeader("Content-Encoding");
                if (contentEncoding != null && contentEncoding.getValue().equals("gzip")) {
                    in = new GZIPInputStream(in);
                }
                long total = SynchronousHttpClient.readAllAndClose(in);
                long l = System.nanoTime();
            }
            catch (IOException e) {
                System.out.println("Failed: " + e);
            }
        }
    }
}

