/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.benchmarks;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.HttpUrl;
import okhttp3.benchmarks.Benchmark;
import okhttp3.benchmarks.SynchronousHttpClient;
import okhttp3.tls.HandshakeCertificates;
import okhttp3.tls.internal.TlsUtil;

class UrlConnection
extends SynchronousHttpClient {
    private static final boolean VERBOSE = false;

    UrlConnection() {
    }

    @Override
    public void prepare(Benchmark benchmark) {
        super.prepare(benchmark);
        if (benchmark.tls) {
            HandshakeCertificates handshakeCertificates = TlsUtil.localhost();
            SSLSocketFactory socketFactory = handshakeCertificates.sslSocketFactory();
            HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
            HttpsURLConnection.setDefaultSSLSocketFactory(socketFactory);
        }
    }

    @Override
    public Runnable request(HttpUrl url) {
        return new UrlConnectionRequest(url);
    }

    static class UrlConnectionRequest
    implements Runnable {
        private final HttpUrl url;

        UrlConnectionRequest(HttpUrl url) {
            this.url = url;
        }

        @Override
        public void run() {
            long start = System.nanoTime();
            try {
                HttpURLConnection urlConnection = (HttpURLConnection)this.url.url().openConnection();
                InputStream in = urlConnection.getInputStream();
                if ("gzip".equals(urlConnection.getHeaderField("Content-Encoding"))) {
                    in = new GZIPInputStream(in);
                }
                long total = SynchronousHttpClient.readAllAndClose(in);
                long l = System.nanoTime();
            }
            catch (IOException e) {
                System.out.println("Failed: " + e);
            }
        }
    }
}

