/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.tls;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.security.auth.x500.X500Principal;
import okhttp3.internal.Util;
import okio.ByteString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public final class HeldCertificate {
    private final X509Certificate certificate;
    private final KeyPair keyPair;

    public HeldCertificate(KeyPair keyPair, X509Certificate certificate) {
        if (keyPair == null) {
            throw new NullPointerException("keyPair == null");
        }
        if (certificate == null) {
            throw new NullPointerException("certificate == null");
        }
        this.certificate = certificate;
        this.keyPair = keyPair;
    }

    public X509Certificate certificate() {
        return this.certificate;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public String certificatePem() {
        try {
            StringBuilder result = new StringBuilder();
            result.append("-----BEGIN CERTIFICATE-----\n");
            this.encodeBase64Lines(result, ByteString.of((byte[])this.certificate.getEncoded()));
            result.append("-----END CERTIFICATE-----\n");
            return result.toString();
        }
        catch (CertificateEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String privateKeyPkcs8Pem() {
        StringBuilder result = new StringBuilder();
        result.append("-----BEGIN PRIVATE KEY-----\n");
        this.encodeBase64Lines(result, ByteString.of((byte[])this.keyPair.getPrivate().getEncoded()));
        result.append("-----END PRIVATE KEY-----\n");
        return result.toString();
    }

    public String privateKeyPkcs1Pem() {
        if (!(this.keyPair.getPrivate() instanceof RSAPrivateKey)) {
            throw new IllegalStateException("PKCS1 only supports RSA keys");
        }
        StringBuilder result = new StringBuilder();
        result.append("-----BEGIN RSA PRIVATE KEY-----\n");
        this.encodeBase64Lines(result, this.pkcs1Bytes());
        result.append("-----END RSA PRIVATE KEY-----\n");
        return result.toString();
    }

    private ByteString pkcs1Bytes() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)this.keyPair.getPrivate().getEncoded());
            return ByteString.of((byte[])privateKeyInfo.parsePrivateKey().toASN1Primitive().getEncoded());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void encodeBase64Lines(StringBuilder out, ByteString data) {
        String base64 = data.base64();
        for (int i = 0; i < base64.length(); i += 64) {
            out.append(base64, i, Math.min(i + 64, base64.length())).append('\n');
        }
    }

    public static final class Builder {
        private static final long DEFAULT_DURATION_MILLIS = 86400000L;
        private long notBefore = -1L;
        private long notAfter = -1L;
        @Nullable
        private String cn;
        @Nullable
        private String ou;
        private final List<String> altNames = new ArrayList<String>();
        @Nullable
        private BigInteger serialNumber;
        @Nullable
        private KeyPair keyPair;
        @Nullable
        private HeldCertificate signedBy;
        private int maxIntermediateCas = -1;
        @Nullable
        private String keyAlgorithm;
        private int keySize;

        public Builder() {
            this.ecdsa256();
        }

        public Builder validityInterval(long notBefore, long notAfter) {
            if (notBefore > notAfter || notBefore == -1L != (notAfter == -1L)) {
                throw new IllegalArgumentException("invalid interval: " + notBefore + ".." + notAfter);
            }
            this.notBefore = notBefore;
            this.notAfter = notAfter;
            return this;
        }

        public Builder duration(long duration, TimeUnit unit) {
            long now = System.currentTimeMillis();
            return this.validityInterval(now, now + unit.toMillis(duration));
        }

        public Builder addSubjectAlternativeName(String altName) {
            if (altName == null) {
                throw new NullPointerException("altName == null");
            }
            this.altNames.add(altName);
            return this;
        }

        public Builder commonName(String cn) {
            this.cn = cn;
            return this;
        }

        public Builder organizationalUnit(String ou) {
            this.ou = ou;
            return this;
        }

        public Builder serialNumber(BigInteger serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public Builder serialNumber(long serialNumber) {
            return this.serialNumber(BigInteger.valueOf(serialNumber));
        }

        public Builder keyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public Builder keyPair(PublicKey publicKey, PrivateKey privateKey) {
            return this.keyPair(new KeyPair(publicKey, privateKey));
        }

        public Builder signedBy(HeldCertificate signedBy) {
            this.signedBy = signedBy;
            return this;
        }

        public Builder certificateAuthority(int maxIntermediateCas) {
            if (maxIntermediateCas < 0) {
                throw new IllegalArgumentException("maxIntermediateCas < 0: " + maxIntermediateCas);
            }
            this.maxIntermediateCas = maxIntermediateCas;
            return this;
        }

        public Builder ecdsa256() {
            this.keyAlgorithm = "EC";
            this.keySize = 256;
            return this;
        }

        public Builder rsa2048() {
            this.keyAlgorithm = "RSA";
            this.keySize = 2048;
            return this;
        }

        public HeldCertificate build() {
            X500Principal signedByPrincipal;
            KeyPair signedByKeyPair;
            KeyPair heldKeyPair = this.keyPair != null ? this.keyPair : this.generateKeyPair();
            X500Principal subject = this.buildSubject();
            if (this.signedBy != null) {
                signedByKeyPair = this.signedBy.keyPair;
                signedByPrincipal = this.signedBy.certificate.getSubjectX500Principal();
            } else {
                signedByKeyPair = heldKeyPair;
                signedByPrincipal = subject;
            }
            long notBefore = this.notBefore != -1L ? this.notBefore : System.currentTimeMillis();
            long notAfter = this.notAfter != -1L ? this.notAfter : notBefore + 86400000L;
            BigInteger serialNumber = this.serialNumber != null ? this.serialNumber : BigInteger.ONE;
            X509V3CertificateGenerator generator = new X509V3CertificateGenerator();
            generator.setSerialNumber(serialNumber);
            generator.setIssuerDN(signedByPrincipal);
            generator.setNotBefore(new Date(notBefore));
            generator.setNotAfter(new Date(notAfter));
            generator.setSubjectDN(subject);
            generator.setPublicKey(heldKeyPair.getPublic());
            generator.setSignatureAlgorithm(signedByKeyPair.getPrivate() instanceof RSAPrivateKey ? "SHA256WithRSAEncryption" : "SHA256withECDSA");
            if (this.maxIntermediateCas != -1) {
                generator.addExtension(X509Extensions.BasicConstraints, true, (ASN1Encodable)new BasicConstraints(this.maxIntermediateCas));
            }
            if (!this.altNames.isEmpty()) {
                ASN1Encodable[] encodableAltNames = new ASN1Encodable[this.altNames.size()];
                int size = this.altNames.size();
                for (int i = 0; i < size; ++i) {
                    String altName = this.altNames.get(i);
                    int tag = Util.verifyAsIpAddress((String)altName) ? 7 : 2;
                    encodableAltNames[i] = new GeneralName(tag, altName);
                }
                generator.addExtension(X509Extensions.SubjectAlternativeName, true, (ASN1Encodable)new DERSequence(encodableAltNames));
            }
            try {
                X509Certificate certificate = generator.generateX509Certificate(signedByKeyPair.getPrivate());
                return new HeldCertificate(heldKeyPair, certificate);
            }
            catch (GeneralSecurityException e) {
                throw new AssertionError((Object)e);
            }
        }

        private X500Principal buildSubject() {
            StringBuilder nameBuilder = new StringBuilder();
            if (this.cn != null) {
                nameBuilder.append("CN=").append(this.cn);
            } else {
                nameBuilder.append("CN=").append(UUID.randomUUID());
            }
            if (this.ou != null) {
                nameBuilder.append(", OU=").append(this.ou);
            }
            return new X500Principal(nameBuilder.toString());
        }

        private KeyPair generateKeyPair() {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.keyAlgorithm);
                keyPairGenerator.initialize(this.keySize, new SecureRandom());
                return keyPairGenerator.generateKeyPair();
            }
            catch (GeneralSecurityException e) {
                throw new AssertionError((Object)e);
            }
        }

        static {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

