/*
 * Decompiled with CFR 0.152.
 */
package cn.jovision.jovisionsocket.controller;

import cn.jovision.jovisionsocket.pojo.ResponseInfo;
import cn.jovision.jovisionsocket.socket.SocketThread;
import cn.jovision.jovisionsocket.util.CryptographyUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.ws.rs.core.Response;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.commons.codec.binary.Base64;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
public class GreeingController {
    @RequestMapping(value={"/api/getAccessToken"})
    public ResponseInfo doGetToken(@org.springframework.web.bind.annotation.RequestBody String json) {
        ResponseInfo responseInfo = new ResponseInfo();
        JSONObject retObj = new JSONObject();
        try {
            JSONObject jsonobj = JSON.parseObject((String)json);
            if (jsonobj.get((Object)"method").equals("accesstoken")) {
                String method = jsonobj.getString("method");
                String deviceId = jsonobj.getString("uuid");
                String deviceKey = jsonobj.getString("device_key");
                int deviceType = jsonobj.getIntValue("device_type");
                String mac = jsonobj.getString("mac");
                long time = jsonobj.getLongValue("timestamp");
                String token = deviceId + deviceKey + UUID.randomUUID().toString();
                String TCP_Host = System.getenv("TCP_Host");
                String TCP_Port = System.getenv("TCP_Port");
                if (TCP_Host == null) {
                    TCP_Host = "192.168.5.170";
                }
                if (TCP_Port == null) {
                    TCP_Port = "6060";
                }
                retObj.put("method", (Object)method);
                retObj.put("uuid", (Object)deviceId);
                retObj.put("expires_in", (Object)"2021-01-01");
                retObj.put("token", (Object)token);
                retObj.put("mac", (Object)mac);
                retObj.put("tcp_port", (Object)String.format("http://%s:%s/api/face/push", TCP_Host, TCP_Port));
            }
        }
        catch (Exception e) {
            responseInfo.setCode(-1001);
            responseInfo.setRetMsg("\u7cfb\u7edf\u5f02\u5e38,\u83b7\u53d6\u5931\u8d25");
            return responseInfo;
        }
        responseInfo.setCode(0);
        responseInfo.setRetMsg("\u83b7\u53d6\u6210\u529f");
        responseInfo.setDataObject(retObj);
        return responseInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"/api/face/push"})
    public ResponseInfo facePush(@org.springframework.web.bind.annotation.RequestBody String json) {
        System.out.println("\u4e0a\u4f20\u4eba\u8138\u6bd4\u5bf9\u6570\u636e=================");
        ResponseInfo response = new ResponseInfo();
        try {
            JSONObject jsonobj = JSON.parseObject((String)json);
            if (jsonobj.get((Object)"method").equals("sw_face_compare_push")) {
                String deviceId = jsonobj.getString("uuid");
                String deviceMAC = jsonobj.getString("mac");
                String hostIp = jsonobj.getString("host");
                String productName = jsonobj.getString("product_name");
                int deviceType = jsonobj.getIntValue("device_type");
                JSONObject dataInfo = jsonobj.getJSONObject("data");
                int channel = dataInfo.getIntValue("channel");
                Long serverId = dataInfo.getLongValue("index_id");
                int listSort = dataInfo.getIntValue("pic_sort");
                String picName = dataInfo.getString("pic_name");
                int position = dataInfo.getIntValue("position");
                String captureTime = dataInfo.getString("capture_time");
                String sendTime = dataInfo.getString("SendTime");
                int faceQuality = dataInfo.getIntValue("quality");
                int visitCount = dataInfo.getIntValue("visit_count");
                int compareResult = dataInfo.getIntValue("match_score");
                String image = dataInfo.getString("img_data");
                String temperature = "";
                JSONObject temperatureObj = dataInfo.getJSONObject("temperature");
                if (temperatureObj != null) {
                    temperature = temperatureObj.getString("realtime_t");
                }
                JSONObject attributeInfo = dataInfo.getJSONObject("attribute");
                int gender = attributeInfo.getIntValue("gender");
                int age = attributeInfo.getIntValue("age ");
                Object pattern = null;
                if (image != null) {
                    // empty if block
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u4fdd\u5b58\u4eba\u8138\u63a8\u9001\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff1a{}" + e.getMessage());
            response.setCode(-1001);
        }
        this.post_request(json);
        System.out.println("\u4f3a\u670d\u5668\u4e0a\u50b3\u6210\u529f");
        response.setCode(0);
        response.setRetMsg("\u4e0a\u4f20\u6570\u636e\u6210\u529f");
        return response;
    }

    public String post_request(@org.springframework.web.bind.annotation.RequestBody String json) {
        String API_Host = System.getenv("API_Host");
        String API_Port = System.getenv("API_Port");
        String API_Res = System.getenv("API_Res");
        if (API_Host == null) {
            API_Host = "192.168.6.240";
        }
        if (API_Port == null) {
            API_Port = "5000";
        }
        if (API_Res == null) {
            API_Res = "/punch/card/upload";
        }
        String url = String.format("http://%s:%s%s", API_Host, API_Port, API_Res);
        System.out.println(url);
        JSONObject jsonres = JSONObject.parseObject((String)json);
        String deviceId = jsonres.getString("uuid");
        String hostIp = jsonres.getString("host");
        JSONObject resbody = jsonres.getJSONObject("data");
        String capture_time = resbody.getString("capture_time");
        String match_score = resbody.getString("match_score");
        String face_name = resbody.getString("face_name");
        String face_num = resbody.getString("face_num");
        String image_data = resbody.getString("img_data");
        JSONObject tem = resbody.getJSONObject("temperature");
        String temperature = tem.getString("realtime_t");
        JSONObject pos = resbody.getJSONObject("data");
        String x = pos.getString("x");
        String y = pos.getString("y");
        String w = pos.getString("w");
        String h = pos.getString("h");
        Date now = new Date();
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String datetime = ft.format(now);
        JsonObject jsonmessage = new JsonObject();
        jsonmessage.addProperty("uuid", deviceId);
        jsonmessage.addProperty("host", hostIp);
        jsonmessage.addProperty("match_score", match_score);
        jsonmessage.addProperty("face_name", face_name);
        jsonmessage.addProperty("face_num", face_num);
        jsonmessage.addProperty("img_data", "...");
        jsonmessage.addProperty("temperature", temperature);
        jsonmessage.addProperty("Timestamp", capture_time);
        jsonmessage.addProperty("Time", datetime);
        System.out.println(jsonmessage);
        OkHttpClient client = new OkHttpClient().newBuilder().writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS).build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)("{\r\n    \"UUID\":\"" + deviceId + "\",\r\n    \"Host\":\"" + hostIp + "\",\r\n    \"Port\":7070,\r\n    \"ID\": \"" + face_num + "\",\r\n    \"Name\": \"" + face_name + "\",\r\n    \"Temperature\":\"" + temperature + "\",\r\n    \"Position\":{\r\n        \"X\":\"" + x + "\",\r\n        \"Y\":\"" + y + "\",\r\n        \"W\":\"" + w + "\",\r\n        \"H\":\"" + h + "\"\r\n    },\r\n    \"Image\":\"" + image_data + "\",\r\n    \"Similarity\":" + match_score + ",\r\n    \"Timestamp\":\"" + capture_time + "\",\r\n  \"Time\":\"" + datetime + "\",\r\n  \"Type\":4\r\n}"));
        System.out.println(body);
        Request request = new Request.Builder().url(url).method("POST", body).addHeader("Content-Type", "application/json").build();
        String res = null;
        try {
            okhttp3.Response response01 = client.newCall(request).execute();
            int code = response01.code();
            if (code == 200) {
                okhttp3.ResponseBody body1 = response01.body();
                res = body1.string();
                body1.close();
            }
        }
        catch (IOException e) {
            System.out.println(String.format("\u5c07\u8cc7\u6599\u50b3\u9001\u5230%s\u4f3a\u670d\u5668\u6642\u767c\u751f\u932f\u8aa4\uff01", url));
        }
        return res;
    }

    @RequestMapping(value={"/api/sw_server_update_pic"})
    @ResponseBody
    public Response sw_server_update_pic(MultipartHttpServletRequest request) {
        MultipartFile image = request.getFile("imageURLValue");
        String method = request.getParameter("method");
        String serverId = request.getParameter("serverId");
        String faceRcgName = request.getParameter("faceRcgName");
        String faceID = request.getParameter("faceID");
        String gender = request.getParameter("gender");
        String uuid = request.getParameter("uuid");
        JSONObject wholeJsonObj = new JSONObject(true);
        JSONObject jsonObject = new JSONObject(true);
        jsonObject.put("method", (Object)method);
        JSONObject paramObj = new JSONObject(true);
        JSONObject attributeObj = new JSONObject(true);
        JSONObject s_paramObj = new JSONObject(true);
        JSONObject showObj = new JSONObject(true);
        JSONObject s_wholeJsonObj = new JSONObject(true);
        try {
            OutputStream outputStream = this.getSocketOutputStream(uuid);
            int intserverId = Integer.parseInt(serverId);
            int intgender = Integer.parseInt(gender);
            String regex = "[\u4e00-\u9fa5]";
            ArrayList<String> list = new ArrayList<String>();
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(faceRcgName);
            while (matcher.find()) {
                list.add(matcher.group());
            }
            String rootPath = "UPLOAD";
            String imagename = image.getOriginalFilename();
            File dir = new File(rootPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File severfile = new File(dir.getAbsolutePath() + "/" + imagename);
            try {
                image.transferTo(severfile);
            }
            catch (IOException e) {
                System.out.println("\u5c07\u6a94\u6848\u5132\u5b58\u5230Upload\u8cc7\u6599\u593e\u6642\u767c\u751f\u932f\u8aa4\uff01");
            }
            byte[] data = this.fileToByte(dir.getAbsolutePath() + "/" + imagename);
            Base64 base64 = new Base64();
            String jpegBase64 = Base64.encodeBase64String((byte[])data);
            String jpegBase64MD5 = CryptographyUtil.hashMd5Hex(jpegBase64);
            attributeObj.put("name", (Object)faceRcgName);
            attributeObj.put("gender", (Object)intgender);
            attributeObj.put("card_id", (Object)faceID);
            paramObj.put("attribute", (Object)attributeObj);
            paramObj.put("index_id", (Object)intserverId);
            if (jpegBase64 != null && !jpegBase64.equals("")) {
                paramObj.put("img_data", (Object)jpegBase64);
            }
            if (jpegBase64MD5 != null && !jpegBase64MD5.equals("")) {
                paramObj.put("jpegBase64MD5", (Object)jpegBase64MD5);
            }
            jsonObject.put("method", (Object)"sw_server_update_pic");
            jsonObject.put("param", (Object)paramObj);
            wholeJsonObj.put("dataLength", (Object)"0000000000");
            wholeJsonObj.put("data", (Object)jsonObject);
            String postJson = wholeJsonObj.toJSONString();
            wholeJsonObj.put("dataLength", (Object)String.format("%010d", postJson.length()));
            postJson = wholeJsonObj.toJSONString();
            s_paramObj.put("attribute", (Object)attributeObj);
            s_paramObj.put("index_id", (Object)intserverId);
            if (jpegBase64 != null && !jpegBase64.equals("")) {
                s_paramObj.put("img_data", (Object)"...");
            }
            if (jpegBase64MD5 != null && !jpegBase64MD5.equals("")) {
                s_paramObj.put("jpegBase64MD5", (Object)jpegBase64MD5);
            }
            showObj.put("method", (Object)"sw_server_update_pic");
            showObj.put("param", (Object)s_paramObj);
            s_wholeJsonObj.put("dataLength", (Object)"0000000000");
            s_wholeJsonObj.put("data", (Object)showObj);
            String showJson = s_wholeJsonObj.toJSONString().trim();
            s_wholeJsonObj.put("dataLength", (Object)String.format("%010d", showJson.length()));
            showJson = s_wholeJsonObj.toJSONString().trim();
            System.out.println(showJson);
            outputStream.write(postJson.getBytes());
            outputStream.flush();
            String errcode = this.run();
            JSONObject errobj = JSON.parseObject((String)errcode);
            s_wholeJsonObj.put("errcode", (Object)errobj);
            return Response.ok().entity((Object)s_wholeJsonObj).build();
        }
        catch (IOException e) {
            System.out.println(String.format("\u4fee\u6539\u4eba\u81c9\u5eab\u8cc7\u6599\u5931\u6557\uff01", new Object[0]));
            return Response.serverError().entity((Object)s_wholeJsonObj).build();
        }
        catch (NullPointerException n) {
            System.out.println("\u4fee\u6539\u4eba\u81c9\u5eab\u8cc7\u6599\u5931\u6557\uff01");
            return Response.serverError().entity((Object)s_wholeJsonObj).build();
        }
        catch (StringIndexOutOfBoundsException str) {
            System.out.println("\u5716\u6a94\u7121\u6cd5\u8b80\u53d6");
            return Response.serverError().entity((Object)s_wholeJsonObj).build();
        }
    }

    @RequestMapping(value={"/api/sw_server_add_pic"}, method={RequestMethod.POST})
    @ResponseBody
    public Response sw_server_add_pic(MultipartHttpServletRequest request) {
        MultipartFile image = request.getFile("imageURLValue");
        String method = request.getParameter("method");
        String serverId = request.getParameter("serverId");
        String faceRcgName = request.getParameter("faceRcgName");
        String faceID = request.getParameter("faceID");
        String gender = request.getParameter("gender");
        String uuid = request.getParameter("uuid");
        JSONObject paramObj = new JSONObject(true);
        JSONObject jsonObject = new JSONObject(true);
        JSONObject attributeObj = new JSONObject(true);
        JSONObject s_paramObj = new JSONObject(true);
        JSONObject showObj = new JSONObject(true);
        JSONObject s_wholeJsonObj = new JSONObject(true);
        try {
            OutputStream outputStream = this.getSocketOutputStream(uuid);
            String rootPath = "UPLOAD";
            String imagename = image.getOriginalFilename();
            File dir = new File(rootPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File severfile = new File(dir.getAbsolutePath() + "/" + imagename);
            try {
                image.transferTo(severfile);
            }
            catch (IOException e) {
                System.out.println("\u5c07\u6a94\u6848\u5132\u5b58\u5230Upload\u8cc7\u6599\u593e\u6642\u767c\u751f\u932f\u8aa4\uff01");
            }
            byte[] data = this.fileToByte(dir.getAbsolutePath() + "/" + imagename);
            Base64 base64 = new Base64();
            String jpegBase64 = Base64.encodeBase64String((byte[])data);
            String jpegBase64MD5 = CryptographyUtil.hashMd5Hex(jpegBase64);
            int intseverId = Integer.parseInt(serverId);
            int intgender = Integer.parseInt(gender);
            String regex = "[\u4e00-\u9fa5]";
            ArrayList<String> list = new ArrayList<String>();
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(faceRcgName);
            while (matcher.find()) {
                list.add(matcher.group());
            }
            attributeObj.put("name", (Object)faceRcgName);
            attributeObj.put("gender", (Object)intgender);
            attributeObj.put("card_id", (Object)faceID);
            paramObj.put("attribute", (Object)attributeObj);
            paramObj.put("index_id", (Object)intseverId);
            paramObj.put("img_data", (Object)jpegBase64);
            paramObj.put("jpegBase64MD5", (Object)jpegBase64MD5);
            jsonObject.put("method", (Object)method);
            jsonObject.put("param", (Object)paramObj);
            JSONObject wholeJsonObj = new JSONObject(true);
            wholeJsonObj.put("dataLength", (Object)"0000000000");
            wholeJsonObj.put("data", (Object)jsonObject);
            String postJson = wholeJsonObj.toJSONString().trim();
            wholeJsonObj.put("dataLength", (Object)String.format("%010d", postJson.length()));
            postJson = wholeJsonObj.toJSONString().trim();
            s_paramObj.put("attribute", (Object)attributeObj);
            s_paramObj.put("index_id", (Object)intseverId);
            s_paramObj.put("img_data", (Object)"...");
            s_paramObj.put("jpegBase64MD5", (Object)jpegBase64MD5);
            showObj.put("method", (Object)method);
            showObj.put("param", (Object)s_paramObj);
            s_wholeJsonObj.put("dataLength", (Object)"0000000000");
            s_wholeJsonObj.put("data", (Object)showObj);
            String showJson = s_wholeJsonObj.toJSONString().trim();
            s_wholeJsonObj.put("dataLength", (Object)String.format("%010d", showJson.length()));
            showJson = s_wholeJsonObj.toJSONString().trim();
            outputStream.write(postJson.getBytes());
            outputStream.flush();
            String errcode = this.run();
            JSONObject errobj = JSON.parseObject((String)errcode);
            s_wholeJsonObj.put("errcode", (Object)errobj);
            return Response.ok().entity((Object)s_wholeJsonObj).build();
        }
        catch (IOException e) {
            System.out.println("\u65b0\u589e\u4eba\u81c9\u5eab\u8cc7\u6599\u5931\u6557\uff01");
            return Response.serverError().entity((Object)s_wholeJsonObj).build();
        }
        catch (NullPointerException n) {
            System.out.println("\u65b0\u589e\u4eba\u81c9\u5eab\u8cc7\u6599\u5931\u6557\uff01");
            return Response.serverError().entity((Object)s_wholeJsonObj).build();
        }
    }

    @RequestMapping(value={"/api/sw_server_add_multiple_pic"})
    public void sw_server_add_multiple_pic(MultipartHttpServletRequest request) {
        try {
            String uuid = request.getParameter("uuid");
            String method = request.getParameter("method");
            List images = request.getFiles("imageURLValue");
            String[] userName = request.getParameterValues("userName");
            String[] personNo = request.getParameterValues("personNo");
            String[] serverId = request.getParameterValues("serverId");
            String[] genderId = request.getParameterValues("genderId");
            OutputStream outputStream = this.getSocketOutputStream(uuid);
            JSONObject wholeJsonObj = new JSONObject(true);
            JSONObject jsonObject = new JSONObject(true);
            jsonObject.put("method", (Object)method);
            ArrayList<JSONObject> paramList = new ArrayList<JSONObject>();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < userName.length; ++i) {
                String username = userName[i];
                String personno = personNo[i];
                String serverid = serverId[i];
                String genderid = genderId[i];
                MultipartFile image = (MultipartFile)images.get(i);
                int intseverId = Integer.parseInt(serverid);
                int intgender = Integer.parseInt(genderid);
                String regex = "[\u4e00-\u9fa5]";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(username);
                while (matcher.find()) {
                    list.add(matcher.group());
                }
                String rootPath = "UPLOAD";
                String imagename = image.getOriginalFilename();
                String newfileName = UUID.randomUUID() + imagename.substring(imagename.lastIndexOf("."));
                File dir = new File(rootPath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File severfile = new File(dir.getAbsolutePath() + "/" + imagename);
                try {
                    image.transferTo(severfile);
                }
                catch (IOException e) {
                    System.out.println("\u5c07\u6a94\u6848\u5132\u5b58\u5230Upload\u8cc7\u6599\u593e\u6642\u767c\u751f\u932f\u8aa4\uff01");
                }
                byte[] data = this.fileToByte(dir.getAbsolutePath() + "/" + imagename);
                Base64 base64 = new Base64();
                String jpegBase64 = Base64.encodeBase64String((byte[])data);
                String jpegBase64MD5 = CryptographyUtil.hashMd5Hex(jpegBase64);
                JSONObject attributeObj = new JSONObject(true);
                attributeObj.put("name", (Object)username);
                attributeObj.put("gender", (Object)intgender);
                attributeObj.put("card_id", (Object)personno);
                JSONObject paramObj = new JSONObject(true);
                paramObj.put("attribute", (Object)attributeObj);
                paramObj.put("index_id", (Object)intseverId);
                paramObj.put("img_data", (Object)jpegBase64);
                paramObj.put("jpegBase64MD5", (Object)jpegBase64MD5);
                paramList.add(paramObj);
            }
            JSONArray paramArray = null;
            paramArray = JSONArray.parseArray((String)JSON.toJSONString(paramList));
            jsonObject.put("param", (Object)paramArray);
            wholeJsonObj.put("dataLength", (Object)"0000000000");
            wholeJsonObj.put("data", (Object)jsonObject);
            String postJson = wholeJsonObj.toJSONString();
            wholeJsonObj.put("dataLength", (Object)String.format("%010d", postJson.length()));
            postJson = wholeJsonObj.toJSONString().trim();
            System.out.println(postJson);
            outputStream.write(postJson.getBytes());
            outputStream.flush();
        }
        catch (Exception e) {
            System.out.println("\u65b0\u589e\u6279\u91cf\u4eba\u81c9\u5eab\u8cc7\u6599\u5931\u6557\uff01");
        }
    }

    @RequestMapping(value={"/api/sw_server_del_pic"})
    @ResponseBody
    public Response sw_server_del_pic(MultipartHttpServletRequest request) {
        JSONObject jsonObject = new JSONObject(true);
        JSONObject wholeJsonObj = new JSONObject(true);
        JSONObject paramObj = new JSONObject(true);
        try {
            String method = request.getParameter("method");
            String serverId = request.getParameter("serverId");
            String uuid = request.getParameter("uuid");
            OutputStream outputStream = this.getSocketOutputStream(uuid);
            int intserverId = Integer.parseInt(serverId);
            jsonObject.put("method", (Object)method);
            paramObj.put("index_id", (Object)intserverId);
            jsonObject.put("param", (Object)paramObj);
            wholeJsonObj.put("dataLength", (Object)"0000000000");
            wholeJsonObj.put("data", (Object)jsonObject);
            String postJson = wholeJsonObj.toJSONString().trim();
            wholeJsonObj.put("dataLength", (Object)String.format("%010d", postJson.length()));
            postJson = wholeJsonObj.toJSONString().trim();
            System.out.println(postJson);
            outputStream.write(postJson.getBytes());
            outputStream.flush();
            String errcode = this.run();
            JSONObject errobj = JSON.parseObject((String)errcode);
            wholeJsonObj.put("errcode", (Object)errobj);
            return Response.ok().entity((Object)wholeJsonObj).build();
        }
        catch (IOException e) {
            System.out.println("\u522a\u9664\u4eba\u81c9\u5eab\u8cc7\u6599\u5931\u6557\uff01");
            return Response.serverError().entity((Object)wholeJsonObj).build();
        }
        catch (NullPointerException n) {
            System.out.println("\u522a\u9664\u4eba\u81c9\u5eab\u8cc7\u6599\u5931\u6557\uff01");
            return Response.serverError().entity((Object)wholeJsonObj).build();
        }
    }

    @RequestMapping(value={"/api/sw_server_del_multiple_pic"})
    public void sw_server_del_multiple_pic(MultipartHttpServletRequest request) {
        try {
            String uuid = request.getParameter("uuid");
            String method = request.getParameter("method");
            String[] serverIds = request.getParameterValues("serverIds");
            OutputStream outputStream = this.getSocketOutputStream(uuid);
            for (int i = 0; i < serverIds.length; ++i) {
                String method01 = "sw_server_del_pic";
                String strserverId = serverIds[i];
                String regEx = "[^0-9]";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(strserverId);
                int intserverId = Integer.parseInt(m.replaceAll("").trim());
                JSONObject jsonObject = new JSONObject(true);
                jsonObject.put("method", (Object)method01);
                JSONObject wholeJsonObj = new JSONObject(true);
                JSONObject paramObj = new JSONObject(true);
                paramObj.put("index_id", (Object)intserverId);
                jsonObject.put("param", (Object)paramObj);
                wholeJsonObj.put("dataLength", (Object)"0000000000");
                wholeJsonObj.put("data", (Object)jsonObject);
                String postJson = wholeJsonObj.toJSONString().trim();
                wholeJsonObj.put("dataLength", (Object)String.format("%010d", postJson.length()));
                postJson = wholeJsonObj.toJSONString().trim();
                System.out.println(postJson);
                outputStream.write(postJson.getBytes());
                outputStream.flush();
            }
        }
        catch (IOException e) {
            System.out.println("\u522a\u9664\u6279\u91cf\u4eba\u81c9\u5eab\u8cc7\u6599\u5931\u6557\uff01");
        }
    }

    private OutputStream getSocketOutputStream(String uuid) {
        try {
            Map<String, Socket> map = SocketThread.socketMap;
            if (!map.isEmpty()) {
                Socket socket = map.get(uuid);
                OutputStream outputStream = socket.getOutputStream();
                if (outputStream != null) {
                    return outputStream;
                }
                System.out.println("\u8fde\u63a5\u5173\u95ed");
            }
            System.out.println("\u6682\u65e0\u8bbe\u5907\u00b7");
        }
        catch (IOException e) {
            System.out.println("UUID\u8207\u8a2d\u5099\u7de8\u865f\u4e0d\u7b26\u5408\uff0c\u9023\u7dda\u5931\u6557\uff01");
        }
        catch (NullPointerException n) {
            System.out.println("UUID\u8207\u8a2d\u5099\u7de8\u865f\u4e0d\u7b26\u5408\uff0c\u9023\u7dda\u5931\u6557\uff01");
        }
        return null;
    }

    private byte[] fileToByte(String imageURLValue) {
        if (imageURLValue == null || imageURLValue.equals("")) {
            System.out.println("\u6587\u4ef6\u4e0d\u5b58\u5728");
            return null;
        }
        File file = null;
        ByteArrayOutputStream baos = null;
        BufferedImage bi = null;
        try {
            file = new File(imageURLValue);
            bi = ImageIO.read(file);
            baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, "jpg", baos);
            return baos.toByteArray();
        }
        catch (IOException e) {
            System.out.println("\u5716\u6a94\u8b80\u53d6\u5931\u6557\uff01");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String run() {
        ServerSocket serverSocket = null;
        String result = "";
        try {
            serverSocket = new ServerSocket(6666);
            Socket server = serverSocket.accept();
            DataInputStream in = new DataInputStream(server.getInputStream());
            result = in.readUTF();
            server.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (serverSocket != null) {
                    serverSocket.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return result;
        }
    }
}

