/*
 * Decompiled with CFR 0.152.
 */
package cn.jovision.jovisionsocket.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class CryptographyUtil {
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA-1";
    private static final String SHA256 = "SHA-256";

    private static String hashHex(String algorithm, String val, byte[] salt) {
        if (val == null) {
            return null;
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(algorithm);
            if (salt != null) {
                digest.update(salt);
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        return Hex.encodeHexString((byte[])digest.digest(val.getBytes(Charset.forName("UTF-8"))));
    }

    private static String hashBase64(String algorithm, String val) {
        if (val == null) {
            return null;
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        return Base64.encodeBase64String((byte[])digest.digest(val.getBytes(Charset.forName("UTF-8"))));
    }

    public static String hashMd5Hex(String val) {
        return CryptographyUtil.hashHex(MD5, val, null);
    }

    public static String hashMd5Hex(String val, byte[] salt) {
        return CryptographyUtil.hashHex(MD5, val, salt);
    }

    public static String hashMd5Base64(String val) {
        return CryptographyUtil.hashBase64(MD5, val);
    }

    public static String hashSha256Hex(String val) {
        return CryptographyUtil.hashHex(SHA256, val, null);
    }

    public static String hashSha256Base64(String val) {
        return CryptographyUtil.hashBase64(SHA256, val);
    }

    public static String hashSha1Base64(String val) {
        return CryptographyUtil.hashBase64(SHA1, val);
    }

    public static String hashSha1Hex(String val) {
        return CryptographyUtil.hashHex(SHA1, val, null);
    }
}

