/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.config;

import com.google.caliper.config.CaliperConfig;
import com.google.caliper.config.InvalidConfigurationException;
import com.google.caliper.options.CaliperOptions;
import com.google.caliper.util.Util;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public final class CaliperConfigLoader {
    private final CaliperOptions options;

    @Inject
    CaliperConfigLoader(CaliperOptions options) {
        this.options = options;
    }

    public CaliperConfig loadOrCreate() throws InvalidConfigurationException {
        ImmutableMap<String, String> user;
        ImmutableMap<String, String> defaults;
        File configFile = this.options.caliperConfigFile();
        try {
            defaults = Util.loadProperties(Util.resourceSupplier(CaliperConfig.class, "global-config.properties"));
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        if (configFile.exists()) {
            try {
                ImmutableMap<String, String> user2 = Util.loadProperties((InputSupplier<? extends InputStream>)Files.newInputStreamSupplier((File)configFile));
                return new CaliperConfig(CaliperConfigLoader.mergeProperties(this.options.configProperties(), user2, defaults));
            }
            catch (IOException keepGoing) {
                // empty catch block
            }
        }
        InputSupplier<InputStream> supplier = Util.resourceSupplier(CaliperConfig.class, "default-config.properties");
        CaliperConfigLoader.tryCopyIfNeeded(supplier, configFile);
        try {
            user = Util.loadProperties(supplier);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return new CaliperConfig(CaliperConfigLoader.mergeProperties(this.options.configProperties(), user, defaults));
    }

    private static ImmutableMap<String, String> mergeProperties(Map<String, String> commandLine, Map<String, String> user, Map<String, String> defaults) {
        HashMap map = Maps.newHashMap(defaults);
        map.putAll(user);
        map.putAll(commandLine);
        Iterables.removeIf(map.values(), (Predicate)Predicates.equalTo((Object)""));
        return ImmutableMap.copyOf((Map)map);
    }

    private static void tryCopyIfNeeded(InputSupplier<? extends InputStream> supplier, File rcFile) {
        if (!rcFile.exists()) {
            try {
                Files.copy(supplier, (File)rcFile);
            }
            catch (IOException e) {
                rcFile.delete();
            }
        }
    }
}

