/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.config;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class VmConfig {
    private final File javaHome;
    private final ImmutableList<String> options;

    private VmConfig(Builder builder) {
        this.javaHome = builder.javaHome;
        this.options = builder.optionsBuilder.build();
    }

    public File javaHome() {
        return this.javaHome;
    }

    public File javaExecutable() {
        return new File(this.javaHome, "bin/java");
    }

    public ImmutableList<String> options() {
        return this.options;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof VmConfig) {
            VmConfig that = (VmConfig)obj;
            return this.javaHome.equals(that.javaHome) && this.options.equals(that.options);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.javaHome, this.options});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("javaHome", (Object)this.javaHome).add("options", this.options).toString();
    }

    static final class Builder {
        private final File javaHome;
        private final ImmutableList.Builder<String> optionsBuilder = ImmutableList.builder();

        public Builder(File javaHome) {
            this.javaHome = (File)Preconditions.checkNotNull((Object)javaHome);
        }

        public Builder addOption(String option) {
            this.optionsBuilder.add((Object)option);
            return this;
        }

        public Builder addAllOptions(Iterable<String> options) {
            this.optionsBuilder.addAll(options);
            return this;
        }

        public VmConfig build() {
            return new VmConfig(this);
        }
    }
}

