/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ThreadFactory;

final class WorkerProcess
extends Process {
    private static final ThreadFactory shutdownHookThreadFactory = new ThreadFactoryBuilder().setNameFormat("worker-shutdown-hook-%d").build();
    private static final ShutdownHookRegistrar runtimeRegistrar = new ShutdownHookRegistrar(){

        @Override
        public boolean removeShutdownHook(Thread hook) {
            return Runtime.getRuntime().removeShutdownHook(hook);
        }

        @Override
        public void addShutdownHook(Thread hook) {
            Runtime.getRuntime().addShutdownHook(hook);
        }
    };
    private final ShutdownHookRegistrar shutdownHookRegistrar;
    private final Process delegate;
    private final Thread shutdownHook;

    WorkerProcess(ProcessBuilder processBuilder) throws IOException {
        this(runtimeRegistrar, processBuilder.start());
    }

    @VisibleForTesting
    WorkerProcess(ShutdownHookRegistrar shutdownHookRegistrar, Process process) {
        this.shutdownHookRegistrar = shutdownHookRegistrar;
        this.delegate = process;
        this.shutdownHook = shutdownHookThreadFactory.newThread(new ProcessDestroyer(this.delegate));
        shutdownHookRegistrar.addShutdownHook(this.shutdownHook);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.delegate.getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.delegate.getInputStream();
    }

    @Override
    public InputStream getErrorStream() {
        return this.delegate.getErrorStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        int waitFor = this.delegate.waitFor();
        this.shutdownHookRegistrar.removeShutdownHook(this.shutdownHook);
        return waitFor;
    }

    @Override
    public int exitValue() {
        int exitValue = this.delegate.exitValue();
        this.shutdownHookRegistrar.removeShutdownHook(this.shutdownHook);
        return exitValue;
    }

    @Override
    public void destroy() {
        this.delegate.destroy();
        this.shutdownHookRegistrar.removeShutdownHook(this.shutdownHook);
    }

    private static final class ProcessDestroyer
    implements Runnable {
        final Process process;

        ProcessDestroyer(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            this.process.destroy();
        }
    }

    @VisibleForTesting
    static interface ShutdownHookRegistrar {
        public void addShutdownHook(Thread var1);

        public boolean removeShutdownHook(Thread var1);
    }
}

