/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation.common.com.google.common.base;

import com.google.monitoring.runtime.instrumentation.common.com.google.common.annotations.GwtCompatible;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.annotations.VisibleForTesting;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.base.CharMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
public enum CaseFormat {
    LOWER_HYPHEN(CharMatcher.is('-'), "-"),
    LOWER_UNDERSCORE(CharMatcher.is('_'), "_"),
    LOWER_CAMEL(CharMatcher.inRange('A', 'Z'), ""),
    UPPER_CAMEL(CharMatcher.inRange('A', 'Z'), ""),
    UPPER_UNDERSCORE(CharMatcher.is('_'), "_");

    private final CharMatcher wordBoundary;
    private final String wordSeparator;

    private CaseFormat(CharMatcher wordBoundary, String wordSeparator) {
        this.wordBoundary = wordBoundary;
        this.wordSeparator = wordSeparator;
    }

    public String to(CaseFormat format, String s) {
        if (format == null) {
            throw new NullPointerException();
        }
        if (s == null) {
            throw new NullPointerException();
        }
        if (format == this) {
            return s;
        }
        switch (this) {
            case LOWER_HYPHEN: {
                switch (format) {
                    case LOWER_UNDERSCORE: {
                        return s.replace('-', '_');
                    }
                    case UPPER_UNDERSCORE: {
                        return CaseFormat.toUpperCaseAscii(s.replace('-', '_'));
                    }
                }
                break;
            }
            case LOWER_UNDERSCORE: {
                switch (format) {
                    case LOWER_HYPHEN: {
                        return s.replace('_', '-');
                    }
                    case UPPER_UNDERSCORE: {
                        return CaseFormat.toUpperCaseAscii(s);
                    }
                }
                break;
            }
            case UPPER_UNDERSCORE: {
                switch (format) {
                    case LOWER_HYPHEN: {
                        return CaseFormat.toLowerCaseAscii(s.replace('_', '-'));
                    }
                    case LOWER_UNDERSCORE: {
                        return CaseFormat.toLowerCaseAscii(s);
                    }
                }
            }
        }
        StringBuilder out = null;
        int i = 0;
        int j = -1;
        while (true) {
            ++j;
            if ((j = this.wordBoundary.indexIn(s, j)) == -1) break;
            if (i == 0) {
                out = new StringBuilder(s.length() + 4 * this.wordSeparator.length());
                out.append(format.normalizeFirstWord(s.substring(i, j)));
            } else {
                out.append(format.normalizeWord(s.substring(i, j)));
            }
            out.append(format.wordSeparator);
            i = j + this.wordSeparator.length();
        }
        if (i == 0) {
            return format.normalizeFirstWord(s);
        }
        out.append(format.normalizeWord(s.substring(i)));
        return out.toString();
    }

    private String normalizeFirstWord(String word) {
        switch (this) {
            case LOWER_CAMEL: {
                return CaseFormat.toLowerCaseAscii(word);
            }
        }
        return this.normalizeWord(word);
    }

    private String normalizeWord(String word) {
        switch (this) {
            case LOWER_HYPHEN: {
                return CaseFormat.toLowerCaseAscii(word);
            }
            case LOWER_UNDERSCORE: {
                return CaseFormat.toLowerCaseAscii(word);
            }
            case LOWER_CAMEL: {
                return CaseFormat.firstCharOnlyToUpper(word);
            }
            case UPPER_CAMEL: {
                return CaseFormat.firstCharOnlyToUpper(word);
            }
            case UPPER_UNDERSCORE: {
                return CaseFormat.toUpperCaseAscii(word);
            }
        }
        throw new RuntimeException("unknown case: " + (Object)((Object)this));
    }

    private static String firstCharOnlyToUpper(String word) {
        int length = word.length();
        if (length == 0) {
            return word;
        }
        return new StringBuilder(length).append(CaseFormat.charToUpperCaseAscii(word.charAt(0))).append(CaseFormat.toLowerCaseAscii(word.substring(1))).toString();
    }

    @VisibleForTesting
    static String toUpperCaseAscii(String string) {
        int length = string.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(CaseFormat.charToUpperCaseAscii(string.charAt(i)));
        }
        return builder.toString();
    }

    @VisibleForTesting
    static String toLowerCaseAscii(String string) {
        int length = string.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            builder.append(CaseFormat.charToLowerCaseAscii(string.charAt(i)));
        }
        return builder.toString();
    }

    private static char charToUpperCaseAscii(char c) {
        return CaseFormat.isLowerCase(c) ? (char)(c & 0x5F) : c;
    }

    private static char charToLowerCaseAscii(char c) {
        return CaseFormat.isUpperCase(c) ? (char)(c ^ 0x20) : c;
    }

    private static boolean isLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }
}

