/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation.common.com.google.common.collect;

import com.google.monitoring.runtime.instrumentation.common.com.google.common.annotations.GwtCompatible;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.annotations.GwtIncompatible;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.base.Equivalence;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.base.Function;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.base.Objects;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.base.Preconditions;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.ComputingConcurrentHashMap;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.CustomConcurrentHashMap;
import com.google.monitoring.runtime.instrumentation.common.com.google.common.collect.ForwardingConcurrentMap;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public final class MapMaker {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private static final int DEFAULT_EXPIRATION_NANOS = 0;
    private static final int UNSET_INITIAL_CAPACITY = -1;
    private static final int UNSET_CONCURRENCY_LEVEL = -1;
    static final int UNSET_EXPIRATION_NANOS = -1;
    static final int UNSET_MAXIMUM_SIZE = -1;
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    int maximumSize = -1;
    CustomConcurrentHashMap.Strength keyStrength;
    CustomConcurrentHashMap.Strength valueStrength;
    long expirationNanos = -1L;
    private boolean useCustomMap;
    Equivalence<Object> keyEquivalence;
    Equivalence<Object> valueEquivalence;

    MapMaker privateKeyEquivalence(Equivalence<Object> equivalence) {
        Preconditions.checkState(this.keyEquivalence == null, "key equivalence was already set to " + this.keyEquivalence);
        this.keyEquivalence = Preconditions.checkNotNull(equivalence);
        this.useCustomMap = true;
        return this;
    }

    Equivalence<Object> getKeyEquivalence() {
        return Objects.firstNonNull(this.keyEquivalence, this.getKeyStrength().defaultEquivalence());
    }

    MapMaker privateValueEquivalence(Equivalence<Object> equivalence) {
        Preconditions.checkState(this.valueEquivalence == null, "value equivalence was already set to " + this.valueEquivalence);
        this.valueEquivalence = Preconditions.checkNotNull(equivalence);
        this.useCustomMap = true;
        return this;
    }

    Equivalence<Object> getValueEquivalence() {
        return Objects.firstNonNull(this.valueEquivalence, this.getValueStrength().defaultEquivalence());
    }

    public MapMaker initialCapacity(int initialCapacity) {
        Preconditions.checkState(this.initialCapacity == -1, "initial capacity was already set to " + this.initialCapacity);
        Preconditions.checkArgument(initialCapacity >= 0);
        this.initialCapacity = initialCapacity;
        return this;
    }

    int getInitialCapacity() {
        return this.initialCapacity == -1 ? 16 : this.initialCapacity;
    }

    MapMaker maximumSize(int size) {
        Preconditions.checkState(this.maximumSize == -1, "maximum size was already set to " + this.maximumSize);
        Preconditions.checkArgument(this.initialCapacity >= 0);
        this.maximumSize = size;
        this.useCustomMap = true;
        return this;
    }

    @GwtIncompatible(value="java.util.concurrent.ConcurrentHashMap concurrencyLevel")
    public MapMaker concurrencyLevel(int concurrencyLevel) {
        Preconditions.checkState(this.concurrencyLevel == -1, "concurrency level was already set to " + this.concurrencyLevel);
        Preconditions.checkArgument(concurrencyLevel > 0);
        this.concurrencyLevel = concurrencyLevel;
        return this;
    }

    int getConcurrencyLevel() {
        return this.concurrencyLevel == -1 ? 16 : this.concurrencyLevel;
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public MapMaker weakKeys() {
        return this.setKeyStrength(CustomConcurrentHashMap.Strength.WEAK);
    }

    @GwtIncompatible(value="java.lang.ref.SoftReference")
    public MapMaker softKeys() {
        return this.setKeyStrength(CustomConcurrentHashMap.Strength.SOFT);
    }

    MapMaker setKeyStrength(CustomConcurrentHashMap.Strength strength) {
        Preconditions.checkState(this.keyStrength == null, "Key strength was already set to " + (Object)((Object)this.keyStrength) + ".");
        this.keyStrength = Preconditions.checkNotNull(strength);
        if (strength != CustomConcurrentHashMap.Strength.STRONG) {
            this.useCustomMap = true;
        }
        return this;
    }

    CustomConcurrentHashMap.Strength getKeyStrength() {
        return Objects.firstNonNull(this.keyStrength, CustomConcurrentHashMap.Strength.STRONG);
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public MapMaker weakValues() {
        return this.setValueStrength(CustomConcurrentHashMap.Strength.WEAK);
    }

    @GwtIncompatible(value="java.lang.ref.SoftReference")
    public MapMaker softValues() {
        return this.setValueStrength(CustomConcurrentHashMap.Strength.SOFT);
    }

    MapMaker setValueStrength(CustomConcurrentHashMap.Strength strength) {
        Preconditions.checkState(this.valueStrength == null, "Value strength was already set to " + (Object)((Object)this.valueStrength) + ".");
        this.valueStrength = Preconditions.checkNotNull(strength);
        if (strength != CustomConcurrentHashMap.Strength.STRONG) {
            this.useCustomMap = true;
        }
        return this;
    }

    CustomConcurrentHashMap.Strength getValueStrength() {
        return Objects.firstNonNull(this.valueStrength, CustomConcurrentHashMap.Strength.STRONG);
    }

    public MapMaker expiration(long duration, TimeUnit unit) {
        Preconditions.checkState(this.expirationNanos == -1L, "expiration time of " + this.expirationNanos + " ns was already set");
        Preconditions.checkArgument(duration > 0L, "invalid duration: " + duration);
        this.expirationNanos = unit.toNanos(duration);
        this.useCustomMap = true;
        return this;
    }

    long getExpirationNanos() {
        return this.expirationNanos == -1L ? 0L : this.expirationNanos;
    }

    public <K, V> ConcurrentMap<K, V> makeMap() {
        return this.useCustomMap ? new CustomConcurrentHashMap(this) : new ConcurrentHashMap(this.getInitialCapacity(), 0.75f, this.getConcurrencyLevel());
    }

    <K, V> Cache<K, V> makeCache(Function<? super K, ? extends V> computingFunction) {
        return new ComputingConcurrentHashMap<K, V>(this, computingFunction);
    }

    public <K, V> ConcurrentMap<K, V> makeComputingMap(Function<? super K, ? extends V> computingFunction) {
        Cache<? super K, ? extends V> cache = this.makeCache(computingFunction);
        return new ComputingMapAdapter<K, V>(cache);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComputingMapAdapter<K, V>
    extends ForwardingConcurrentMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 0L;
        final Cache<K, V> cache;

        ComputingMapAdapter(Cache<K, V> cache) {
            this.cache = cache;
        }

        @Override
        protected ConcurrentMap<K, V> delegate() {
            return this.cache.asMap();
        }

        @Override
        public V get(Object key) {
            return (V)this.cache.apply(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Cache<K, V>
    extends Function<K, V> {
        public ConcurrentMap<K, V> asMap();
    }
}

