@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')

{{--    selectize--}}
{{--    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.min.css" />--}}
{{--    <script src="https://cdn.bootcss.com/jquery/3.3.1/jquery.min.js"></script>--}}
{{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>--}}


{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
{{--    <script src="https://unpkg.com/tableexport.jquery.plugin/tableExport.min.js"></script>--}}
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--switch--}}
{{--<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta2/dist/js/bootstrap.bundle.min.js" integrity="sha384-b5kHyXgcpbZJO/tY9Ul7kGkf1S0CWuKcCD38l8YkeH8z8QjE0GmW1gYU5S9FOnJ0" crossorigin="anonymous"></script>--}}
<script src="/js/bootstrap.bundle.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
{{--<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/js/tempusdominus-bootstrap-4.min.js"></script>--}}
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
{{--<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.1/css/tempusdominus-bootstrap-4.min.css" />--}}
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
{{--<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">--}}
<link href="/css/font-awesome.min.css" rel="stylesheet">
{{--switch--}}
<link rel="stylesheet" href="/css/bootstrap-5.min.css" />
{{--<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0-beta2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-BmbxuPwQa2lc/FVzBcNJ7UAyJxM6wuqIj61tLrc4wSX0szH/Ev+nYRRuWlolflfl" crossorigin="anonymous">--}}

    {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            /*width: 30%;*/
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }
        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }
        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }
        .exampleSearch {
            width: 300px;
            height: 500px;
            margin: 0 auto;
            display: block;
            margin-top: 300px;
        }
</style>
@endsection


@section('body')
@endsection
@section('content')
    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '1'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-10" style="background:#e0e6ec">
                {{--保留區域(最上面的空白部分)--}}
                <div style="height: 5vh;width: 100%"></div>
                {{--操作、呈現資料--}}
                <div id="Screens" style="height: 95vh;width: 100%">
                    {{--操作列--}}
                    <div class="row" style="height: 10vh;align-items: center">
                        <div class="col-6" style="padding-right: 0px;">
                            <form method="POST" action="{{ route('person_search_type') }}">
                            {{ csrf_field() }}
                            <div class="input-group">
                                <select name="search_type" class="custom-select" id="inputGroupSelect04">
                                    <option value="default" selected>請選擇類別</option>
                                    <option value="1">ID</option>
                                    <option value="2">姓名</option>
                                    <option value="3">類別</option>
                                </select>
                                <input name="search_text" type="text" class="form-control" placeholder="欲搜尋內容" >
                                <div class="input-group-append">
                                    <button class="btn btn-dark" type="submit">搜尋</button>
                                </div>
                            </div>
                            </form>
                        </div>
                        <div class="col-6 float-right">
                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;"  data-toggle="modal" data-target="#InsertFiles">批量匯入</button>
                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;"  data-toggle="modal" onclick="location.href='{{ route("excel_example") }}'">批量匯入範例</button>
                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" onclick="post_delete_face()">批量刪除</button>
                            <button class="btn btn-outline-dark float-right" style="margin-right: 10px;" data-toggle="modal" data-target="#InsertMemberModalCenter">新增人員</button>
                        </div>
                    </div>
                    {{--表格呈現-現有人員資訊--}}
                    <table class="table table-striped table-bordered table-hover " id="tableL01" style="height: 75vh"></table>
                    {{--底端部分(無資料)--}}
                    <div class="row" style="margin-top: 10px;margin-right: 0px;margin-left: 0px;">
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{--彈窗區--}}
    {{-- 新增人臉彈出視窗 --}}
    <div class="modal fade" id="InsertMemberModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">新增人員</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("post_insert_face") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-8">
                            <div class="form-group row">
                                <label for="inputName" class="col-3 col-form-label">姓名</label>
                                <div class="col-9">
                                    <input type="text" class="form-control" id="inputName" name="face_name" placeholder="請輸入姓名">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="inputID" class="col-3 col-form-label">ID</label>
                                <div class="col-9">
                                    <input type="text" class="form-control" id="inputID" name="face_id" placeholder="請輸入使用者編號">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-3 col-form-label" for="selectSex" >性別</label>
                                <div class="col-9">
                                    <select class="custom-select form-control" id="selectSex" name="face_sex">
                                        <option disabled selected>請選擇性別</option>
                                        <option value="1">男</option>
                                        <option value="2">女</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-3 col-form-label" for="selectGroup">群組</label>
                                <div class="col-9">
                                    <select class="custom-select form-control" id="selectGroup" name="face_group">
                                        <option selected disabled >請選擇人員群組</option>
                                        @foreach($person_groups as $person_group)
                                            <Option value="{{ $person_group["id"] }}">{{ $person_group["name"] }}</Option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-4 form-group">
                            <img id="face-img-preview" class="img-fluid" src="{{ asset("/upload_face_diagram.svg") }}" >
                            <input id="face-img-input" class="form-control" type="file" name="face_img" accept=".jpg">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- 修改人臉彈出視窗 --}}
    <div class="modal fade" id="ModifyMemberModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">修改人員資料</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("modify_person") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-8">
                            <div class="form-group row">
                                <label for="inputName" class="col-sm-3 col-form-label">姓名</label>
                                <div class="col-9">
                                    <input type="text" class="form-control" id="modifyName" name="modify_face_name" placeholder="請輸入姓名">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="inputID" class="col-3 col-form-label">ID</label>
                                <div class="col-9">
                                    <input type="text" class="form-control" id="modifyID" name="modify_face_id" placeholder="請輸入使用者編號" readonly>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-3 col-form-label" for="selectSex" >性別</label>
                                <div class="col-9">
                                    <select class="custom-select form-control" id="modifyselectSex" name="modify_face_sex">
                                        <option disabled selected>請選擇性別</option>
                                        <option value="1">男</option>
                                        <option value="2">女</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="inputID" class="col-sm-3 col-form-label">狀態</label>
                                <div class="col-9">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="EnabledChecked" value="1" name="deleted">
                                        <label class="form-check-label" for="EnabledChecked" id="EnabledLable">啟用</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-4 form-group">
                            <img id="modify-face-img-preview" class="img-fluid" src="{{ asset("/upload_face_diagram.svg") }}" >
                            <input id="modify-face-img-input" class="form-control" type="file" name="modify_face_img" accept=".jpg">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{--匯入檔案--}}
    <div class="modal fade" id="InsertFiles" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">新增人員檔案</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("files") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-8">
                            <input type="file" id="file" name="excel" accept=".xls,.xlsx">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{--方法區--}}
    <script>
        // 修改人員資料處理
        function person_modify(obj) {
            let jdata_index=parseInt(obj.closest('tr').getAttribute("data-index"));
            document.getElementById("EnabledChecked").checked=jdata[jdata_index].enabled;
            document.getElementById("modifyName").value=jdata[jdata_index].name;
            document.getElementById("modifyID").value=jdata[jdata_index].id;
            document.getElementById("modifyID").value=jdata[jdata_index].id;
            document.getElementById("modifyselectSex").value=jdata[jdata_index].sex;
            document.getElementById("modifyLineToken").value=jdata[jdata_index].token;
            document.getElementById("modify-face-img-preview").src=htmlToElement(jdata[jdata_index].img).getAttribute("src");
            var type="0";
            switch(jdata[jdata_index].group){
                case("黑名單"):
                    type = "1";
                    break;
                case("白名單"):
                    type="2";
                    break;
                case("VIP"):
                    type="3";
                    break;
                default:
                    break;
            }
            document.getElementById("modifyselectGroup").value=type;
            if (jdata[jdata_index].start===null || jdata[jdata_index].end===null){
                document.getElementById("modifyselectExpiryDate").value="1";
                $("#modify-start-time").removeAttr("required");
                $("#modify-end-time").removeAttr("required");
            }else{
                document.getElementById("modifyselectExpiryDate").value="2";
                $('#datetimepicker3').datetimepicker({date:new Date(jdata[jdata_index].start)});
                $('#datetimepicker4').datetimepicker({date:new Date(jdata[jdata_index].end)});
                $("#modify-start-time").attr("required","true");
                $("#modify-end-time").attr("required","true");
            }

        }
        // html string to element
        function htmlToElement(html) {
            var template = document.createElement('template');
            html = html.trim(); // Never return a text node of whitespace as the result
            template.innerHTML = html;
            return template.content.firstChild;
        }
        //刪除人臉
        //取得已選取目標
        function getIdSelections() {
            return $.map($('#tableL01').bootstrapTable('getSelections'), function (row) {
                return row.id
            })
        }
        function post_delete_face() {
            let idselections=getIdSelections();
            if(confirm("是否刪除"+idselections)){
                var form = document.createElement("form");
                form.setAttribute("method","post");
                form.setAttribute("action","{{ Route("post_delete_face") }}");
                var idselectionsField = document.createElement("input");
                idselectionsField.setAttribute("type", "hidden");
                idselectionsField.setAttribute("name", "selectedId");
                idselectionsField.setAttribute("value",idselections);
                form.appendChild(idselectionsField);
                var csrfField=document.createElement("input");
                csrfField.setAttribute("type", "hidden");
                csrfField.setAttribute("name", "_token");
                csrfField.setAttribute("value", "{{ csrf_token() }}");
                form.appendChild(csrfField);
                document.body.appendChild(form);    // Not entirely sure if this is necessary
                form.submit();
            }
        }
        //新增人員-人臉圖片預覽
        var inputface=document.getElementById("face-img-input");
        var previewface=document.getElementById("face-img-preview");
        inputface.addEventListener('change',function () {
            var file =this.files[0];
            var reader=new FileReader();
            // 可接受的附檔名
            var validExts = new Array(".jpg");
            var fileExt = file.name.substring(file.name.lastIndexOf('.'));
            reader.addEventListener('load',function () {
                if (validExts.indexOf(fileExt) < 0) {
                    alert("檔案類型錯誤，可接受的副檔名有：" + validExts.toString());
                    return false;
                }else{
                    previewface.src=reader.result;
                }
            },false);
            reader.readAsDataURL(file);
        },false);
        var modifyface=document.getElementById("modify-face-img-input");
        var modifypreviewface=document.getElementById("modify-face-img-preview");
        modifyface.addEventListener('change',function () {
            var file =this.files[0];
            var reader=new FileReader();
            // 可接受的附檔名
            var validExts = new Array(".jpg");
            var fileExt = file.name.substring(file.name.lastIndexOf('.'));
            reader.addEventListener('load',function () {
                if (validExts.indexOf(fileExt) < 0) {
                    alert("檔案類型錯誤，可接受的副檔名有：" + validExts.toString());
                    return false;
                }else{
                    modifypreviewface.src=reader.result;
                }
            },false);
            reader.readAsDataURL(file);
        },false);
        // 下拉選單預設值回調
        $('#inputGroupSelect04').val("{{ old("search_type","default") }}");
    </script>
    {{--跳出錯誤訊息--}}
    @if(isset($error_msg))
        <script>
            alert('{{ $error_msg }}');
        </script>
    @endif
    {{--表格設定(boostrap-tabel)--}}
    <script>
        // 載入資料
        @php
            if(isset($rowdata)){
                echo "var jdata=".json_encode($rowdata).";";
            }else{
                echo "var jadata=[];";
            }
        @endphp
        //動態載入表格之前，先銷燬表格
        $('#tableL01').bootstrapTable('destroy');
        //設定欄位標題
        var tableColumns = [
            {field: 'state', checkbox: true,},
            {field: 'img',title: '在庫人臉', sortable: false},
            {field: 'id', title: '人員編號', sortable: true},
            {field: 'group', title: '群組', sortable: true},
            {field: 'name', title: '姓名', sortable: true},
            {field: 'allow_camera', title: '允許之攝影機', sortable: false}
            ,{field: 'enabled', title: '在職', sortable: true,width:"80",align:'center'},
            {field: 'modify', title: '', sortable: false},
        ];
        //設定表格
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0,
            height:1,
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'day', // 預設排序
        });
    </script>
@endsection
