@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
    {{--selectize--}}
    {{--    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.min.css" />--}}
    <link rel="stylesheet" href="/css/selectize.min.css" />
    {{--    <script src="https://cdn.bootcss.com/jquery/3.3.1/jquery.min.js"></script>--}}
    {{--已經有在default引入了--}}
    {{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js"></script>--}}
    <script src="/js/selectize.min.js"></script>

{{--    引入bootstrap-table css樣式與js--}}
    <link href="/css/bootstrap-table.css" rel="stylesheet">
    <script src="/js/tableExport.min.js"></script>
    <script src="/js/bootstrap-table.js"></script>
    <script src="/js/bootstrap-table-zh-TW.min.js"></script>
    <script src="/js/bootstrap-table-export.min.js"></script>
{{--引入 datetimepicker 相關套件--}}
<script type="text/javascript" src="/bower_components/moment/moment.js"></script>
<script type="text/javascript" src="/bower_components/moment/locale/zh-tw.js"></script>
<script type="text/javascript" src="/js/tempusdominus-bootstrap-4.min.js"></script>
<link rel="stylesheet" href="/css/tempusdominus-bootstrap-4.min.css" />
<link href="/css/font-awesome.min.css" rel="stylesheet">

       {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            width: 50px;
            align-self:center ;
            margin-left: 2%;
        }
        input.checkbox{
            display: block;
            width: 100%;
            height: 20px;
        }
        /*datetimepicker 字體修正字體修正*/
        .datepicker {
            font-size: 18px;
        }
    /* 複寫 fixed-height 已修改固定data高度*/
        .fixed-height{
            height: 75vh !important;
        }
        .table-condensed{
            font-size: 15px;
        }
</style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{--左邊功能選單--}}
            <div class="collapse p-4 col-2 show"  id="navbarToggleExternalContent" style="background: #0271a0">
                {{--引入功能選單--}}
                @include('contents', ['this_page' => '4'])
            </div>
            {{--右邊主畫面區--}}
            <div id="Screen-aria" class="col-10" style="background:#e0e6ec">
                {{--保留區域(最上面的空白部分)--}}
                <div style="height: 5vh;width: 100%"></div>
                {{--操作、呈現資料--}}
                <div id="Screens" style="height: 95vh;width: 100%">
                    {{--操作列--}}
                    <form class="row" method="post" action="{{ Route('comparison') }}">
                        {{ csrf_field() }}
                        <div class="col-3">
                            <div class="input-group">
                                <select name="search_type" class="custom-select" id="inputGroupSelect04" onchange="select()">
                                    <option value="default">請選擇類別</option>
                                    <option value="all">全部</option>
                                    <option value="black">黑名單</option>
                                    <option value="unknow">訪客</option>
                                    <option value="overtemp">溫度異常</option>
                                </select>
                                <input id="search_text" name="search_text" type="text" class="form-control" placeholder="" min="0" step="0.1"value="{{ old("search_text") }}">
                                <input id="search_number" style="display: none" name="search_number" type="number" class="form-control" placeholder="" min="0" step="0.1"value="{{ old("search_text") }}">
                            </div>
                        </div>
                        {{--datetime 起始時間選擇--}}
                        <div class="col-4">
                            <div class="input-group date" id="datetimepicker1" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">起始時間</div>
                                </div>
                                <input style="text-align: center" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required/>
                                <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        {{--datetime 結束時間選擇--}}
                        <div class="col-4">
                            <div class="input-group date" id="datetimepicker2" data-target-input="nearest">
                                <div class="input-group-prepend">
                                    <div class="input-group-text">結束時間</div>
                                </div>
                                <input style="text-align: center" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required/>
                                <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                    <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-1">
                            <button type="submit" class="btn btn-dark mb-2">查詢</button>
                        </div>
                    </form>
                    <div style="height: 2vh"></div>
                    {{--表格呈現-打卡資料--}}
                    <table class="table table-striped table-bordered table-hover table-condensed" id="tableL01"  style="height: 75vh"></table>
                    {{--底端部分(管理者、系統管理者才有)--}}
                    <div class="row" style="margin-top: 10px;margin-right: 0px;margin-left: 0px;">
                        @if($level=="3" or $level=="4")
                            <button class="btn btn-outline-dark" style="margin-right: 10px;"  title="補登打卡" data-toggle="modal" data-target="#punchcard_insert" >補登打卡</button>&nbsp;
                            <button class="btn btn-outline-dark" style="margin-right: 10px;" data-toggle="modal" data-target="#person_attendance">人員出席</button>
                            <button class="btn btn-outline-dark" style="margin-right: 10px;"  data-toggle="modal" data-target="#InsertPunchCardExcel">匯入打卡</button>
                        @endif
                    </div>

                </div>
            </div>
        </div>
    </div>
    {{--彈窗區--}}
    {{--匯入打卡檔案彈窗--}}
    <div class="modal fade" id="InsertPunchCardExcel" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">匯入打卡</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("punch_card_insert_excel") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                    <div class="modal-body row">
                        <div class="col-8">
                            <input type="file" id="file" name="excel" accept=".xls,.xlsx">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                        <button type="submit" class="btn btn-primary">提交</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- 顯示未出席彈出視窗 --}}
    <div class="modal fade" id="person_attendance" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true" style="overflow:visible;" >
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content" style="height: 600px">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">人員出席</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                {{ csrf_field() }}
                <div class="modal-body row">
                    <div class="col-12" style="height: 40vh; overflow: auto">
                        <table class="table table-striped table-bordered table-hover table-condensed" style="height: 30vh" id="tableL02"></table>
                    </div>
                </div>
                <div class="modal-footer" >
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">關閉</button>
                </div>
            </div>
        </div>
        <div>
        </div>
    </div>
    {{--補登打卡彈出視窗--}}
    <div class="modal fade" id="punchcard_insert" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">補登人員打卡</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("post_punch_card") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                <div class="modal-body row">
                    <div class="col-12">
                        <div class="form-group row">
                            <label style="text-align: right;" class="col-3 col-form-label" for="user" >使用者</label>
                            <div class="col-6">
                                @if($person_name=="admin")
                                    <input  id='user' name="user" style="text-align: center"  type="text" class="form-control" value={{$person_name}}>
                                @else
                                    <input readonly id='user' name="user" style="text-align: center"  type="text" class="form-control" value={{$person_name}}>
                                @endif
                            </div>
                        </div>
                        <div class="form-group row">
                            <label style="text-align: right;" class="col-3 col-form-label" for="person" >打卡人員</label>
                            <div class="col-6">
                                <select style="text-align: center"  placeholder="請選擇姓名" id="person_choose" name="person" required>
                                    <option value=""></option>
                                    @foreach($persons as $person)
                                        <Option value="{{ $person["id"] }}">{{ $person["name"] }}</Option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label style="text-align: right;" class="col-3 col-form-label" for="temperature" >溫度</label>
                            <div class="col-6">
                                <input id='temperature' name="temperature" style="text-align: center"  type="number" class="form-control" value="36" step="0.1">
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="input-group date" id="datetimepicker3" data-target-input="nearest">
                                <label style="text-align: right;" class="col-3 col-form-label" for="time" >打卡時間</label>
                                <div class="col-6">
                                    <input id='time' style="text-align: center" name="time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker3" required/>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                    <button type="submit" class="btn btn-primary">提交</button>
                </div>
                </form>
            </div>
        </div>
    </div>
    {{-- 新增人臉彈出視窗 --}}
    <div class="modal fade" id="InsertMemberModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLongTitle">新增人員</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{ route("post_insert_face_no_image") }}" method="POST" enctype="multipart/form-data">
                    {{ csrf_field() }}
                <div class="modal-body row">
                    <div class="col-8">
                        <div class="form-group row">
                            <label for="inputName" class="col-3 col-form-label">姓名</label>
                            <div class="col-9">
                                @if(count($person_noimage)!=0)
                                    <div>
                                        <select name="face_name" placeholder="請選擇姓名" id="insert_person_select" onchange="select_person()">
                                            <option value=""></option>
                                        @foreach($person_noimage as $person)
                                                <option value="{{$person["id"]}}/{{$person["sex"]}}/{{$person["name"]}}">{{$person["name"]}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <input type="hidden" name="personname" id="personname" >
                                    {{--<input type="text" name="personname" id="personname" value="{{$person["sex"]}}">--}}

                                @else
                                    <input type="text" class="form-control" id="inputName" name="personname" placeholder="請輸入姓名">
                                @endif
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="inputID" class="col-3 col-form-label">ID</label>
                            <div class="col-9">
                                <input type="text" class="form-control" id="inputID" name="face_id" placeholder="請輸入使用者編號">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-3 col-form-label" for="selectSex" >性別</label>
                            <div class="col-9">
                                <select class="custom-select form-control" id="selectSex" name="face_sex">
                                    <option disabled selected>請選擇性別</option>
                                    <option value="1">男</option>
                                    <option value="2">女</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-4 form-group">
                        <img id="face-img-preview" class="img-fluid" src="{{ asset("/boss.jpg") }}" >
                        <input id="face-img-input" class="form-control" name="face_img" readonly />
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                    <button type="submit" class="btn btn-primary">提交</button>
                </div>
                </form>
            </div>
        </div>
    </div>
    {{--方法區--}}
    {{--搜尋選擇類別方法--}}
    <script>
        function select()
        {
            var select =document.getElementById("inputGroupSelect04").value;
            var n =document.getElementById("search_number");
            var t =document.getElementById("search_text");
            if(select=="overtemp")
            {
                n.style.display="block";
                t.style.display="none"
                document.getElementById("search_number").value = 37.5;
            }
            else
            {
                t.style.display="block";
                n.style.display="none";
                document.getElementById("search_text").value = "";
                document.getElementById("search_number").value = "";
            }
        }
    </script>
    {{--新稱人員(選擇有資料無照片的人之後帶資料)方法--}}
    <script language="JavaScript">
        function select_person() {
            var select =document.getElementById("insert_person_select").value;
            var a=select.split("/");
        if(a.length > 1){
            document.getElementById("inputID").value=a[0];
            document.getElementById("selectSex").value=a[1];
            document.getElementById("personname").value=$("#insert_person_select").text();
        } else {
            document.getElementById("inputID").value="";
            document.getElementById("selectSex").value="";
            document.getElementById("personname").value=$("#insert_person_select").text();
            }
        }
    </script>
    {{--新增人員-入照片--}}
    <script>
        function insert_user(id) {
            var image = document.getElementById("face-img-preview");
            image.src = "/get/image?img_path=/punch/card/image/%s".replace(/%s/g, () => id);
            var label = document.getElementById("face-img-input");
            label.value = id;
        }
    </script>
    {{--下拉式選單-藉由輸入快速選擇(selectize)--}}
    <script>
        //新增人員-選擇已有資料
        $(document).ready(function () {
            $('#insert_person_select').selectize({
                create:true,
                sortField:{
                    field:'text',
                },
            });
        });
        //補登打卡-人員選擇
        $(document).ready(function () {
            $('#person_choose').selectize({
                create:false,
                sortField:{
                    field:'text',
                },
            });
        });
    </script>
    <script>
        // 下拉選單預設值回調
        $('#inputGroupSelect04').val("{{ old("search_type","default") }}");
        // 有效期間選擇響應
        function selectExpiryDateonchange(x) {
            let elemet_selted=document.getElementById(x).value;
            // console.log(elemet_selted);
            switch (elemet_selted) {
                case '1':
                    $("#start_time").removeAttr("required");
                    $("#end_time").removeAttr("required");
                    break;
                case '2':
                    $("#start_time").attr("required","true");
                    $("#end_time").attr("required","true");
                    break;
                default:
                    break;
            }
        }
    </script>
    {{--跳出錯誤訊息    --}}
    @if(isset($error_msg))
        <script>
            alert('{{ $error_msg }}');
        </script>
    @endif

    {{--表格設定(boostrap-tabel)--}}
    {{--打卡資料--}}
    <script>
        //溫度大於37紅色顯示
        function cellColor(value, row, index) {
            if (parseInt(row.temp) >= 37) {
                return {
                    css: {
                        color: 'red'
                    }
                }
            }
            else{
                return {
                    css: {
                        color: 'black'
                    }
                }
            }
        }
        //居家上班藍色顯示
        function cellColor2(value, row, index) {
            if (row.location == "居家上班") {
                return {
                    css: {
                        color: 'blue'
                    }
                }
            }
            else{
                return {
                    css: {
                        color: 'black'
                    }
                }
            }
        }
        //載入資料
        @php
            if (isset($rowdata)){
                echo "var jdata=".json_encode($rowdata).';';
            }else{
                echo "var jdata=[];";
            }
        @endphp
        //動態載入表格之前，先銷燬表格
        $('#tableL01').bootstrapTable('destroy');
        //設定欄位標題
        var tableColumns = [
            {field: 'day', title: '日期', sortable: true},
            {field: 'time', title: '時間', sortable: true},
            {field: 'db_img', title: '在庫圖片', sortable: false},
            {field: 'target_img', title: '抓拍圖片', sortable: false},
            {field: 'name', title: '姓名', sortable: true},
            {field: 'group', title: '名單類別', sortable: true},
            {field: 'temp', title: '溫度', sortable: true,cellStyle :cellColor},
            {field: 'location', title: '地點', sortable: true,cellStyle :cellColor2},
            {field: 'remarks', title: '備註', sortable: false},
            {field: 'unknown', title: 'Create', sortable: false},
        ];
        //設定表格
        $('#tableL01').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0,
            height:1,
            method: 'get',
            pageSize: 5, //每頁3條
            pageNumber: 1,  //第1頁
            pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: false,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'day', // 預設排序
        });
    </script>
    {{--人員出席--}}
    <script>
        //載入資料
        @php
            if(isset($rowdata2)){
                echo "var jdata=".json_encode($rowdata2).";";
            }else{
                echo "var jadata=[];";
            }
        @endphp
        //動態載入表格之前，先銷燬表格
        $('#tableL02').bootstrapTable('destroy');
        //設定欄位標題
        var tableColumns = [
            {field: 'person_id', title: '人員編號', sortable: true},
            {field: 'person_name', title: '人員名稱', sortable: true},
            {field: 'attendance', title: '狀態', sortable: true},
        ];
        //設定表格
        $('#tableL02').bootstrapTable({//表格初始化
            locale:"zh-TW",// 地區語系轉換
            columns: tableColumns,  //表頭
            data:jdata, //通過ajax返回的資料
            width:0,
            // height:0.3*Math.max(document.documentElement.clientHeight, window.innerHeight || 0),
            method: 'get',
            // pageSize: 5, //每頁3條
            // pageNumber: 1,  //第1頁
            // pageList: "[5,10,all]",   //在使用過程中根據情況調整每頁條數.雖然你現在定義的每頁3條，但你可以隨時調整為10條或25條。
            cache: false,   //不快取
            striped: true,
            pagination: false,
            sidePagination: 'client',
            search: true,
            showRefresh: false,
            showExport: false,
            showFooter: false,
            exportTypes: ['csv', 'txt', 'xml','excel'],
            clickToSelect: true,
            sortName:'attendance', // 預設排序
            sortOrder:'desc',
        });
    </script>
    {{--日期選擇設定--}}
    <!-- 起始時間 (datetimepicker1物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker1').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY-MM-DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date:new Date("{{ old('start_time',date("Y-m-d")) }}") // 初始值
            });
        });
    </script>
    <!-- 結束時機 (datetimepicker2物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker2').datetimepicker({
                locale:'zh-tw',
                // format: 'YYYY-MM-DD a hh:mm:ss ',
                format: 'YYYY-MM-DD',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                maxDate:new Date(),
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
                date: new Date("{{ old('end_time',date("Y-m-d")) }}") // 初始化日期
            });
        });
    </script>
    <!-- 補登打卡時間 (datetimepicker3物件) -->
    <script type="text/javascript">
        $(function () {
            $('#datetimepicker3').datetimepicker({
                locale:'zh-tw',
                format: 'YYYY-MM-DD HH:mm:ss',
                weekStart: 1,
                autoclose: 1,
                todayHighlight: 1,
                inline:false,
                allowInputToggle:true,
                sideBySide:false,
                stepping:0,
                minView:0,
                maxView:0,
                startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
            });
        });
    </script>
@endsection
