@extends('layout.default')

@section('title', '攝影機調閱')

@section('header')
    <link href="/css/bootstrap-toggle.min.css" rel="stylesheet">
    <script src="/js/bootstrap-toggle.min.js"></script>

    {{--css 樣式定義--}}
    <style type="text/css">
        /*人臉訊息文字*/
        p.information {
            margin: 0px auto;
            font-size: 8pt;
            text-align: center;
            color: white;
        }
        /*人臉圖片*/
        img.faceimg{
            border:2px #ccc solid;
            width: 30%;
            align-self:center ;
            margin-left: 2%;
        }
    </style>
@endsection


@section('body')
@endsection
@section('content')

    {{--主畫面--}}
    <div>
        <div class="row" style="height: 100vh;margin-left: -0;margin-right: 0px;">
            {{-- 攝影機 選單區--}}
            <div class="collapse p-4 bg-dark col-md-2 show"  id="navbarToggleExternalContent">
                <a href="{{ Route("person") }}" style="text-decoration:none;"><h2 class="text-dark" style="font-size: 20pt;text-align: center;background: white">人員管理</h2></a>
                {{--@include('layout.menubtn')--}}
                <div style="height: 5vh"></div>
                <h2 class="text-white"style="font-size: 20pt;text-align: center">現有設備</h2>
                {{--新增刪除修改按鈕--}}
                <div class="row" style="height: 10vh">
                    <div class="col-4"><button class="btn-light" style="background-color: #f8f9fa6e;border-color: #f8f9fa6e" title="新增攝影機" onclick="javascript:location.href='{{ Route("insert_camera") }}'"><img style="height: 100%;width: 100%" src="{{ asset("icon/create_pen.svg") }}"></button></div>
                    <div class="col-4"><button class="btn-light" title="移除攝影機" onclick="drop_camera()"><img style="height: 100%;width: 100%" src="{{ asset("icon/remove_rubbish-bin.svg") }}"></button></div>
                    <div class="col-4"><button class="btn-light" title="修改攝影機" onclick="javascript:location.href='{{ Route("modify_camera",["id"=>1]) }}'"><img style="height: 100%;width: 100%" src="{{ asset("icon/update_file.svg") }}"></button></div>
                </div>
                <div style="overflow: hidden">
                    <div id="cam_group_menu" style="overflow-y: scroll;height: 60vh;">
                        @if(!empty($camera_list))
                            @foreach($groups as $group)
                                <div class="dropdown-toggle" style="font-size: 18pt;color: white" data-toggle="collapse" href="{{ '#'.$group['group'].'collapse' }}" role="button" aria-expanded="true" aria-controls="{{ $group['group'].'collapse' }}">
                                    <button id="{{ $group['group'].'_btn' }}" style="color:white;background-color:transparent;border: none;">
                                        {{ $group['group'] }}
                                    </button>
                                </div>
                                <div class="collapse" id="{{ $group['group'].'collapse' }}" style="color: white">
                                    <div>
                                        <ul id="{{ $group['group'] }}">
                                            @foreach($camera_list[$group['group']] as $camera)
                                                <li id="{{ $group['group'].$camera["name"] }}">
                                                    <button id="{{ $group['group'].$camera["name"].'_btn' }}" style="color:white;background-color:transparent;border: none;" onclick="javascript:location.href='{{ route('modify_camera',["id"=>$camera['id']]) }}'">
                                                        {{ $camera["name"] }}
                                                    </button>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                </div>
                <form method="GET" action="{{ Route("user_logout") }}">
                    <div class="col-12" style="text-align: center">
                        <input class="btn btn-outline-light" style="font-size:16px;text-align: center" type="submit" id="logout" name="logout" value="登出" >
                    </div>
                </form>
            </div>
            {{--攝影機 畫面區--}}
            <div id="Screen-aria" class="col-md-8" style="background:darkgray">
                {{--頁面選單--}}
                <div id="menu" class="row" style="background: white">
                    <div class="col-4 text-center"><a href="{{ Route("AI") }}" style="text-decoration:none;color: #1b1e21;">即時監控</a></div>
                    <div class="col-4 text-center">人員管理</div>
                    <div class="col-4 text-center">人員查詢</div>
                </div>
                {{--保留區域--}}
                <div style="height: 5vh;width: 100%"></div>
                <div id="Screens" style="height: 80vh;width: 100%;">
                    {{--攝影機資訊區--}}
                    <div id="info" style="height: 100%;width: 100%;" class="row">
                        <div class="col-2"></div>
                        <div class="col-8 rounded" style="border-style: solid;border-color: #761b18;">
                            <div class="table-danger rounded text-center">新增攝影機</div><br>
                            <form method="post" action="{{ Route('insert_person') }}">
                                {{ csrf_field() }}
                                <div class="form-group row">
                                    <div class="col-sm-1"></div>
                                    <label class="col-sm-4 col-form-label text-center">人員編號</label>
                                    <div class="col-sm-6">
                                    <input name="id" type="text" class="form-control" readonly>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-sm-1"></div>
                                    <label class="col-sm-4 col-form-label text-center">人員群組</label>
                                    <div class="col-sm-6">
                                    <input name="group" type="text" class="form-control" required>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-sm-1"></div>
                                    <label class="col-sm-4 col-form-label text-center">名稱</label>
                                    <div class="col-sm-6">
                                    <input name="name" type="text" class="form-control" required>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-sm-1"></div>
                                    <label class="col-sm-4 col-form-label text-center">照片</label>
                                    <div class="col-sm-6">
                                        <input name="img" type="file" class="form-control-file" id="exampleFormControlFile1">
                                    </div>
                                </div>
                                <div class="row form-group">
                                    <div class="col-sm-2"></div>
                                    <div class="col-sm-4">
                                        <button type="submit" class="form-control">送出</button>
                                    </div>
                                    <div class="col-sm-4">
                                        <button class="form-control">取消</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-2"></div>
                    </div>
                </div>
            </div>
            {{--攝影機 辨識結果區--}}
            <div id="face-aria" class="col-md-2" style="height: 100vh;overflow-y: scroll;background-color: black;">
                <ul id="face-box" class="list-unstyled" style="padding-top: 10%">
                    <li class="media bg-dark" style="border: 1px solid #004085;margin-bottom: 5%">
                        <img class="faceimg" src="http://192.168.5.222:8000/result?topic=RD10501&filename=RD10501_2019-12-10%2013:40:45.jpg" id="face1">
                        <div class="media-body">
                            <p class="information">2019-12-20</p>
                            <p class="information">18:03:15</p>
                            <p class="information">姓名：Allen</p>
                            <p class="information">相似度：87%</p>
                        </div>
                    </li>
                    <li class="media bg-dark" style="border: 1px solid #004085;margin-bottom: 5%">
                        <img class="faceimg" src="http://192.168.5.222:8000/result?topic=RD10501&filename=RD10501_2019-12-10%2013:40:45.jpg" id="face1">
                        <div class="media-body">
                            <p class="information">2019-12-20</p>
                            <p class="information">18:03:15</p>
                            <p class="information">姓名：Allen</p>
                            <p class="information">相似度：87%</p>
                        </div>
                    </li>
                </ul>
            </div>
        </div>

    </div>

{{--跳出錯誤訊息    --}}
@if(isset($error_msg))
<script>
    alert('{{ $error_msg }}');
</script>
@endif

{{--刪除按鈕事件處理--}}
<script>
    function drop_camera() {
        var id=document.getElementById("cameraid").value;
        if(confirm("是否刪除"+id)){
            var form = document.createElement("form");
            form.setAttribute("method","post");
            form.setAttribute("action","{{ Route("drop_camera") }}");
            var idField = document.createElement("input");
            idField.setAttribute("type", "hidden");
            idField.setAttribute("name", "id");
            idField.setAttribute("value",id);
            form.appendChild(idField);
            var csrfField=document.createElement("input");
            csrfField.setAttribute("type", "hidden");
            csrfField.setAttribute("name", "_token");
            csrfField.setAttribute("value", "{{ csrf_token() }}");
            form.appendChild(csrfField);
            document.body.appendChild(form);    // Not entirely sure if this is necessary
            form.submit();
        }
    }
</script>
@endsection
