<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Mail;
//use App\Mail\Warning;


class LeaveController extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
     //員工請假的首頁
    public function employeeforleave_index(Request $request)
    {
        $request->session()->all();
        $msg = request()->session()->get('msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $department_no="";
        $level="";
        $person_id="";
        $on_board="";
        $user_id="";
        //權限相關設計
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $department_no=$user["department"];
                $on_board=$user["on_board"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }
        if(in_array ("24" , $user_auth))
        {
            $level="3";
        }

        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }

        $departments= array();
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $department) {
                if($department["no"]==$department_no)
                    $department_name=$department["department"];
                array_push( $departments, array(
                    "no" => $department["no"],
                    "department" => $department["department"],
                ));
            }
        }
        $person_name="";
        $persons=array();
        $annual_leave_hour=0;
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $person){
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }
                if($level=="3"or$level=="4")
                {
                    array_push($persons,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }
                elseif(in_array ("18" , $user_auth))
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                else
                {
                    if($person["ID"]==$person_id)
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
            }
        }

        //標記審核狀態
        $leaves_status=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/leave/signing/status/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $status){
                if($status["signing_status_1"]=="1")
                {
                    if($status["signing_status_2"]=="1")
                    {
                        if($status["signing_status_3"]=="1")
                        {
                            if($status["signing_status_4"]=="1")
                            {
                                array_push($leaves_status,array(
                                    'leave_no'=>$status["leave_off_work_no"],
                                    'status'=>"審核通過",
                                ));
                            }
                            else
                            {
                                array_push($leaves_status,array(
                                    'leave_no'=>$status["leave_off_work_no"],
                                    'status'=>"審核中(4)",
                                ));
                            }
                        }
                        else
                        {
                            array_push($leaves_status,array(
                                'leave_no'=>$status["leave_off_work_no"],
                                'status'=>"審核中(3)",
                            ));
                        }
                    }
                    else
                    {
                        array_push($leaves_status,array(
                            'leave_no'=>$status["leave_off_work_no"],
                            'status'=>"審核中(2)",
                        ));
                    }
                }
                else
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"審核中(1)",
                    ));
                }
                if($status["signing_status_1"]!="1" and $status["signing_status_1"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
                if($status["signing_status_2"]!="1" and $status["signing_status_2"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
                if($status["signing_status_3"]!="1" and $status["signing_status_3"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
                if($status["signing_status_4"]!="1" and $status["signing_status_4"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
            }
        }

        $today=date("Y/m/d");
        $this_year=date("Y");
        $rowdata=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $leave){
                $start=substr($leave["start"],0,10);
                $personname="";
                foreach ($persons as $person){
                    switch ($leave["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $status_name="";
                foreach ($leaves_status as $leave_status){
                    if($leave["no"]==$leave_status["leave_no"])
                        $status_name=$leave_status["status"];
                }
                $d_name="";
                foreach($departments as $department)
                {
                    if($leave["depart_leave_unit_department"]==$department["no"])
                        $d_name=$department["department"];
                }
                if($leave["upload_file"]==null and ($leave["category"]=="病假" or $leave["category"]=="喪假" or $leave["category"]=="公假" or $leave["category"]=="產假" or $leave["category"]=="陪產假" or $leave["category"]=="婚假" or $leave["category"]=="公傷病假"))
                    $status_name=$status_name."*";
                if($leave["person_id"]==$person_id  and $leave["category"]=="特休" and strtotime($this_year)==strtotime(substr($start,0,4)))
                {
//                dd("test");
                    $annual_leave_hour=$annual_leave_hour+(float)$leave["leave_time"];
                }
                if($leave["person_id"]==$person_id  and $leave["category"] != "出差" and strtotime($today)<=strtotime($start))
                {

                    if($status_name=="審核通過")
                        $update=sprintf("<button class=\"btn btn-outline-dark\" title=\"修改假單\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\" disabled>修改</button>");
                    else
                        $update=sprintf("<button class=\"btn btn-outline-dark\" title=\"修改假單\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>");
                    array_push($rowdata,array(
                        'no'=>$leave["no"],
                        'id'=>$leave["person_id"],
                        'name'=>$personname,
                        'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                        'department_name'=>$d_name,
                        'category'=>$leave["category"],
                        'reason'=>$leave["reason"],
                        'start'=>$leave["start"],
                        'end'=>$leave["end"],
                        'leave_day'=>$leave["leave_day"],
                        'leave_time'=>$leave["leave_time"],
                        'substitute'=>$leave["substitute"],
                        'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                        'modify'=>$update,
                        'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                        'status'=>$status_name,
                        'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出假單\" onclick=\"leave_word(this)\">匯出</button>"),
                    ));
                }
            }
        }

        //計算剩餘特休
        $on_board_role=array("0","7","10","14","14","15","15","15","15","15","16","17","18","19","20","21","22","23","24","25","26","27","28","29","30");
        $this_month="12";
        $on_board_year=substr($on_board,0,4);
        $on_board_month=substr($on_board,5,2);
        $year=(int)$this_year-(int)$on_board_year;
        $month=(int)$this_month-(int)$on_board_month;
        $on_board_day="";
        if($year==0 and $month>5)
            $on_board_day="3";
        elseif($year>24)
            $on_board_day="30";
        else
            $on_board_day=$on_board_role[$year];
        $remain_annual_leave=(float)$on_board_day*8-$annual_leave_hour;
        $remain_annual_leave_day=intval(floor($remain_annual_leave/8));
        $remain_annual_leave_hour=$remain_annual_leave-8*$remain_annual_leave_day;

        $check=0;
        if($msg!=null)
            return view("Person_Employee_for_Leave_",['title'=>'員工請假','person_name'=>$person_name,'rowdata'=>$rowdata,'level'=>$level,'error_msg'=>$msg,'person_id'=>$person_id,'department_no'=>$department_no,'department_name'=>$department_name,'departments'=>$departments,'persons'=>$persons,'remain_annual_leave_day'=>$remain_annual_leave_day,'remain_annual_leave_hour'=>$remain_annual_leave_hour,'authority'=>$authority,'check'=>$check]);
        else
            return view("Person_Employee_for_Leave_",['title'=>'員工請假','person_name'=>$person_name,'rowdata'=>$rowdata,'level'=>$level,'person_id'=>$person_id,'department_no'=>$department_no,'department_name'=>$department_name,'departments'=>$departments,'persons'=>$persons,'remain_annual_leave_day'=>$remain_annual_leave_day,'remain_annual_leave_hour'=>$remain_annual_leave_hour,'authority'=>$authority,'check'=>$check]);
    }
    //所有請假資料
    public function employeeforleave_all(Request $request)
    {
        $request->session()->all();
        $msg = request()->session()->get('error_msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $department_no="";
        $level="";
        $person_id="";
        $on_board="";
        $user_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $department_no=$user["department"];
                $on_board=$user["on_board"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }
        if(in_array ("24" , $user_auth))
        {
            $level="3";
        }

        $departments= array();
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $department) {
                if($department["no"]==$department_no)
                    $department_name=$department["department"];
                array_push( $departments, array(
                    "no" => $department["no"],
                    "department" => $department["department"],
                ));
            }
        }
        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }
        $person_name="";
        $persons=array();
        $annual_leave_hour=0;
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $person){
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }
                if($level=="3"or$level=="4")
                {
                    array_push($persons,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }
                elseif(in_array ("18" , $user_auth))
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                else
                {
                    if($person["ID"]==$person_id)
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
            }
        }

        //標記審核狀態
        $leaves_status=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/leave/signing/status/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $status){
                if($status["signing_status_1"]=="1")
                {
                    if($status["signing_status_2"]=="1")
                    {
                        if($status["signing_status_3"]=="1")
                        {
                            if($status["signing_status_4"]=="1")
                            {
                                array_push($leaves_status,array(
                                    'leave_no'=>$status["leave_off_work_no"],
                                    'status'=>"審核通過",
                                ));
                            }
                            else
                            {
                                array_push($leaves_status,array(
                                    'leave_no'=>$status["leave_off_work_no"],
                                    'status'=>"審核中(4)",
                                ));
                            }
                        }
                        else
                        {
                            array_push($leaves_status,array(
                                'leave_no'=>$status["leave_off_work_no"],
                                'status'=>"審核中(3)",
                            ));
                        }
                    }
                    else
                    {
                        array_push($leaves_status,array(
                            'leave_no'=>$status["leave_off_work_no"],
                            'status'=>"審核中(2)",
                        ));
                    }
                }
                else
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"審核中(1)",
                    ));
                }
                if($status["signing_status_1"]!="1" and $status["signing_status_1"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
                if($status["signing_status_2"]!="1" and $status["signing_status_2"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
                if($status["signing_status_3"]!="1" and $status["signing_status_3"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
                if($status["signing_status_4"]!="1" and $status["signing_status_4"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
            }
        }

        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }
//        dd($group_persons);
        $rowdata=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $leave){
                $personname="";
                foreach ($persons as $person){
                    switch ($leave["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $status_name="";
                foreach ($leaves_status as $leave_status){
                    if($leave["no"]==$leave_status["leave_no"])
                        $status_name=$leave_status["status"];
                }
                $d_name="";
                foreach($departments as $department)
                {
                    if($leave["depart_leave_unit_department"]==$department["no"])
                        $d_name=$department["department"];
                }
                if($leave["upload_file"]==null and ($leave["category"]=="病假" or $leave["category"]=="喪假" or $leave["category"]=="公假" or $leave["category"]=="產假" or $leave["category"]=="陪產假" or $leave["category"]=="婚假" or $leave["category"]=="公傷病假"))
                    $status_name=$status_name."*";
                if($level=="3" or $level=="4" )
                {
                    if($leave["category"] != "出差")
                    {
                        if($status_name=="審核通過")
                            $update=sprintf("<button class=\"btn btn-outline-dark\" title=\"修改假單\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\" disabled>修改</button>");
                        else
                            $update=sprintf("<button class=\"btn btn-outline-dark\" title=\"修改假單\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>");
                        array_push($rowdata,array(
                            'no'=>$leave["no"],
                            'id'=>$leave["person_id"],
                            'name'=>$personname,
                            'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                            'department_name'=>$d_name,
                            'category'=>$leave["category"],
                            'reason'=>$leave["reason"],
                            'start'=>$leave["start"],
                            'end'=>$leave["end"],
                            'leave_day'=>$leave["leave_day"],
                            'leave_time'=>$leave["leave_time"],
                            'substitute'=>$leave["substitute"],
                            'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                            'modify'=>$update,
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                            'status'=>$status_name,
                            'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出假單\" onclick=\"leave_word(this)\">匯出</button>"),
                        ));
                    }
                }
                elseif(in_array ("18", $user_auth))
                {
//                dd($group_persons);
                    if(in_array ($leave["person_id"] , $group_persons)  and $leave["category"] != "出差")
                    {
//                    dd($persons);
//                    if($leave["category"]=="特休")
//                    {
//                        $annual_leave_hour=$annual_leave_hour+(float)$leave["leave_time"];
//                    }
                        array_push($rowdata,array(
                            'no'=>$leave["no"],
                            'id'=>$leave["person_id"],
                            'name'=>$personname,
                            'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                            'department_name'=>$d_name,
                            'category'=>$leave["category"],
                            'reason'=>$leave["reason"],
                            'start'=>$leave["start"],
                            'end'=>$leave["end"],
                            'leave_day'=>$leave["leave_day"],
                            'leave_time'=>$leave["leave_time"],
                            'substitute'=>$leave["substitute"],
                            'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                            'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改假單\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>"),
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                            'status'=>$status_name,
                            'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出假單\" onclick=\"leave_word(this)\">匯出</button>"),
                        ));
                    }
                }
                else
                {
                    if($leave["person_id"]==$person_id  and $leave["category"] != "出差")
                    {
                        if($status_name=="審核通過")
                            $update=sprintf("<button class=\"btn btn-outline-dark\" title=\"修改假單\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\" disabled>修改</button>");
                        else
                            $update=sprintf("<button class=\"btn btn-outline-dark\" title=\"修改假單\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>");
                        array_push($rowdata,array(
                            'no'=>$leave["no"],
                            'id'=>$leave["person_id"],
                            'name'=>$personname,
                            'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                            'department_name'=>$d_name,
                            'category'=>$leave["category"],
                            'reason'=>$leave["reason"],
                            'start'=>$leave["start"],
                            'end'=>$leave["end"],
                            'leave_day'=>$leave["leave_day"],
                            'leave_time'=>$leave["leave_time"],
                            'substitute'=>$leave["substitute"],
                            'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                            'modify'=>$update,
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                            'status'=>$status_name,
                            'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出假單\" onclick=\"leave_word(this)\">匯出</button>"),
                        ));
                    }
                }
            }
        }

//        dd($user_auth);

//        $on_board_role=array("0","7","10","14","14","15","15","15","15","15","16","17","18","19","20","21","22","23","24","25","26","27","28","29","30");
//        $this_year=date("Y");
//        $this_month="12";
//        $on_board_year=substr($on_board,0,4);
//        $on_board_month=substr($on_board,5,2);
//        $year=(int)$this_year-(int)$on_board_year;
//        $month=(int)$this_month-(int)$on_board_month;
//        $on_board_day="";
//        if($year==0 and $month>5)
//            $on_board_day="3";
//        elseif($year>24)
//            $on_board_day="30";
//        else
//            $on_board_day=$on_board_role[$year];
//        $remain_annual_leave=(float)$on_board_day*8-$annual_leave_hour;
//        $remain_annual_leave_day=intval(floor($remain_annual_leave/8));
//        $remain_annual_leave_hour=$remain_annual_leave-8*$remain_annual_leave_day;
        //dd($remain_annual_leave_hour);
//        dd($rowdata);
        $check=0;
        if($msg!=null)
            return view("Person_Employee_for_Leave_",['title'=>'員工請假','person_name'=>$person_name,'rowdata'=>$rowdata,'level'=>$level,'error_msg'=>$msg,'person_id'=>$person_id,'department_no'=>$department_no,'department_name'=>$department_name,'departments'=>$departments,'persons'=>$persons,'authority'=>$authority,'check'=>$check]);
        else
            return view("Person_Employee_for_Leave_",['title'=>'員工請假','person_name'=>$person_name,'rowdata'=>$rowdata,'level'=>$level,'person_id'=>$person_id,'department_no'=>$department_no,'department_name'=>$department_name,'departments'=>$departments,'persons'=>$persons,'authority'=>$authority,'check'=>$check]);
    }
    //新增假單
    public function post_employeeleave(Request $request)
    {
        //證明文件
        if ($request->hasFile("upload_file")) {
            $path = $request->file("upload_file")->store("upload_file");
            $file = fopen(Storage::disk('local')->getDriver()->getAdapter()->getPathPrefix() . $path, 'r');
        } else {
            $file = "";
        }
        //新增假單
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/leave/insert", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST",
            "multipart",
            [
                [
                    'name' => "depart_leave_unit_department",
                    'contents' => $request->department
                ],
                [
                    'name' => "person_id",
                    'contents' => $request->person
                ],
                [
                    'name' => "category",
                    'contents' => $request->category
                ],
                [
                    'name' => "reason",
                    'contents' => $request->reason
                ],
                [
                    'name' => "start",
                    'contents' => $request->start_time
                ],
                [
                    'name' => "end",
                    'contents' => $request->end_time
                ],
                [
                    'name' => "leave_day",
                    'contents' => $request->leave_day
                ],
                [
                    'name' => "leave_time",
                    'contents' => $request->leave_time
                ],
                [
                    'name' => "substitute",
                    'contents' => $request->substitute
                ],
                [
                    'Content-type' => 'multipart/form-data',
                    'name' => 'upload_file',
                    'contents' => $file,
                    'headers' => ['Content-Type' => 'image/jpeg']
                ],
            ]);
        $jsondata=json_decode($res->getBody()->__toString(),true);
        $msg=$jsondata["Message"];
        $return_msg="";
        if(strpos($msg,"inserted") !== false)
            $return_msg="新增請假成功";
        elseif(strpos($msg,"database") !== false)
            $return_msg="請假資料已存在";
        else
            $return_msg="新增請假失敗";

//        dd($return_msg);

        //新增假單要一起新增假單審核
        //找出剛剛新增的請假資料的no欄位
        $no = "";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
//        dd($jsondata);
        foreach ($jsondata["Data"] as $leave) {
            if ($leave["person_id"] == $request->person && $leave["start"] == $request->start_time && $leave["end"] == $request->end_time)
                $no = $leave["no"];
        }
        //判斷請假人的身分
        //藉由person_id找到user_id
        //判斷請假天數是否大於三天，大於三天且為主管需多一層審核
        $status_4 = "1";
        $user_id = "";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        foreach ($jsondata["Data"] as $user) {
            if ($user["person_id"] == $request->person) {
                $user_id = $user["id"];
                if($user["role"]=="6")
                {
                    if ($request->leave_day > 3) {
                        $status_4 = "0";
                    }
                }
            }
        }
        //藉由user_id對照"features_user_relation"判斷審核身分
        //身分判斷：0->一般員工、1->18 審核1(主管)、2->19 審核2(管理部)、3->20 審核3(管理部主管)
        $identity = "0";
        $user_auth = array();
        //先取得所有權限
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if ($user_authority["user_id"] == $user_id) {
                    array_push($user_auth, $user_authority["features_id"]);
                }
            }
        }
        //從所有權限判斷是否有審核權限
        //審核權限影響預設的審核狀態
        $status_1 = "0";
        $status_2 = "0";
        $status_3 = "0";
        if (in_array("18", $user_auth))    //18->審核1(部門主管)
        {
            $identity = "1";
            //審核狀態預設100
            $status_1 = "1";
        }
        if (in_array("19", $user_auth))    //19->審核2(管理部)
        {
            $identity = "2";
            //審核狀態預設110
            $status_1 = "1";
            $status_2 = "1";
        }
        if (in_array("20", $user_auth))    //20->審核3(管理部主管)
        {
            $identity = "3";
            //審核狀態預設111，給第四層審核
            $status_1 = "1";
            $status_2 = "1";
            $status_3 = "1";
            $status_4 = "0";
        }

        //新增假單審核
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/leave/signing/status/insert", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST",
            "multipart",
            [
                [
                    'name' => "leave_off_work_no",
                    'contents' => $no
                ],
                [
                    'name' => "depart_leave_unit_department",
                    'contents' => $request->department
                ],
                [
                    'name' => "signing_status_1",
                    'contents' => $status_1
                ],
                [
                    'name' => "signing_status_2",
                    'contents' => $status_2
                ],
                [
                    'name' => "signing_status_3",
                    'contents' => $status_3
                ],
                [
                    'name' => "signing_status_4",
                    'contents' => $status_4
                ],
            ]);

        //寄mail通知，取得收件人
        $mail = array();
        //從"features_user_relation"取出各個階段審核人的user_id
        $check_1 = array();
        $check_2 = array();
        $check_3 = array();
        $check_4 = array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if ($user_authority["features_id"] == "18") {
                    array_push($check_1, $user_authority["user_id"]);
                }
                if ($user_authority["features_id"] == "19") {
                    array_push($check_2, $user_authority["user_id"]);
                }
                if ($user_authority["features_id"] == "20") {
                    array_push($check_3, $user_authority["user_id"]);
                }
                if ($user_authority["features_id"] == "21") {
                    array_push($check_4, $user_authority["user_id"]);
                }
            }
        }

        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$request->person)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }

        //從"user"中找出審核人的名字、mail，找出請假人的名字
        $name = "";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        foreach ($jsondata["Data"] as $user) {
            if ($user["person_id"] == $request->person) {
                $name = $user["name"];
            }
            //根據不同身分審核人不同
            //第一層審核：部門主管要跟請假人同部門
            if ($identity == "0") {
                if (in_array($user["id"], $check_1) and in_array($user["person_id"], $group_persons)) {
                    if($user["email"]!="")
                    {
                        array_push($mail, array(
                            "name" => $user["name"],
                            'mail' => $user["email"],
                        ));
                    }
                }
            }
            if ($identity == "1") {
                if (in_array($user["id"], $check_2)) {
                    if($user["email"]!="")
                    {
                        array_push($mail, array(
                            "name" => $user["name"],
                            'mail' => $user["email"],
                        ));
                    }
                }
            }
            if ($identity == "2") {
                if (in_array($user["id"], $check_3)) {
                    if($user["email"]!="")
                    {
                        array_push($mail, array(
                            "name" => $user["name"],
                            'mail' => $user["email"],
                        ));
                    }
                }
            }
            if ($identity == "3") {
                if (in_array($user["id"], $check_4)) {
                    if($user["email"]!="")
                    {
                        array_push($mail, array(
                            "name" => $user["name"],
                            'mail' => $user["email"],
                        ));
                    }
                }
            }
        }

        //寄mail通知
        //找出部門名稱
        $department = "";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if ($jsondata["Data"] != null) {
            foreach ($jsondata["Data"] as $departments) {
                if ($request->department == $departments["no"]) {
                    $department = $departments["department"];
                }
            }
        }
//        dd($mail);
        if(!is_null($mail))
        {
            foreach($mail as $mailto)
            {
                $data=[
                    'mange'=>$mailto["name"],   //主管名字
                    'dart'=>$department,    //部門名稱
                    'name'=>$name,     //請假員工名字
                    'category'=>$request->category,     //請假假別
                    'reason'=>$request->reason,     //請假理由
                    'leave_time'=>$request->leave_time,       //請假時長
                    'start_end'=>$request->start_time."-".$request->end_time,   //請假期間
                ];
                $email=$mailto["mail"];
                Mail::send('employee_mail',$data, function($message) use ($email) {
                    $message->to($email)->subject('差勤系統請假單審核');
                });
            }
        }
        return redirect()->route('leave_index')->with(["msg" => $return_msg]);
    }
    //刪除請假紀錄
    public function delete_employeeleave(Request $request)
    {
        //dd($request->selectedId);
        $id=$request->selectedId;
        $no=null;
        //dd($id);

        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/leave/signing/status/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $leave_status){
            if($leave_status["leave_off_work_no"]==$id)
                $no=$leave_status["no"];
        }

        if($no!=null)
        {
            //dd($no);
            [$ret, $res] = $this->request_server(sprintf("http://%s:%s/leave/signing/status/delete", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST",
                "multipart",
                [
                    [
                        'name'=>"no",
                        "contents"=>$no
                    ],
                ]
            );

            [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/leave/delete", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST",
                "multipart",
                [
                    [
                        'name'=>"no",
                        "contents"=>$id
                    ],
                ]
            );
            $jsondata=json_decode($res->getBody()->__toString(),true);
            $msg=$jsondata["Message"];
//            dd($msg);
            $return_msg="";
            if(strpos($msg,"deleted") !== false)
                $return_msg="刪除請假成功";
            elseif(strpos($msg,"database") !== false)
                $return_msg="請假資料不存在";
            else
                $return_msg="刪除請假失敗";
        }
        return redirect()->route('leave_index')->with(["msg" => $return_msg]);

    }
    //修改請假紀錄
    public function update_employeeleave(Request $request)
    {

        if ($request->hasFile("upload_file")){
            $path=$request->file("upload_file")->store("upload_file");
            $file=fopen(Storage::disk('local')->getDriver()->getAdapter()->getPathPrefix().$path,'r');
        }
        else
        {
            $file="";
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/update", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST",
            "multipart",
            [
                [
                    'name'=>"no",
                    'contents'=>$request->no
                ],
                [
                    'name'=>"depart_leave_unit_department",
                    'contents'=>$request->department
                ],
                [
                    'name'=>"person_id",
                    'contents'=>$request->person
                ],
                [
                    'name'=>"category",
                    'contents'=>$request->category
                ],
                [
                    'name'=>"reason",
                    'contents'=>$request->reason
                ],
                [
                    'name'=>"start",
                    'contents'=>$request->start_time
                ],
                [
                    'name'=>"end",
                    'contents'=>$request->end_time
                ],
                [
                    'name' => "leave_day",
                    'contents' => $request->leave_day
                ],
                [
                    'name'=>"leave_time",
                    'contents'=>$request->leave_time
                ],
                [
                    'name'=>"substitute",
                    'contents'=>$request->substitute
                ],
                [
                    'Content-type' => 'multipart/form-data',
                    'name'     => 'upload_file',
                    'contents' => $file,
                    'headers' => ['Content-Type' => 'image/jpeg']
                ],
            ]);
        $jsondata=json_decode($res->getBody()->__toString(),true);
        $msg=$jsondata["Message"];
        $return_msg="";
        if(strpos($msg,"failed") !== false)
            $return_msg="修改請假失敗";
        elseif(strpos($msg,"database") !== false)
        {
            if(strpos($msg,"is") !== false)
                $return_msg="請假資料已有相同時間";
            else
                $return_msg="請假資料不存在";
        }
        else
            $return_msg="修改請假成功";
        $no="";
        $leave="";
        $status1="";
        $status2="";
        $status3="";
        $status4="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/leave/signing/status/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $status){
            if($request->no==$status["leave_off_work_no"])
            {
                $no=$status["no"];
                $leave=$status["leave_off_work_no"];
                $status1=$status["signing_status_1"];
                $status2=$status["signing_status_2"];
                $status3=$status["signing_status_3"];
                $status4=$status["signing_status_4"];
            }
        }
        if($status1!="1" and $status1!="0")
            $status1="0";
        if($status2!="1" and $status2!="0")
            $status2="0";
        if($status3!="1" and $status3!="0")
            $status3="0";
        if($status4!="1" and $status4!="0")
            $status4="0";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/leave/signing/status/update", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST",
            "multipart",
            [
                [
                    'name'=>"no",
                    'contents'=>$no
                ],
                [
                    'name'=>"leave_off_work_no",
                    'contents'=>$leave
                ],
                [
                    'name'=>"depart_leave_unit_department",
                    'contents'=>$request->department
                ],
                [
                    'name'=>"signing_status_1",
                    'contents'=>$status1
                ],
                [
                    'name'=>"signing_status_2",
                    'contents'=>$status2
                ],
                [
                    'name'=>"signing_status_3",
                    'contents'=>$status3
                ],
                [
                    'name'=>"signing_status_4",
                    'contents'=>$status4
                ],
            ]);
        return redirect()->route('leave_index')->with(["msg" => $return_msg]);
    }
    //匯出假單
    public function export_leave(Request $request)
    {
        //dd($request->leave_id);
        $leave_id=$request->leave_id;
        $person_id="";
        $person_name="";
        $department_id="";
        $department="";
        $category="";
        $substitute="";
        $start="";
        $end="";
        $start_date="";
        $end_date="";
        $start_time="";
        $end_time="";
        $hour="";
        $reason="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $leave){
            if($leave["no"]==$leave_id)
            {
                $person_id=$leave["person_id"];
                $department_id=$leave["depart_leave_unit_department"];
                $category=$leave["category"];
                $substitute=$leave["substitute"];
                $start=$leave["start"];
                $end=$leave["end"];
                $hour=$leave["leave_time"];
                $reason=$leave["reason"];
            }
        }

        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $departments) {
                if($department_id==$departments["no"])
                {
                    $department=$departments["department"];
                }
            }
        }

        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user){
            if($person_id==$user["person_id"]){
                $person_name=$user["name"];
            }
        }
        if($substitute=="")
        {
            $substitute="無";
        }
        list($start_date, $start_time) = explode(" ",$start);
        list($end_date, $end_time) = explode(" ",$end);

        $filename = sprintf("../storage/export/請假單%s.docx",$leave_id);
        $file = fopen($filename, 'w');
        $client = new \GuzzleHttp\Client();
        $res=$client->request('POST', sprintf("http://%s:%s/leave/word",env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),[
            'form_params'=>[
                'leave_id'=>$leave_id,
                'person_id'=>$person_id,
                'person_name'=>$person_name,
                'department'=>$department,
                'category'=>$category,
                'substitute'=>$substitute,
                'start_date'=>$start_date,
                'end_date'=>$end_date,
                'start_time'=>$start_time,
                'end_time'=>$end_time,
                'hour'=>$hour,
                'reason'=>$reason,
            ],
            'save_to' => $file
        ]);
        return response()->download($filename);
    }
    //搜尋假單
    public function search_leave(Request $request){
        //dd($request->end);
        // 表單傳值回帶
        session()->flashInput($request->input());
//        dd($request->session());
        $request->session()->all();
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $department_no="";
        $level="";
        $person_id="";
        $user_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $department_no=$user["department"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }
        if(in_array ("24" , $user_auth))
        {
            $level="3";
        }

        $departments= array();
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $department) {
                if($department["no"]==$department_no)
                    $department_name=$department["department"];
                array_push( $departments, array(
                    "no" => $department["no"],
                    "department" => $department["department"],
                ));
            }
        }
        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }
        $person_name="";
        $persons=array();
        $annual_leave_hour=0;
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $person){
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }
                if($level=="3"or$level=="4")
                {
                    array_push($persons,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }
                elseif(in_array ("18" , $user_auth))
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                else
                {
                    if($person["ID"]==$person_id)
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
            }
        }

        //標記審核狀態
        $leaves_status=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/leave/signing/status/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $status){
                if($status["signing_status_1"]=="1")
                {
                    if($status["signing_status_2"]=="1")
                    {
                        if($status["signing_status_3"]=="1")
                        {
                            if($status["signing_status_4"]=="1")
                            {
                                array_push($leaves_status,array(
                                    'leave_no'=>$status["leave_off_work_no"],
                                    'status'=>"審核通過",
                                ));
                            }
                            else
                            {
                                array_push($leaves_status,array(
                                    'leave_no'=>$status["leave_off_work_no"],
                                    'status'=>"審核中(4)",
                                ));
                            }
                        }
                        else
                        {
                            array_push($leaves_status,array(
                                'leave_no'=>$status["leave_off_work_no"],
                                'status'=>"審核中(3)",
                            ));
                        }
                    }
                    else
                    {
                        array_push($leaves_status,array(
                            'leave_no'=>$status["leave_off_work_no"],
                            'status'=>"審核中(2)",
                        ));
                    }
                }
                else
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"審核中(1)",
                    ));
                }
                if($status["signing_status_1"]!="1" and $status["signing_status_1"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
                if($status["signing_status_2"]!="1" and $status["signing_status_2"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
                if($status["signing_status_3"]!="1" and $status["signing_status_3"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
                if($status["signing_status_4"]!="1" and $status["signing_status_4"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
            }
        }

        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }

        $rowdata=array();
        $personname="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $leave){
                $start=substr($leave["start"],0,10);
                $end=substr($leave["end"],0,10);
                foreach ($persons as $person){
                    switch ($leave["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $status_name="";
                foreach ($leaves_status as $leave_status){
                    if($leave["no"]==$leave_status["leave_no"])
                        $status_name=$leave_status["status"];
                }
                $d_name="";
                foreach($departments as $department)
                {
                    if($leave["depart_leave_unit_department"]==$department["no"])
                        $d_name=$department["department"];
                }
                if($leave["upload_file"]==null and ($leave["category"]=="病假" or $leave["category"]=="喪假" or $leave["category"]=="公假" or $leave["category"]=="產假" or $leave["category"]=="陪產假" or $leave["category"]=="婚假" or $leave["category"]=="公傷病假"))
                    $status_name=$status_name."*";
                if($status_name=="審核通過")
                    $update=sprintf("<button class=\"btn btn-outline-dark\" title=\"修改假單\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\" disabled>修改</button>");
                else
                    $update=sprintf("<button class=\"btn btn-outline-dark\" title=\"修改假單\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>");
                if($start==$end)
                {
                    if((strtotime($request->start)<=strtotime($start) and strtotime($end)<=strtotime($request->end)))
                    {
                        if($level=="3" or $level=="4" )
                        {
                            if($leave["category"] != "出差")
                            {

                                array_push($rowdata,array(
                                    'no'=>$leave["no"],
                                    'id'=>$leave["person_id"],
                                    'name'=>$personname,
                                    'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                    'department_name'=>$d_name,
                                    'category'=>$leave["category"],
                                    'reason'=>$leave["reason"],
                                    'start'=>$leave["start"],
                                    'end'=>$leave["end"],
                                    'leave_day'=>$leave["leave_day"],
                                    'leave_time'=>$leave["leave_time"],
                                    'substitute'=>$leave["substitute"],
                                    'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                    'modify'=>$update,
                                    'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                                    'status'=>$status_name,
                                    'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出假單\" onclick=\"leave_word(this)\">匯出</button>"),
                                ));
                            }
                        }
                        elseif(in_array ("18" , $user_auth))
                        {
                            if(in_array ($leave["person_id"] , $group_persons)  and $leave["category"] != "出差")
                            {
                                array_push($rowdata,array(
                                    'no'=>$leave["no"],
                                    'id'=>$leave["person_id"],
                                    'name'=>$personname,
                                    'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                    'department_name'=>$d_name,
                                    'category'=>$leave["category"],
                                    'reason'=>$leave["reason"],
                                    'start'=>$leave["start"],
                                    'end'=>$leave["end"],
                                    'leave_day'=>$leave["leave_day"],
                                    'leave_time'=>$leave["leave_time"],
                                    'substitute'=>$leave["substitute"],
                                    'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                    'modify'=>$update,
                                    'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                                    'status'=>$status_name,
                                    'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出假單\" onclick=\"leave_word(this)\">匯出</button>"),
                                ));
                            }
                        }
                        else
                        {
                            if($leave["person_id"]==$person_id  and $leave["category"] != "出差")
                            {
                                array_push($rowdata,array(
                                    'no'=>$leave["no"],
                                    'id'=>$leave["person_id"],
                                    'name'=>$personname,
                                    'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                    'department_name'=>$d_name,
                                    'category'=>$leave["category"],
                                    'reason'=>$leave["reason"],
                                    'start'=>$leave["start"],
                                    'end'=>$leave["end"],
                                    'leave_day'=>$leave["leave_day"],
                                    'leave_time'=>$leave["leave_time"],
                                    'substitute'=>$leave["substitute"],
                                    'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                    'modify'=>$update,
                                    'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                                    'status'=>$status_name,
                                    'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出假單\" onclick=\"leave_word(this)\">匯出</button>"),
                                ));
                            }
                        }
                    }
                }
                else
                {
                    $check="0";
                    $s_time=$leave["start"];
                    $thisday=$start;
                    $end_day=$end;
                    while($thisday!=$end_day)
                    {
                        if(strtotime($request->start)<=strtotime($thisday) and strtotime($thisday)<=strtotime($request->end))
                        {
                            $check="1";
                        }
                        $thisday=date("Y/m/d", strtotime($thisday."+1 day"));
                        if($thisday!=$end_day)
                        {
                            while(date("w", strtotime($thisday))=="6" or date("w", strtotime($thisday))=="0")
                            {
                                $thisday=date("Y/m/d", strtotime($thisday."+1 day"));
                            }
                        }
                    }
                    if(strtotime($request->start)<=strtotime($thisday) and strtotime($thisday)<=strtotime($request->end))
                    {
                        $check="1";
                    }
                    if($check=="1")
                    {
                        if($level=="3" or $level=="4" )
                        {
                            if($leave["category"] != "出差")
                            {
                                array_push($rowdata,array(
                                    'no'=>$leave["no"],
                                    'id'=>$leave["person_id"],
                                    'name'=>$personname,
                                    'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                    'department_name'=>$d_name,
                                    'category'=>$leave["category"],
                                    'reason'=>$leave["reason"],
                                    'start'=>$leave["start"],
                                    'end'=>$leave["end"],
                                    'leave_day'=>$leave["leave_day"],
                                    'leave_time'=>$leave["leave_time"],
                                    'substitute'=>$leave["substitute"],
                                    'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                    'modify'=>$update,
                                    'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                                    'status'=>$status_name,
                                    'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出假單\" onclick=\"leave_word(this)\">匯出</button>"),
                                ));
                            }
                        }
                        elseif(in_array ("18" , $user_auth))
                        {
                            if(in_array ($leave["person_id"] , $group_persons)  and $leave["category"] != "出差")
                            {
                                array_push($rowdata,array(
                                    'no'=>$leave["no"],
                                    'id'=>$leave["person_id"],
                                    'name'=>$personname,
                                    'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                    'department_name'=>$d_name,
                                    'category'=>$leave["category"],
                                    'reason'=>$leave["reason"],
                                    'start'=>$leave["start"],
                                    'end'=>$leave["end"],
                                    'leave_day'=>$leave["leave_day"],
                                    'leave_time'=>$leave["leave_time"],
                                    'substitute'=>$leave["substitute"],
                                    'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                    'modify'=>$update,
                                    'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                                    'status'=>$status_name,
                                    'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出假單\" onclick=\"leave_word(this)\">匯出</button>"),
                                ));
                            }
                        }
                        else
                        {
                            if($leave["person_id"]==$person_id  and $leave["category"] != "出差")
                            {
                                array_push($rowdata,array(
                                    'no'=>$leave["no"],
                                    'id'=>$leave["person_id"],
                                    'name'=>$personname,
                                    'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                    'department_name'=>$d_name,
                                    'category'=>$leave["category"],
                                    'reason'=>$leave["reason"],
                                    'start'=>$leave["start"],
                                    'end'=>$leave["end"],
                                    'leave_day'=>$leave["leave_day"],
                                    'leave_time'=>$leave["leave_time"],
                                    'substitute'=>$leave["substitute"],
                                    'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                    'modify'=>$update,
                                    'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                                    'status'=>$status_name,
                                    'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出假單\" onclick=\"leave_word(this)\">匯出</button>"),
                                ));
                            }
                        }
                    }
                }
            }
        }


        $check=0;
        return view("Person_Employee_for_Leave_",['title'=>'員工請假','person_name'=>$person_name,'rowdata'=>$rowdata,'level'=>$level,'person_id'=>$person_id,'department_no'=>$department_no,'department_name'=>$department_name,'departments'=>$departments,'persons'=>$persons,'authority'=>$authority,'check'=>$check]);
    }
    //搜尋某人假單
    public function search_leave_personal(Request $request)
    {
        //dd($request->end);
        // 表單傳值回帶
        session()->flashInput($request->input());
//        dd($request->session());
        $request->session()->all();
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $department_no="";
        $level="";
        $person_id="";
        $user_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $department_no=$user["department"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }
        if(in_array ("24" , $user_auth))
        {
            $level="3";
        }

        $departments= array();
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $department) {
                if($department["no"]==$department_no)
                    $department_name=$department["department"];
                array_push( $departments, array(
                    "no" => $department["no"],
                    "department" => $department["department"],
                ));
            }
        }
        //dd($department);
        $department_personid=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["department"]==$department_no)
            {
                array_push($department_personid,array(
                    'name'=>$user["name"],
                    'id'=>$user["person_id"]
                ));
            }
        }
        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }
        $person_name="";
        $persons=array();
        $annual_leave_hour=0;
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $person){
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }
                if($level=="3"or$level=="4")
                {
                    array_push($persons,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }
                elseif(in_array ("18" , $user_auth))
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                else
                {
                    if($person["ID"]==$person_id)
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
            }
        }
        //標記審核狀態
        $leaves_status=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/leave/signing/status/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $status){
                if($status["signing_status_1"]=="1")
                {
                    if($status["signing_status_2"]=="1")
                    {
                        if($status["signing_status_3"]=="1")
                        {
                            if($status["signing_status_4"]=="1")
                            {
                                array_push($leaves_status,array(
                                    'leave_no'=>$status["leave_off_work_no"],
                                    'status'=>"審核通過",
                                ));
                            }
                            else
                            {
                                array_push($leaves_status,array(
                                    'leave_no'=>$status["leave_off_work_no"],
                                    'status'=>"審核中(4)",
                                ));
                            }
                        }
                        else
                        {
                            array_push($leaves_status,array(
                                'leave_no'=>$status["leave_off_work_no"],
                                'status'=>"審核中(3)",
                            ));
                        }
                    }
                    else
                    {
                        array_push($leaves_status,array(
                            'leave_no'=>$status["leave_off_work_no"],
                            'status'=>"審核中(2)",
                        ));
                    }
                }
                else
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"審核中(1)",
                    ));
                }
                if($status["signing_status_1"]!="1" and $status["signing_status_1"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
                if($status["signing_status_2"]!="1" and $status["signing_status_2"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
                if($status["signing_status_3"]!="1" and $status["signing_status_3"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
                if($status["signing_status_4"]!="1" and $status["signing_status_4"]!="0")
                {
                    array_push($leaves_status,array(
                        'leave_no'=>$status["leave_off_work_no"],
                        'status'=>"退件",
                    ));
                }
            }
        }

        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }

        $rowdata=array();
        $personname="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $leave){
                $start=substr($leave["start"],0,10);
                $end=substr($leave["end"],0,10);
                foreach ($persons as $person){
                    switch ($leave["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $status_name="";
                foreach ($leaves_status as $leave_status){
                    if($leave["no"]==$leave_status["leave_no"])
                        $status_name=$leave_status["status"];
                }
                $d_name="";
                foreach($departments as $department)
                {
                    if($leave["depart_leave_unit_department"]==$department["no"])
                        $d_name=$department["department"];
                }
                if($leave["upload_file"]==null and ($leave["category"]=="病假" or $leave["category"]=="喪假" or $leave["category"]=="公假" or $leave["category"]=="產假" or $leave["category"]=="陪產假" or $leave["category"]=="婚假" or $leave["category"]=="公傷病假"))
                    $status_name=$status_name."*";

                if($start==$end)
                {
                    if((strtotime($request->start)<=strtotime($start) and strtotime($end)<=strtotime($request->end)))
                    {
                        if($leave["person_id"]==$request->person  and $leave["category"] != "出差")
                        {
                            array_push($rowdata,array(
                                'no'=>$leave["no"],
                                'id'=>$leave["person_id"],
                                'name'=>$personname,
                                'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                'department_name'=>$d_name,
                                'category'=>$leave["category"],
                                'reason'=>$leave["reason"],
                                'start'=>$leave["start"],
                                'end'=>$leave["end"],
                                'leave_day'=>$leave["leave_day"],
                                'leave_time'=>$leave["leave_time"],
                                'substitute'=>$leave["substitute"],
                                'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改假單\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>"),
                                'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                                'status'=>$status_name,
                                'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出假單\" onclick=\"leave_word(this)\">匯出</button>"),
                            ));
                        }
                    }
                }
                else
                {
                    $check="0";
                    $s_time=$leave["start"];
                    $thisday=$start;
                    $end_day=$end;
                    while($thisday!=$end_day)
                    {
                        if(strtotime($request->start)<=strtotime($thisday) and strtotime($thisday)<=strtotime($request->end))
                        {
                            $check="1";
                        }
                        $thisday=date("Y/m/d", strtotime($thisday."+1 day"));
                        if($thisday!=$end_day)
                        {
                            while(date("w", strtotime($thisday))=="6" or date("w", strtotime($thisday))=="0")
                            {
                                $thisday=date("Y/m/d", strtotime($thisday."+1 day"));
                            }
                        }
                    }
                    if(strtotime($request->start)<=strtotime($thisday) and strtotime($thisday)<=strtotime($request->end))
                    {
                        $check="1";
                    }
                    if($check=="1")
                    {
                        if($leave["person_id"]==$request->person  and $leave["category"] != "出差")
                        {
                            array_push($rowdata,array(
                                'no'=>$leave["no"],
                                'id'=>$leave["person_id"],
                                'name'=>$personname,
                                'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                'department_name'=>$d_name,
                                'category'=>$leave["category"],
                                'reason'=>$leave["reason"],
                                'start'=>$leave["start"],
                                'end'=>$leave["end"],
                                'leave_day'=>$leave["leave_day"],
                                'leave_time'=>$leave["leave_time"],
                                'substitute'=>$leave["substitute"],
                                'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改假單\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>"),
                                'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                                'status'=>$status_name,
                                'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出假單\" onclick=\"leave_word(this)\">匯出</button>"),
                            ));
                        }
                    }
                }
            }
        }

        $check=1;
        return view("Person_Employee_for_Leave_",['title'=>'員工請假','person_name'=>$person_name,'rowdata'=>$rowdata,'level'=>$level,'person_id'=>$person_id,'department_no'=>$department_no,'department_name'=>$department_name,'departments'=>$departments,'persons'=>$persons,'authority'=>$authority,'check'=>$check]);

    }
    //匯出區間假單
    public function export_all_leave(Request $request)
    {
        // 表單傳值回帶
        session()->flashInput($request->input());
        $start=str_replace( "/" , "-" , $request->start );
        $end=str_replace( "/" , "-" , $request->end );
        $filename = sprintf("../storage/export/%s to %s.xlsx",$start,$end);
        //dd($filename);
        $file = fopen($filename, 'w');
        $client = new \GuzzleHttp\Client();
        $res=$client->request('POST', sprintf("http://%s:%s/leave/excel",env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),[
            'form_params'=>[
                'start'=>$request->start,
                'end'=>$request->end,
            ],
            'save_to' => $file
        ]);
        return response()->download($filename);
    }

    //統計首頁
    public function statistics_index(Request $request)
    {
        $request->session()->all();
        $msg = request()->session()->get('msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $department_no="";
        $level="";
        $person_id="";
        $on_board="";
        $user_id="";
        //權限相關設計
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $department_no=$user["department"];
                $on_board=$user["on_board"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }

        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }

        $persons=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $person){
                if($level=="3" or $level=="4")
                {
                    array_push($persons,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }
                elseif(in_array ("18" , $user_auth))
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                else
                {
                    if($person["ID"]==$person_id)
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
            }
        }

        return view("Person_Leave_Statistics",['title'=>'請假統計','level'=>$level,'persons'=>$persons,'authority'=>$authority]);
    }
    //查詢統計
    public function search_statistics(Request $request)
    {
        // 表單傳值回帶
        session()->flashInput($request->input());
        $request->session()->all();
        $msg = request()->session()->get('msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $department_no="";
        $level="";
        $person_id="";
        $on_board="";
        $user_id="";
        //權限相關設計
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $department_no=$user["department"];
                $on_board=$user["on_board"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }

        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }

        $persons_1=array();
        $persons=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $person){
                array_push($persons_1,array(
                    'name'=>$person["Name"],
                    'id'=>$person["ID"]
                ));
                if($level=="3" or $level=="4")
                {
                    array_push($persons,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }
                elseif(in_array ("18" , $user_auth))
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                else
                {
                    if($person["ID"]==$person_id)
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
            }
        }


        $rowdata=array();
        $personname="";
        $category_all=array("特休"=>0,"公假"=>0,"事假"=>0,"病假"=>0,"公傷病假"=>0,"婚假"=>0,"產假"=>0,"陪產假"=>0,"喪假"=>0,"生理假"=>0,"補假"=>0,"防疫照顧假"=>0,"家庭照顧假"=>0,"防疫隔離假"=>0,"疫苗接種假"=>0);
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $leave){
                if($leave["category"]!="出差")
                {
                    $category=array("特休"=>0,"公假"=>0,"事假"=>0,"病假"=>0,"公傷病假"=>0,"婚假"=>0,"產假"=>0,"陪產假"=>0,"喪假"=>0,"生理假"=>0,"補假"=>0,"防疫照顧假"=>0,"家庭照顧假"=>0,"防疫隔離假"=>0,"疫苗接種假"=>0);
                    $start=substr($leave["start"],0,10);
                    $end=substr($leave["end"],0,10);
                    foreach ($persons_1 as $person){
                        switch ($leave["person_id"]){
                            case $person["id"]:
                                $personname= $person["name"];
                                break;
                        }
                    }
                    //先判斷人員是否正確
                    if($leave["person_id"]==$request->person)
                    {
                        //只有一天的請假
                        if($start==$end)
                        {
                            if(strtotime($request->start)<=strtotime($start) and strtotime($end)<=strtotime($request->end))
                            {
                                $category_all[$leave["category"]]=$category_all[$leave["category"]]+$leave["leave_time"];
                                $category[$leave["category"]]=$leave["leave_time"];
                                array_push($rowdata,array(
                                    'no'=>$leave["no"],
                                    'id'=>$leave["person_id"],
                                    'name'=>$personname,
                                    'date'=>$start,
                                    '特休'=>$category["特休"],
                                    '公假'=>$category["公假"],
                                    '事假'=>$category["事假"],
                                    '病假'=>$category["病假"],
                                    '公傷病假'=>$category["公傷病假"],
                                    '婚假'=>$category["婚假"],
                                    '產假'=>$category["產假"],
                                    '陪產假'=>$category["陪產假"],
                                    '喪假'=>$category["喪假"],
                                    '生理假'=>$category["生理假"],
                                    '補假'=>$category["補假"],
                                    '防疫照顧假'=>$category["防疫照顧假"],
                                    '家庭照顧假'=>$category["家庭照顧假"],
                                    '防疫隔離假'=>$category["防疫隔離假"],
                                    '疫苗接種假'=>$category["疫苗接種假"],
                                ));
                            }
                        }
                        else    //跨天的請假
                        {
                            $s_time=$leave["start"];
                            $thisday=$start;
                            $end_day=$end;
                            $all_hour=(float)$leave["leave_time"];
                            while($thisday!=$end_day)
                            {
                                $e_time=$thisday." 17:30";
                                $c_time=$thisday." 12:00";
                                if(strtotime($s_time)<strtotime($c_time))
                                    $this_hour=((strtotime($e_time)-strtotime($s_time))/3600)-1;
                                else
                                    $this_hour=(strtotime($e_time)-strtotime($s_time))/3600;
                                if(strtotime($request->start)<=strtotime($thisday) and strtotime($thisday)<=strtotime($request->end))
                                {
                                    $category_all[$leave["category"]]=$category_all[$leave["category"]]+$this_hour;
                                    $category[$leave["category"]]=$this_hour;
                                    array_push($rowdata,array(
                                        'no'=>$leave["no"],
                                        'id'=>$leave["person_id"],
                                        'name'=>$personname,
                                        'date'=>$thisday,
                                        '特休'=>$category["特休"],
                                        '公假'=>$category["公假"],
                                        '事假'=>$category["事假"],
                                        '病假'=>$category["病假"],
                                        '公傷病假'=>$category["公傷病假"],
                                        '婚假'=>$category["婚假"],
                                        '產假'=>$category["產假"],
                                        '陪產假'=>$category["陪產假"],
                                        '喪假'=>$category["喪假"],
                                        '生理假'=>$category["生理假"],
                                        '補假'=>$category["補假"],
                                        '防疫照顧假'=>$category["防疫照顧假"],
                                        '家庭照顧假'=>$category["家庭照顧假"],
                                        '防疫隔離假'=>$category["防疫隔離假"],
                                        '疫苗接種假'=>$category["疫苗接種假"],
                                    ));
                                }
                                $all_hour=$all_hour-$this_hour;
                                $thisday=date("Y/m/d", strtotime($thisday."+1 day"));
                                if($thisday!=$end_day)
                                {
                                    while(date("w", strtotime($thisday))=="6" or date("w", strtotime($thisday))=="0")
                                    {
                                        $thisday=date("Y/m/d", strtotime($thisday."+1 day"));
                                    }
                                }
                                $s_time=$thisday." 08:30";
                            }
                            if(strtotime($request->start)<=strtotime($thisday) and strtotime($thisday)<=strtotime($request->end))
                            {
                                $this_hour=((strtotime($leave["end"])-strtotime($s_time))/3600)-1;
//                            dd($this_hour);
                                $category_all[$leave["category"]]=$category_all[$leave["category"]]+$this_hour;
                                $category[$leave["category"]]=$this_hour;
                                array_push($rowdata,array(
                                    'no'=>$leave["no"],
                                    'id'=>$leave["person_id"],
                                    'name'=>$personname,
                                    'date'=>$thisday,
                                    '特休'=>$category["特休"],
                                    '公假'=>$category["公假"],
                                    '事假'=>$category["事假"],
                                    '病假'=>$category["病假"],
                                    '公傷病假'=>$category["公傷病假"],
                                    '婚假'=>$category["婚假"],
                                    '產假'=>$category["產假"],
                                    '陪產假'=>$category["陪產假"],
                                    '喪假'=>$category["喪假"],
                                    '生理假'=>$category["生理假"],
                                    '補假'=>$category["補假"],
                                    '防疫照顧假'=>$category["防疫照顧假"],
                                    '家庭照顧假'=>$category["家庭照顧假"],
                                    '防疫隔離假'=>$category["防疫隔離假"],
                                    '疫苗接種假'=>$category["疫苗接種假"],
                                ));
                            }
                        }
                    }
                }
            }
        }

        $test=array_keys($category_all,0);
//        dd($test);
        return view("Person_Leave_Statistics",['title'=>'請假統計','rowdata'=>$rowdata,'level'=>$level,'persons'=>$persons,'authority'=>$authority,'person_id'=>$request->person,'test'=>$test]);
    }
    //匯出個人統計
    public function export_statistics(Request $request)
    {
        // 表單傳值回帶
        session()->flashInput($request->input());
        $request->session()->all();
        $user_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["person_id"]==$request->person)
            {
                $user_id=$user["id"];
            }
        }
        $start=str_replace( "/" , "-" , $request->start );
        $end=str_replace( "/" , "-" , $request->end );
        $filename = sprintf("../storage/export/%s %s to %s.xlsx",$request->person,$start,$end);
        //dd($filename);
        $file = fopen($filename, 'w');
        $client = new \GuzzleHttp\Client();
        $res=$client->request('POST', sprintf("http://%s:%s/leave/excel/personal",env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),[
            'form_params'=>[
                'person_id'=>$request->person,
                'user_id'=>$user_id,
                'start'=>$request->start,
                'end'=>$request->end,
            ],
            'save_to' => $file
        ]);
        return response()->download($filename);

    }
    //匯出全部統計
    public function export_all_statistics(Request $request)
    {
        // 表單傳值回帶
        session()->flashInput($request->input());
        $request->session()->all();
        $start=str_replace( "/" , "-" , $request->start );
        $end=str_replace( "/" , "-" , $request->end );
        $filename = sprintf("../storage/export/%s to %s.xlsx",$start,$end);
        //dd($filename);
        $file = fopen($filename, 'w');
        $client = new \GuzzleHttp\Client();
        $res=$client->request('POST', sprintf("http://%s:%s/leave/excel/all",env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),[
            'form_params'=>[
                'start'=>$request->start,
                'end'=>$request->end,
            ],
            'save_to' => $file
        ]);
        return response()->download($filename);
    }
    //匯出特休統計
    public function export_annual_statistics(Request $request)
    {
        // 表單傳值回帶
        session()->flashInput($request->input());
        $request->session()->all();
        $filename = sprintf("../storage/export/%s_annual_leave.xlsx",$request->year);
        //dd($filename);
        $file = fopen($filename, 'w');
        $client = new \GuzzleHttp\Client();
        $res=$client->request('POST', sprintf("http://%s:%s/annual/leave/excel/all",env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),[
            'form_params'=>[
                'year'=>$request->year,
            ],
            'save_to' => $file
        ]);
        return response()->download($filename);
    }

    //主管審核首頁
    public function supervisorcheckleave_index(Request $request)
    {
        $request->session()->all();
        $msg = request()->session()->get('msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $department="";
        $level="";
        $user_id="";
        $person_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $role=$user["role"];
                $department=$user["department"];
                $user_id=$user["id"];
                $person_id=$user["person_id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }

        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }

        //找出假單資料
        //先找出person
        $persons=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $person){
                array_push($persons,array(
                    'name'=>$person["Name"],
                    'id'=>$person["ID"]
                ));
            }
        }
        $leaves=array();
        //找出所有假單資料，並將person_id換成person_name
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $leave){
                $personname="";
                foreach ($persons as $person){
                    switch ($leave["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $date=$leave["created"];
                $date_year=substr($date,0,3);
                $date_year_c=(string)((int)$date_year+1911);
                $date_month=substr($date,3,2);
                $date_day=substr($date,5,2);
                $date_hour=substr($date,7,2);
                $date_minute=substr($date,9,2);
                $date_second=substr($date,11,2);
                $this_day=$date_year_c."/".$date_month."/".$date_day." ".$date_hour.":".$date_minute.":".$date_second;
                $change_time=date("Y/m/d H:i:s", strtotime($this_day."+8 hour"));
                array_push($leaves,array(
                    'no'=>$leave["no"],
                    'id'=>$leave["person_id"],
                    'name'=>$personname,
                    'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                    'category'=>$leave["category"],
                    'reason'=>$leave["reason"],
                    'start'=>$leave["start"],
                    'end'=>$leave["end"],
                    'leave_time'=>$leave["leave_time"],
                    'substitute'=>$leave["substitute"],
                    'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                    'created'=>$change_time,
                ));
            }
        }

        //取得請假審核狀態
        $check="0";     //有第四層審核且有權限審核
        $rowdata=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/leave/signing/status/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $status) {
                $leave_person_id="";
                $name="";
                $category="";
                $reason="";
                $start="";
                $end="";
                $leave_day="";
                $leave_time="";
                $created="";
                foreach ($leaves as $leave) {
                    if ($leave["no"] == $status["leave_off_work_no"]) {
                        $leave_person_id=$leave["id"];
                        $name = $leave["name"];
                        $category = $leave["category"];
                        $reason = $leave["reason"];
                        $start = $leave["start"];
                        $end = $leave["end"];
                        $leave_time = $leave["leave_time"];
                        $created=$leave["created"];
                    }
                }
                $status_4="";
                if($status["signing_status_4"]=="0")
                    $status_4="等待審核";
                else
                    $status_4="不須審核";

                if($status["signing_status_1"]=="0")
                {
                    if($status["signing_status_2"]=="0")
                    {
                        if($status["signing_status_3"]=="0")
                        {
                            //000
                            //dd($user_auth);
                            if(in_array ("18" , $user_auth) and in_array ($leave_person_id , $group_persons))    //18->審核1(部門主管)
                            {
                                array_push($rowdata,array(
                                    'no'=>$status["no"],
                                    'leave_off_work_no'=>sprintf("<a>%s</a> &nbsp<button class=\"btn btn-outline-dark\" title=\"查看假單\" data-toggle=\"modal\" data-target=\"#CheckLeave\" onclick=\"check(this)\">查看詳情</button>",$name),
                                    'leave'=>$status["leave_off_work_no"],
                                    'depart_leave_unit_department'=>$status["depart_leave_unit_department"],
                                    'signing_status_1' =>sprintf("<a>尚未審核</a> &nbsp<button class=\"btn btn-secondary\" title=\"審核假單\" onclick=\"post_check_status_1(this)\">審核通過</button>"),
                                    'signing_status_2' =>sprintf("<a>尚未審核</a> &nbsp<button class=\"btn btn-secondary\" title=\"審核假單\" onclick=\"post_check_status_2(this)\" disabled>審核通過</button>"),
                                    'signing_status_3' =>sprintf("<a>尚未審核</a> &nbsp<button class=\"btn btn-secondary\" title=\"審核假單\" onclick=\"post_check_status_3(this)\" disabled>審核通過</button>"),
                                    'signing_status_4'=>$status_4,
                                    'name'=>$name,
                                    'category'=>$category,
                                    'reason'=>$reason,
                                    'start'=>$start,
                                    'end'=>$end,
                                    'leave_day'=>$leave_day,
                                    'leave_time'=>$leave_time,
                                    'created'=>$created,
                                    'disagree'=>sprintf("<button class=\"btn btn-danger\" title=\"駁回假單\" data-toggle=\"modal\" data-target=\"#DisagreeLeave\" onclick=\"disagree(this)\">審核不通過</button>"),
                                ));
                            }
                            elseif(in_array ("19" , $user_auth))
                            {
                                array_push($rowdata,array(
                                    'no'=>$status["no"],
                                    'leave_off_work_no'=>sprintf("<a>%s</a> &nbsp<button class=\"btn btn-outline-dark\" title=\"查看假單\" data-toggle=\"modal\" data-target=\"#CheckLeave\" onclick=\"check(this)\">查看詳情</button>",$name),
                                    'leave'=>$status["leave_off_work_no"],
                                    'depart_leave_unit_department'=>$status["depart_leave_unit_department"],
                                    'signing_status_1' =>sprintf("<a>尚未審核</a> &nbsp<button class=\"btn btn-secondary\" title=\"審核假單\" onclick=\"post_check_status_1(this)\">審核通過</button>"),
                                    'signing_status_2' =>sprintf("<a>尚未審核</a> &nbsp<button class=\"btn btn-secondary\" title=\"審核假單\" onclick=\"post_check_status_2(this)\" disabled>審核通過</button>"),
                                    'signing_status_3' =>sprintf("<a>尚未審核</a> &nbsp<button class=\"btn btn-secondary\" title=\"審核假單\" onclick=\"post_check_status_3(this)\" disabled>審核通過</button>"),
                                    'signing_status_4'=>$status_4,
                                    'name'=>$name,
                                    'category'=>$category,
                                    'reason'=>$reason,
                                    'start'=>$start,
                                    'end'=>$end,
                                    'leave_day'=>$leave_day,
                                    'leave_time'=>$leave_time,
                                    'created'=>$created,
                                    'disagree'=>sprintf("<button class=\"btn btn-danger\" title=\"駁回假單\" data-toggle=\"modal\" data-target=\"#DisagreeLeave\" onclick=\"disagree(this)\">審核不通過</button>"),
                                ));
                            }
                        }
                    }
                }
                elseif($status["signing_status_1"]=="1")
                {
                    if($status["signing_status_2"]=="0")
                    {
                        if($status["signing_status_3"]=="0")
                        {
                            //100
                            if(in_array ("19" , $user_auth))    //19->審核2(管理部)
                            {
                                array_push($rowdata,array(
                                    'no'=>$status["no"],
                                    'leave_off_work_no'=>sprintf("<a>%s</a> &nbsp<button class=\"btn btn-outline-dark\" title=\"查看假單\" data-toggle=\"modal\" data-target=\"#CheckLeave\" onclick=\"check(this)\">查看詳情</button>",$name),
                                    'leave'=>$status["leave_off_work_no"],
                                    'depart_leave_unit_department'=>$status["depart_leave_unit_department"],
                                    'signing_status_1' =>"已審核通過",
                                    'signing_status_2' =>sprintf("<a>尚未審核</a> &nbsp<button class=\"btn btn-secondary\" title=\"審核假單\" onclick=\"post_check_status_2(this)\">審核通過</button>"),
                                    'signing_status_3' =>sprintf("<a>尚未審核</a> &nbsp<button class=\"btn btn-secondary\" title=\"審核假單\" onclick=\"post_check_status_3(this)\" disabled>審核通過</button>"),
                                    'signing_status_4'=>$status_4,
                                    'name'=>$name,
                                    'category'=>$category,
                                    'reason'=>$reason,
                                    'start'=>$start,
                                    'end'=>$end,
                                    'leave_day'=>$leave_day,
                                    'leave_time'=>$leave_time,
                                    'created'=>$created,
                                    'disagree'=>sprintf("<button class=\"btn btn-danger\" title=\"駁回假單\" data-toggle=\"modal\" data-target=\"#DisagreeLeave\" onclick=\"disagree(this)\">審核不通過</button>"),
                                ));
                            }
                        }
                    }
                    elseif($status["signing_status_2"]=="1")
                    {
                        if($status["signing_status_3"]=="0")
                        {
                            //110
                            if(in_array ("20" , $user_auth))    //20->審核3(管理部主管)
                            {
                                array_push($rowdata,array(
                                    'no'=>$status["no"],
                                    'leave_off_work_no'=>sprintf("<a>%s</a> &nbsp<button class=\"btn btn-outline-dark\" title=\"查看假單\" data-toggle=\"modal\" data-target=\"#CheckLeave\" onclick=\"check(this)\">查看詳情</button>",$name),
                                    'leave'=>$status["leave_off_work_no"],
                                    'depart_leave_unit_department'=>$status["depart_leave_unit_department"],
                                    'signing_status_1' =>"已審核通過",
                                    'signing_status_2' =>"已審核通過",
                                    'signing_status_3' =>sprintf("<a>尚未審核</a> &nbsp<button class=\"btn btn-secondary\" title=\"審核假單\" onclick=\"post_check_status_3(this)\">審核通過</button>"),
                                    'signing_status_4'=>$status_4,
                                    'name'=>$name,
                                    'category'=>$category,
                                    'reason'=>$reason,
                                    'start'=>$start,
                                    'end'=>$end,
                                    'leave_day'=>$leave_day,
                                    'leave_time'=>$leave_time,
                                    'created'=>$created,
                                    'disagree'=>sprintf("<button class=\"btn btn-danger\" title=\"駁回假單\" data-toggle=\"modal\" data-target=\"#DisagreeLeave\" onclick=\"disagree(this)\">審核不通過</button>"),
                                ));
                            }
                        }
                        elseif($status["signing_status_3"]=="1")
                        {
                            //111
                            if($status["signing_status_4"]=="0")
                            {
                                if(in_array ("21" , $user_auth))    //18->審核4
                                {
                                    //1110
                                    $check="1";
                                    array_push($rowdata,array(
                                        'no'=>$status["no"],
                                        'leave_off_work_no'=>sprintf("<a>%s</a> &nbsp<button class=\"btn btn-outline-dark\" title=\"查看假單\" data-toggle=\"modal\" data-target=\"#CheckLeave\" onclick=\"check(this)\">查看詳情</button>",$name),
                                        'leave'=>$status["leave_off_work_no"],
                                        'depart_leave_unit_department'=>$status["depart_leave_unit_department"],
                                        'signing_status_1' =>"已審核通過",
                                        'signing_status_2' =>"已審核通過",
                                        'signing_status_3' =>"已審核通過",
                                        'signing_status_4'=>sprintf("<a>尚未審核</a> &nbsp<button class=\"btn btn-secondary\" title=\"審核假單\" onclick=\"post_check_status_4(this)\">審核通過</button>"),
                                        'name'=>$name,
                                        'category'=>$category,
                                        'reason'=>$reason,
                                        'start'=>$start,
                                        'end'=>$end,
                                        'leave_day'=>$leave_day,
                                        'leave_time'=>$leave_time,
                                        'created'=>$created,
                                        'disagree'=>sprintf("<button class=\"btn btn-danger\" title=\"駁回假單\" data-toggle=\"modal\" data-target=\"#DisagreeLeave\" onclick=\"disagree(this)\">審核不通過</button>"),
                                    ));
                                }
                            }
                        }
                        else
                        {
                            //3退件
                        }
                    }
                    else
                    {
                        //2退件
                    }
                }
                else
                {
                    //1退件
                }
            }
        }

        //dd($rowdata);
        if($msg!=null)
            return view("Person_ Supervisor_check_Leave_",['title'=>'主管審核','rowdata'=>$rowdata,'level'=>$level,'authority'=>$authority,'check'=>$check,'error_msg'=>$msg]);
        else
            return view("Person_ Supervisor_check_Leave_",['title'=>'主管審核','rowdata'=>$rowdata,'level'=>$level,'authority'=>$authority,'check'=>$check]);

    }
    //測試寄信
    public function sender_mail()
    {

//        Mail::send('LeaveEmail',['name' => 'value'],function ($message){
//           $message->to('f223145@gmail.com')->subject('請假審核');
//        });
        Mail::raw('請登入系統審視請假單，http://127.0.0.1:8000/',function($message){
            $message->to('54990881@ecom.com.tw')->subject('請假審核');
        });

//        $data=[
//            'mange'=>"周開屏",   //主管名字
//            'dart'=>"管理部",    //部門名稱
//            'name'=>"尤梅桂",     //請假員工名字
//            'category'=>"特休",     //請假假別
//            'reason'=>"至中國醫院",     //請假理由
//            'leave_time'=>"8",       //請假時長
//            'start_end'=>"2021/03/19 08:30"."-"."2021/03/19 17:30",   //請假期間
//        ];
//        $email="54990881@ecom.com.tw";
//        Mail::send('employee_mail',$data, function($message) use ($email) {
//            $message->to($email)->subject('差勤系統請假單審核');
//        });
//        Mail::raw( 'fe', function($message)
//        {
//            $message->to('f223145@gmail.com')->subject('請假審核通知');
//        });


//            $data=[
//                'mange'=>"dwfwe",   //主管名字
//                'dart'=>"dwfwe",    //部門名稱
//                'name'=>"dwfwe",     //請假員工名字
//                'category'=>"dwfwe",     //請假假別
//                'reason'=>"dwfwe",     //請假理由
//                'leave_time'=>"dwfwe",       //請假時長
//                'start_end'=>"dwfwe",   //請假期間
//                'url'=>"dwfwe",     //系統網址
//            ];
////            $email=$mailto["mail"];
//            Mail::send('employee_mail',$data, function($message) {
//                $message->to("f223145@gmail.com")->subject('差勤系統請假單審核');
//            });

//        $data=[
//            'mange'=>"主管名字",   //主管名字
//            'dart'=>"部門名稱",    //部門名稱
//            'name'=>"請假員工名字",     //請假員工名字
//            'category'=>"請假假別",     //請假假別
//            'reason'=>"請假理由",     //請假理由
//            'leave_time'=>"請假時長",       //請假時長
//            'start_end'=>"請假期間",   //請假期間
//            'url'=>"",     //系統網址
//        ];
//        Mail::send('employee_mail',$data, function($message) {
//            $message->to("f223145@gmail.com")->subject('差勤系統請假單審核');
//        });
        print("driver：".env("MAIL_DRIVER"));
        print(" ,host：".env("MAIL_HOST"));
        print(" ,port：".env("MAIL_PORT"));
        print(" ,username：".env("MAIL_USERNAME"));
        print(" ,password：".env("MAIL_PASSWORD"));
//        print(" ,encryption：".env("MAIL_ENCRYPTION"));
    }
    //修改審核狀態
    public function update_supervisorcheckleave(Request $request)
    {
        //藉由no取得第四層審核狀態
        $status_4="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/leave/signing/status/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $signstatus){
            if($signstatus["no"]==$request->no){
                $status_4=$signstatus["signing_status_4"];
            }
        }
        if(isset($request->status4))
            $status_4=$request->status4;
        //更新審核狀態
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/leave/signing/status/update", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST",
            "multipart",
            [
                [
                    'name'=>"no",
                    'contents'=>$request->no
                ],
                [
                    'name'=>"leave_off_work_no",
                    'contents'=>$request->leave
                ],
                [
                    'name'=>"depart_leave_unit_department",
                    'contents'=>$request->depart
                ],
                [
                    'name'=>"signing_status_1",
                    'contents'=>$request->status1
                ],
                [
                    'name'=>"signing_status_2",
                    'contents'=>$request->status2
                ],
                [
                    'name'=>"signing_status_3",
                    'contents'=>$request->status3
                ],
                [
                    'name'=>"signing_status_4",
                    'contents'=>$status_4
                ],
            ]);
        $jsondata=json_decode($res->getBody()->__toString(),true);
        $msg=$jsondata["Message"];
        $return_msg="";
        if(strpos($msg,"SigningStatus") !== false)
            $return_msg="審核成功";
        elseif(strpos($msg,"database") !== false)
            $return_msg="請假資料不存在";
        else
            $return_msg="審核失敗";
        //判斷目前審核狀態
        $check="0";
        if($request->status1=="1")
        {
            $check="1";
            if($request->status2=="1")
            {
                $check="2";
                if($request->status3=="1")
                {
                    $check="3";
                    if($status_4=="1")
                    {
                        $check="4";
                    }
                }
            }
        }
        //找出請假當事人
        $leave_personid="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
//        dd($jsondata);
        foreach ($jsondata["Data"] as $leave) {
            if ($leave["no"]==$request->leave)
                $leave_personid=$leave["person_id"];
        }
        //取的各層審核的人
        $check_1=array();
        $check_2=array();
        $check_3=array();
        $check_4=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user_authority) {
            if($user_authority["features_id"]=="18")
            {
                array_push( $check_1,$user_authority["user_id"]);
            }
            if($user_authority["features_id"]=="19")
            {
                array_push( $check_2,$user_authority["user_id"]);
            }
            if($user_authority["features_id"]=="20")
            {
                array_push( $check_3,$user_authority["user_id"]);
            }
            if($user_authority["features_id"]=="21")
            {
                array_push( $check_4,$user_authority["user_id"]);
            }
        }
        //找出審核人的mail、名字
        $mail=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            //目前狀態下一個審核人不同
            if($check=="1")
            {
                if(in_array ($user["id"] , $check_2))
                {
                    if($user["email"]!="")
                    {
                        array_push($mail,array(
                            "name"=>$user["name"],
                            'mail'=>$user["email"],
                        ));
                    }
                }
            }
            if($check=="2")
            {
                if(in_array ($user["id"] , $check_3))
                {
                    if($user["email"]!="")
                    {
                        array_push($mail,array(
                            "name"=>$user["name"],
                            'mail'=>$user["email"],
                        ));
                    }
                }
            }
            if($check=="3")
            {
                if($status_4=="0")
                {
                    if(in_array ($user["id"] , $check_4))
                    {
                        if($user["email"]!="")
                        {
                            array_push($mail,array(
                                "name"=>$user["name"],
                                'mail'=>$user["email"],
                            ));
                        }
                    }
                }
            }
            if($check=="4")
            {
                if($user["person_id"]==$leave_personid)
                {
                    if($user["email"]!="")
                    {
                        array_push($mail,array(
                            "name"=>$user["name"],
                            'mail'=>$user["email"],
                        ));
                    }
                }
            }
        }
        //mail需要的各種資料
        $department_id="";
        $person_id="";
        $category="";
        $reason="";
        $start="";
        $end="";
        $time="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $leave){
            if($request->leave==$leave["no"]){
                $department_id=$leave["depart_leave_unit_department"];
                $person_id=$leave["person_id"];
                $category=$leave["category"];
                $reason=$leave["reason"];
                $start=$leave["start"];
                $end=$leave["end"];
                $time=$leave["leave_time"];
            }
        }
        $name="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if ($user["person_id"] == $person_id) {
                $name = $user["name"];
            }
        }
        //找出部門名稱
        $department="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $departments) {
                if($department_id==$departments["no"])
                {
                    $department=$departments["department"];
                }
            }
        }
        //dd($department);
        //寄mail通知
        //dd($mail);
        if($check=="4")
        {
            //請假審核完成
            if(!is_null($mail))
            {
                foreach($mail as $mailto)
                {
                    $data=[
                        'mange'=>$mailto["name"],   //主管名字
                        'dart'=>$department,    //部門名稱
                        'name'=>$name,     //請假員工名字
                        'category'=>$category,     //請假假別
                        'reason'=>$reason,     //請假理由
                        'leave_time'=>$time,       //請假時長
                        'start_end'=>$start."-".$end,   //請假期間
                        'url'=>$_SERVER["HTTP_ORIGIN"],     //系統網址
                    ];
                    //dd($data);
                    $email=$mailto["mail"];
                    Mail::send('agree_mail',$data, function($message) use ($email) {
                        $message->to($email)->subject('差勤系統請假單審核');
                    });
                }
            }
        }
        else
        {
            if(!is_null($mail))
            {
                foreach($mail as $mailto)
                {
                    $data=[
                        'mange'=>$mailto["name"],   //主管名字
                        'dart'=>$department,    //部門名稱
                        'name'=>$name,     //請假員工名字
                        'category'=>$category,     //請假假別
                        'reason'=>$reason,     //請假理由
                        'leave_time'=>$time,       //請假時長
                        'start_end'=>$start."-".$end,   //請假期間
                        'url'=>$_SERVER["HTTP_ORIGIN"],     //系統網址
                    ];
                    //dd($data);
                    $email=$mailto["mail"];
                    Mail::send('employee_mail',$data, function($message) use ($email) {
                        $message->to($email)->subject('差勤系統請假單審核');
                    });
                }
            }
        }


        return redirect()->route('checkleave_index')->with(["msg" => $return_msg]);
    }
    //駁回假單
    public function disagree_leave(Request $request)
    {
        $no=$request->no;
        $leave="";
        $depart="";
        $status1="";
        $status2="";
        $status3="";
        $status4="";
        //找出對應資料
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/leave/signing/status/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $status){
            if($no==$status["no"])
            {
                $leave=$status["leave_off_work_no"];
                $depart=$status["depart_leave_unit_department"];
                //判斷是第幾層不同意
                if($status["signing_status_1"]=="1")
                {
                    if($status["signing_status_2"]=="1")
                    {
                        if($status["signing_status_3"]=="1")
                        {
                            $status1="1";
                            $status2="1";
                            $status3="1";
                            $status4=$request->disagree;
                        }
                        else
                        {
                            $status1="1";
                            $status2="1";
                            $status3=$request->disagree;
                            $status4=$status["signing_status_4"];
                        }
                    }
                    else
                    {
                        $status1="1";
                        $status2=$request->disagree;
                        $status3="0";
                        $status4=$status["signing_status_4"];
                    }
                }
                else
                {
                    $status1=$request->disagree;
                    $status2="0";
                    $status3="0";
                    $status4=$status["signing_status_4"];
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/leave/signing/status/update", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST",
            "multipart",
            [
                [
                    'name'=>"no",
                    'contents'=>$no
                ],
                [
                    'name'=>"leave_off_work_no",
                    'contents'=>$leave
                ],
                [
                    'name'=>"depart_leave_unit_department",
                    'contents'=>$depart
                ],
                [
                    'name'=>"signing_status_1",
                    'contents'=>$status1
                ],
                [
                    'name'=>"signing_status_2",
                    'contents'=>$status2
                ],
                [
                    'name'=>"signing_status_3",
                    'contents'=>$status3
                ],
                [
                    'name'=>"signing_status_4",
                    'contents'=>$status4
                ],
            ]);
        $jsondata=json_decode($res->getBody()->__toString(),true);
        $msg=$jsondata["Message"];
        $return_msg="";
        if(strpos($msg,"SigningStatus") !== false)
            $return_msg="審核成功";
        elseif(strpos($msg,"database") !== false)
            $return_msg="請假資料不存在";
        else
            $return_msg="審核失敗";
        //mail通知請假人
        //mail需要的各種資料
        $department_id="";
        $person_id="";
        $category="";
        $reason="";
        $start="";
        $end="";
        $time="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $leaves){
            if($leave==$leaves["no"]){
                $department_id=$leaves["depart_leave_unit_department"];
                $person_id=$leaves["person_id"];
                $category=$leaves["category"];
                $reason=$leaves["reason"];
                $start=$leaves["start"];
                $end=$leaves["end"];
                $time=$leaves["leave_time"];
            }
        }
        $name="";
        $mail="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if ($user["person_id"] == $person_id) {
                $name = $user["name"];
                if($user["email"]!="")
                {
                    $mail=$user["email"];
                }
            }
        }
        //找出部門名稱
        $department="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $departments) {
                if($department_id==$departments["no"])
                {
                    $department=$departments["department"];
                }
            }
        }

        $data=[
            'disagree_reason'=>$request->disagree,   //退件原因
            'mange'=>$name,   //主管名字
            'dart'=>$department,    //部門名稱
            'name'=>$name,     //請假員工名字
            'category'=>$category,     //請假假別
            'reason'=>$reason,     //請假理由
            'leave_time'=>$time,       //請假時長
            'start_end'=>$start."-".$end,   //請假期間
            'url'=>$_SERVER["HTTP_ORIGIN"],     //系統網址
        ];
        //dd($email);
        if($mail!="")
        {
            Mail::send('disagree_mail',$data, function($message) use ($mail) {
                $message->to($mail)->subject('差勤系統請假單審核');
            });

        }
        return redirect()->route('checkleave_index')->with(["msg" => $return_msg]);
    }

    //出差
    public function businesstrip_index(Request $request){
        $request->session()->all();
        $msg = request()->session()->get('msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $user_department="";
        $level="";
        $person_id="";
        $user_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $user_department=$user["department"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }

        $departments= array();
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $department) {
                array_push( $departments, array(
                    "no" => $department["no"],
                    "department" => $department["department"],
                ));
                if($department["no"]==$user_department)
                    $department_name=$department["department"];
            }
        }

        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }
        $person_name="";
        $persons=array();
        $annual_leave_hour=0;
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $person){
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }

                if($level=="3"or$level=="4")
                {
                    array_push($persons,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }
                else
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
            }
        }

        $today=date("Y/m/d");
        $rowdata=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $leave){
                $start=substr($leave["start"],0,10);
                $personname="";
                foreach ($persons as $person){
                    switch ($leave["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $d_name="";
                foreach($departments as $department)
                {
                    if($leave["depart_leave_unit_department"]==$department["no"])
                        $d_name=$department["department"];
                }
                if($leave["category"]=="出差")
                {
                    if(in_array ($leave["person_id"] , $group_persons) and  strtotime($today)<=strtotime($start))
                    {
                        array_push($rowdata,array(
                            'no'=>$leave["no"],
                            'id'=>$leave["person_id"],
                            'name'=>$personname,
                            'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                            'department_name'=>$d_name,
                            'category'=>$leave["category"],
                            'reason'=>$leave["reason"],
                            'start'=>$leave["start"],
                            'end'=>$leave["end"],
                            'leave_day'=>$leave["leave_day"],
                            'leave_time'=>$leave["leave_time"],
                            'substitute'=>$leave["substitute"],
                            'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                            'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改出差\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>"),
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除出差\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                        ));
                    }
                }
            }
        }

        $check=0;
        if($msg!=null)
            return view("Person_Employee_Business_Trip",['title'=>'員工出差','level'=>$level,'rowdata'=>$rowdata,'person_id'=>$person_id,'person_name'=>$person_name,'user_department'=>$user_department,'department_name'=>$department_name,'persons'=>$persons,'departments'=>$departments,'authority'=>$authority,'error_msg'=>$msg,'check'=>$check]);
        else
            return view("Person_Employee_Business_Trip",['title'=>'員工出差','level'=>$level,'rowdata'=>$rowdata,'person_id'=>$person_id,'person_name'=>$person_name,'user_department'=>$user_department,'department_name'=>$department_name,'persons'=>$persons,'departments'=>$departments,'authority'=>$authority,'check'=>$check]);

    }
    //新增出差
    public function post_businesstrip(Request $request){
        if ($request->hasFile("upload_file")){
            $path=$request->file("upload_file")->store("upload_file");
            $file=fopen(Storage::disk('local')->getDriver()->getAdapter()->getPathPrefix().$path,'r');
        }
        else
        {
            $file="";
        }
        //新增假單(出差)
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/insert", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST",
            "multipart",
            [
                [
                    'name'=>"depart_leave_unit_department",
                    'contents'=>$request->department
                ],
                [
                    'name'=>"person_id",
                    'contents'=>$request->person
                ],
                [
                    'name'=>"category",
                    'contents'=>$request->category
                ],
                [
                    'name'=>"reason",
                    'contents'=>$request->reason
                ],
                [
                    'name'=>"start",
                    'contents'=>$request->start_time
                ],
                [
                    'name'=>"end",
                    'contents'=>$request->end_time
                ],
                [
                    'name'=>"leave_day",
                    'contents'=>$request->leave_day
                ],
                [
                    'name'=>"leave_time",
                    'contents'=>$request->leave_time
                ],
                [
                    'name'=>"substitute",
                    'contents'=>$request->substitute
                ],
                [
                    'Content-type' => 'multipart/form-data',
                    'name'     => 'upload_file',
                    'contents' => $file,
                    'headers' => ['Content-Type' => 'image/jpeg']
                ],
            ]);
        $jsondata=json_decode($res->getBody()->__toString(),true);
        $msg=$jsondata["Message"];
        $return_msg="";
        if(strpos($msg,"inserted") !== false)
            $return_msg="新增出差成功";
        elseif(strpos($msg,"database") !== false)
            $return_msg="出差資料已存在";
        else
            $return_msg="新增出差失敗";
        return redirect()->route('businesstrip_index')->with(["msg" => $return_msg]);
    }
    //修改出差
    public function update_businesstrip(Request $request){
        if ($request->hasFile("upload_file")){
            $path=$request->file("upload_file")->store("upload_file");
            $file=fopen(Storage::disk('local')->getDriver()->getAdapter()->getPathPrefix().$path,'r');
        }
        else
        {
            $file="";
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/update", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST",
            "multipart",
            [
                [
                    'name'=>"no",
                    'contents'=>$request->no
                ],
                [
                    'name'=>"depart_leave_unit_department",
                    'contents'=>$request->department
                ],
                [
                    'name'=>"person_id",
                    'contents'=>$request->person
                ],
                [
                    'name'=>"category",
                    'contents'=>$request->category
                ],
                [
                    'name'=>"reason",
                    'contents'=>$request->reason
                ],
                [
                    'name'=>"start",
                    'contents'=>$request->start_time
                ],
                [
                    'name'=>"end",
                    'contents'=>$request->end_time
                ],
                [
                    'name' => "leave_day",
                    'contents' => $request->leave_day
                ],
                [
                    'name'=>"leave_time",
                    'contents'=>$request->leave_time
                ],
                [
                    'name'=>"substitute",
                    'contents'=>$request->substitute
                ],
                [
                    'Content-type' => 'multipart/form-data',
                    'name'     => 'upload_file',
                    'contents' => $file,
                    'headers' => ['Content-Type' => 'image/jpeg']
                ],
            ]);
        $jsondata=json_decode($res->getBody()->__toString(),true);
        $msg=$jsondata["Message"];
        $return_msg="";
        if(strpos($msg,"failed") !== false)
            $return_msg="修改出差失敗";
        elseif(strpos($msg,"database") !== false)
        {
            if(strpos($msg,"is") !== false)
                $return_msg="出差資料已有相同時間";
            else
                $return_msg="出差資料不存在";
        }
        else
            $return_msg="修改出差成功";
        return redirect()->route('businesstrip_index')->with(["msg" => $return_msg]);
    }
    //刪除出差
    public function delete_businesstrip(Request $request){
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/leave/delete", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST",
            "multipart",
            [
                [
                    'name'=>"no",
                    "contents"=>$request->selectedId
                ],
            ]
        );
        $jsondata=json_decode($res->getBody()->__toString(),true);
        $msg=$jsondata["Message"];
        $return_msg="";
        if(strpos($msg,"deleted") !== false)
            $return_msg="刪除出差成功";
        elseif(strpos($msg,"database") !== false)
            $return_msg="出差資料不存在";
        else
            $return_msg="刪除出差失敗";
        return redirect()->route('businesstrip_index')->with(["msg" => $return_msg]);
    }
    //查看所有出差紀錄
    public function businesstrip_all(Request $request){
        $request->session()->all();
        $msg = request()->session()->get('error_msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $user_department="";
        $level="";
        $person_id="";
        $user_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $user_department=$user["department"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }

        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }


        $departments= array();
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $department) {
                array_push( $departments, array(
                    "no" => $department["no"],
                    "department" => $department["department"],
                ));
                if($department["no"]==$user_department)
                    $department_name=$department["department"];
            }
        }

        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }

        $person_name="";
        $persons=array();
        $annual_leave_hour=0;
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $person){
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }
                if($level=="3"or$level=="4")
                {
                    array_push($persons,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }
                elseif(in_array ("18" , $user_auth))
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                else
                {
                    if($person["ID"]==$person_id)
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
            }
        }

        $rowdata=array();
        $personname="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $leave){
                foreach ($persons as $person){
                    switch ($leave["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $d_name="";
                foreach($departments as $department)
                {
                    if($leave["depart_leave_unit_department"]==$department["no"])
                        $d_name=$department["department"];
                }
                if($level=="3" or $level=="4")
                {
                    if($leave["category"]=="出差")
                    {
                        array_push($rowdata,array(
                            'no'=>$leave["no"],
                            'id'=>$leave["person_id"],
                            'name'=>$personname,
                            'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                            'department_name'=>$d_name,
                            'category'=>$leave["category"],
                            'reason'=>$leave["reason"],
                            'start'=>$leave["start"],
                            'end'=>$leave["end"],
                            'leave_day'=>$leave["leave_day"],
                            'leave_time'=>$leave["leave_time"],
                            'substitute'=>$leave["substitute"],
                            'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                            'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改假單\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>"),
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                        ));
                    }
                }
                elseif(in_array ("18" , $user_auth))
                {
                    if(in_array ($leave["person_id"] , $group_persons) and $leave["category"]=="出差")
                    {
                        array_push($rowdata,array(
                            'no'=>$leave["no"],
                            'id'=>$leave["person_id"],
                            'name'=>$personname,
                            'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                            'department_name'=>$d_name,
                            'category'=>$leave["category"],
                            'reason'=>$leave["reason"],
                            'start'=>$leave["start"],
                            'end'=>$leave["end"],
                            'leave_day'=>$leave["leave_day"],
                            'leave_time'=>$leave["leave_time"],
                            'substitute'=>$leave["substitute"],
                            'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                            'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改假單\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>"),
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除假單\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                        ));
                    }
                }
                else
                {
                    if($leave["category"]=="出差")
                    {
                        if($leave["person_id"]==$person_id and $leave["category"]=="出差")
                        {
                            array_push($rowdata,array(
                                'no'=>$leave["no"],
                                'id'=>$leave["person_id"],
                                'name'=>$personname,
                                'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                'department_name'=>$d_name,
                                'category'=>$leave["category"],
                                'reason'=>$leave["reason"],
                                'start'=>$leave["start"],
                                'end'=>$leave["end"],
                                'leave_day'=>$leave["leave_day"],
                                'leave_time'=>$leave["leave_time"],
                                'substitute'=>$leave["substitute"],
                                'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改出差\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>"),
                                'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除出差\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                            ));
                        }
                    }
                }
            }
        }

        $check=0;
        return view("Person_Employee_Business_Trip",['title'=>'員工出差','level'=>$level,'rowdata'=>$rowdata,'person_id'=>$person_id,'person_name'=>$person_name,'user_department'=>$user_department,'department_name'=>$department_name,'persons'=>$persons,'departments'=>$departments,'authority'=>$authority,'check'=>$check]);
    }
    //搜尋出差
    public function select_businesstrip(Request $request)
    {
        // 表單傳值回帶
        session()->flashInput($request->input());
        $request->session()->all();
        $msg = request()->session()->get('error_msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $user_department="";
        $level="";
        $person_id="";
        $user_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $user_department=$user["department"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }

        $departments= array();
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $department) {
                array_push( $departments, array(
                    "no" => $department["no"],
                    "department" => $department["department"],
                ));
                if($department["no"]==$user_department)
                    $department_name=$department["department"];
            }
        }
        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }

        $person_name="";
        $persons=array();
        $annual_leave_hour=0;
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person){
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }
                if($level=="3"or$level=="4")
                {
                    array_push($persons,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }
                elseif(in_array ("18" , $user_auth))
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                else
                {
                    if($person["ID"]==$person_id)
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
            }
        }

        $rowdata=array();
        $personname="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $leave){
                $start=substr($leave["start"],0,10);
                $end=substr($leave["end"],0,10);

                foreach ($persons as $person){
                    switch ($leave["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $d_name="";
                foreach($departments as $department)
                {
                    if($leave["depart_leave_unit_department"]==$department["no"])
                        $d_name=$department["department"];
                }

                if($start==$end)
                {
                    if((strtotime($request->start)<=strtotime($start) and strtotime($end)<=strtotime($request->end)))
                    {
                        if($level=="3" or $level=="4")
                        {
                            if($leave["category"]=="出差")
                            {
                                array_push($rowdata,array(
                                    'no'=>$leave["no"],
                                    'id'=>$leave["person_id"],
                                    'name'=>$personname,
                                    'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                    'department_name'=>$d_name,
                                    'category'=>$leave["category"],
                                    'reason'=>$leave["reason"],
                                    'start'=>$leave["start"],
                                    'end'=>$leave["end"],
                                    'leave_day'=>$leave["leave_day"],
                                    'leave_time'=>$leave["leave_time"],
                                    'substitute'=>$leave["substitute"],
                                    'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                    'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改出差\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>"),
                                    'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除出差\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                                ));
                            }
                        }
                        else
                        {
                            if($leave["person_id"]==$person_id and $leave["category"]=="出差")
                            {
                                array_push($rowdata,array(
                                    'no'=>$leave["no"],
                                    'id'=>$leave["person_id"],
                                    'name'=>$personname,
                                    'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                    'department_name'=>$d_name,
                                    'category'=>$leave["category"],
                                    'reason'=>$leave["reason"],
                                    'start'=>$leave["start"],
                                    'end'=>$leave["end"],
                                    'leave_day'=>$leave["leave_day"],
                                    'leave_time'=>$leave["leave_time"],
                                    'substitute'=>$leave["substitute"],
                                    'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                    'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改出差\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>"),
                                    'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除出差\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                                ));
                            }
                        }
                    }
                }
                else
                {
                    $check="0";
                    $s_time=$leave["start"];
                    $thisday=$start;
                    $end_day=$end;
                    while($thisday!=$end_day)
                    {
                        if(strtotime($request->start)<=strtotime($thisday) and strtotime($thisday)<=strtotime($request->end))
                        {
                            $check="1";
                        }
                        $thisday=date("Y/m/d", strtotime($thisday."+1 day"));
                        if($thisday!=$end_day)
                        {
                            while(date("w", strtotime($thisday))=="6" or date("w", strtotime($thisday))=="0")
                            {
                                $thisday=date("Y/m/d", strtotime($thisday."+1 day"));
                            }
                        }
                    }
                    if(strtotime($request->start)<=strtotime($thisday) and strtotime($thisday)<=strtotime($request->end))
                    {
                        $check="1";
                    }
                    if($check=="1")
                    {
                        if($level=="3" or $level=="4")
                        {
                            if($leave["category"]=="出差")
                            {
                                array_push($rowdata,array(
                                    'no'=>$leave["no"],
                                    'id'=>$leave["person_id"],
                                    'name'=>$personname,
                                    'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                    'department_name'=>$d_name,
                                    'category'=>$leave["category"],
                                    'reason'=>$leave["reason"],
                                    'start'=>$leave["start"],
                                    'end'=>$leave["end"],
                                    'leave_day'=>$leave["leave_day"],
                                    'leave_time'=>$leave["leave_time"],
                                    'substitute'=>$leave["substitute"],
                                    'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                    'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改出差\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>"),
                                    'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除出差\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                                ));
                            }
                        }
                        else
                        {
                            if($leave["person_id"]==$person_id and $leave["category"]=="出差")
                            {
                                array_push($rowdata,array(
                                    'no'=>$leave["no"],
                                    'id'=>$leave["person_id"],
                                    'name'=>$personname,
                                    'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                    'department_name'=>$d_name,
                                    'category'=>$leave["category"],
                                    'reason'=>$leave["reason"],
                                    'start'=>$leave["start"],
                                    'end'=>$leave["end"],
                                    'leave_day'=>$leave["leave_day"],
                                    'leave_time'=>$leave["leave_time"],
                                    'substitute'=>$leave["substitute"],
                                    'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                    'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改出差\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>"),
                                    'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除出差\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                                ));
                            }
                        }
                    }
                }
            }
        }

        $check=0;
        return view("Person_Employee_Business_Trip",['title'=>'員工出差','level'=>$level,'rowdata'=>$rowdata,'person_id'=>$person_id,'person_name'=>$person_name,'user_department'=>$user_department,'department_name'=>$department_name,'persons'=>$persons,'departments'=>$departments,'authority'=>$authority,'check'=>$check]);

    }
    //搜尋某人出差
    public function select_businesstrip_personal(Request $request)
    {
        // 表單傳值回帶
        session()->flashInput($request->input());
        $request->session()->all();
        $msg = request()->session()->get('error_msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $user_department="";
        $level="";
        $person_id="";
        $user_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $user_department=$user["department"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }


        $departments= array();
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $department) {
                array_push( $departments, array(
                    "no" => $department["no"],
                    "department" => $department["department"],
                ));
                if($department["no"]==$user_department)
                    $department_name=$department["department"];
            }
        }
        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }

        $person_name="";
        $persons=array();
        $annual_leave_hour=0;
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person){
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }
                if($level=="3"or$level=="4")
                {
                    array_push($persons,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }
                elseif(in_array ("18" , $user_auth))
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                else
                {
                    if($person["ID"]==$person_id)
                    {
                        array_push($persons,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
            }
        }

        $rowdata=array();
        $personname="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/leave/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $leave){
                $start=substr($leave["start"],0,10);
                $end=substr($leave["end"],0,10);
                //dd($end);
                if($leave["person_id"]==$request->person)
                {
                }
                else
                    continue 1;

                foreach ($persons as $person){
                    switch ($leave["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $d_name="";
                foreach($departments as $department)
                {
                    if($leave["depart_leave_unit_department"]==$department["no"])
                        $d_name=$department["department"];
                }

                if($start==$end)
                {
                    if((strtotime($request->start)<=strtotime($start) and strtotime($end)<=strtotime($request->end)))
                    {
                        if($leave["category"]=="出差")
                        {
                            array_push($rowdata,array(
                                'no'=>$leave["no"],
                                'id'=>$leave["person_id"],
                                'name'=>$personname,
                                'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                'department_name'=>$d_name,
                                'category'=>$leave["category"],
                                'reason'=>$leave["reason"],
                                'start'=>$leave["start"],
                                'end'=>$leave["end"],
                                'leave_day'=>$leave["leave_day"],
                                'leave_time'=>$leave["leave_time"],
                                'substitute'=>$leave["substitute"],
                                'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改出差\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>"),
                                'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除出差\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                            ));
                        }
                    }
                }
                else
                {
                    $check="0";
                    $s_time=$leave["start"];
                    $thisday=$start;
                    $end_day=$end;
                    while($thisday!=$end_day)
                    {
                        if(strtotime($request->start)<=strtotime($thisday) and strtotime($thisday)<=strtotime($request->end))
                        {
                            $check="1";
                        }
                        $thisday=date("Y/m/d", strtotime($thisday."+1 day"));
                        if($thisday!=$end_day)
                        {
                            while(date("w", strtotime($thisday))=="6" or date("w", strtotime($thisday))=="0")
                            {
                                $thisday=date("Y/m/d", strtotime($thisday."+1 day"));
                            }
                        }
                    }
                    if(strtotime($request->start)<=strtotime($thisday) and strtotime($thisday)<=strtotime($request->end))
                    {
                        $check="1";
                    }
                    if($check=="1")
                    {
                        if($leave["category"]=="出差")
                        {
                            array_push($rowdata,array(
                                'no'=>$leave["no"],
                                'id'=>$leave["person_id"],
                                'name'=>$personname,
                                'depart_leave_unit_department'=>$leave["depart_leave_unit_department"],
                                'department_name'=>$d_name,
                                'category'=>$leave["category"],
                                'reason'=>$leave["reason"],
                                'start'=>$leave["start"],
                                'end'=>$leave["end"],
                                'leave_day'=>$leave["leave_day"],
                                'leave_time'=>$leave["leave_time"],
                                'substitute'=>$leave["substitute"],
                                'upload_file'=>sprintf("<img class='faceimg' src='data:image/jpeg;base64, %s'>", $leave["upload_file"]),
                                'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改出差\" data-toggle=\"modal\" data-target=\"#ModifyLeave\" onclick=\"leave_modify(this)\">修改</button>"),
                                'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除出差\" onclick=\"post_delete_leave(this)\">刪除</button>"),
                            ));
                        }
                    }
                }
            }
        }

        $check=1;
        return view("Person_Employee_Business_Trip",['title'=>'員工出差','level'=>$level,'rowdata'=>$rowdata,'person_id'=>$person_id,'person_name'=>$person_name,'user_department'=>$user_department,'department_name'=>$department_name,'persons'=>$persons,'departments'=>$departments,'authority'=>$authority,'check'=>$check]);

    }

    //加班首頁
    public function overtime_index(Request $request)
    {
        $request->session()->all();
        $msg = request()->session()->get('msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $user_department="";
        $level="";
        $person_id="";
        $user_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $user_department=$user["department"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                }
            }
        }

        $departments= array();
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $department) {
                array_push( $departments, array(
                    "no" => $department["no"],
                    "department" => $department["department"],
                ));
                if($department["no"]==$user_department)
                    $department_name=$department["department"];
            }
        }

        $department_personid=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["department"]==$user_department)
            {
                array_push($department_personid,array(
                    'name'=>$user["name"],
                    'id'=>$user["person_id"]
                ));
            }
        }

        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }

        $person_name="";
        $persons=array();
        $person_1=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person){
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }
                if($level=="2")
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($person_1,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                elseif($level=="1")
                {
                    if($person["ID"]==$person_id)
                    {
                        array_push($person_1,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                else
                {
                    array_push($person_1,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }

                array_push($persons,array(
                    'name'=>$person["Name"],
                    'id'=>$person["ID"]
                ));
            }
        }

        $today=date("Y/m/d");
        //dd($today);
        $rowdata=array();
        $personname="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/overtime/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
//        dd($jsondata);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $overtime){
                foreach ($persons as $person){
                    switch ($overtime["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $d_name="";
                foreach($departments as $department)
                {
                    if($overtime["department_id"]==$department["no"])
                        $d_name=$department["department"];
                }
                $is_key="";
                if($overtime["is_key"]==true)
                    $is_key="有";
                else
                    $is_key="沒有";
                $status="";
                if($overtime["status"]=="1")
                    $status="審核通過";
                elseif($overtime["status"]=="0")
                    $status="審核中";
                else
                    $status="已退件";
                $start_time=$overtime["date"]." ".$overtime["start"];
                $end_time=$overtime["date"]." ".$overtime["end"];
                //dd(strtotime($overtime["date"]));
                if($overtime["person_id"]==$person_id and strtotime($today)<=strtotime($overtime["date"]))
                {
                    array_push($rowdata,array(
                        'no'=>$overtime["no"],
                        'id'=>$overtime["person_id"],
                        'name'=>$personname,
                        'department_id'=>$overtime["department_id"],
                        'department_name'=>$d_name,
                        'date'=>$overtime["date"],
                        'start'=>$overtime["start"],
                        'start_time'=>$start_time,
                        'end_time'=>$end_time,
                        'end'=>$overtime["end"],
                        'hour'=>$overtime["hour"],
                        'day_category'=>$overtime["day_category"],
                        'reason'=>$overtime["reason"],
                        'is_key'=>$is_key,
                        'status'=>$status,
                        'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改加班\" data-toggle=\"modal\" data-target=\"#ModifyOvertime\" onclick=\"overtime_modify(this)\">修改</button>"),
                        'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除加班\" onclick=\"delete_overtime(this)\">刪除</button>"),
                        'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出加班\" onclick=\"overtime_word(this)\">匯出</button>"),
                    ));
                }
                elseif(strtotime($today)<=strtotime($overtime["date"]))
                {
                    array_push($rowdata,array(
                        'no'=>$overtime["no"],
                        'id'=>$overtime["person_id"],
                        'name'=>$personname,
                        'department_id'=>$overtime["department_id"],
                        'department_name'=>$d_name,
                        'date'=>$overtime["date"],
                        'start'=>$overtime["start"],
                        'start_time'=>$start_time,
                        'end_time'=>$end_time,
                        'end'=>$overtime["end"],
                        'hour'=>$overtime["hour"],
                        'day_category'=>$overtime["day_category"],
                        'reason'=>$overtime["reason"],
                        'is_key'=>$is_key,
                        'status'=>$status,
                        'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改加班\" data-toggle=\"modal\" data-target=\"#ModifyOvertime\" onclick=\"overtime_modify(this)\" disabled>修改</button>"),
                        'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除加班\" onclick=\"delete_overtime(this)\" disabled>刪除</button>"),
                        'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出加班\" onclick=\"overtime_word(this)\" disabled>匯出</button>"),
                    ));
                }

            }
        }

        //超過5：30不能申請
        date_default_timezone_set("Asia/Taipei");
        $checkDay = date('Y-m-d ',time());
        $checkTime=strtotime($checkDay."17:30:00");
        $this_time =  time();
        if($this_time>$checkTime)
            $check="超過";
        else
            $check="沒超過";

        //判斷是否為全部資料
        $type="1";
        $check_c=0;
        //dd($check);
        if($msg!=null)
            return view("Person_Overtime",['title'=>'員工加班','level'=>$level,'rowdata'=>$rowdata,'person_id'=>$person_id,'person_name'=>$person_name,'user_department'=>$user_department,'department_name'=>$department_name,'persons'=>$person_1,'departments'=>$departments,'authority'=>$authority,'check'=>$check,'error_msg'=>$msg,'type'=>$type,'check_c'=>$check_c]);
        else
            return view("Person_Overtime",['title'=>'員工加班','level'=>$level,'rowdata'=>$rowdata,'person_id'=>$person_id,'person_name'=>$person_name,'user_department'=>$user_department,'department_name'=>$department_name,'persons'=>$person_1,'departments'=>$departments,'authority'=>$authority,'check'=>$check,'type'=>$type,'check_c'=>$check_c]);
    }
    //查看所有加班紀錄
    public function overtime_all(Request $request)
    {
        $request->session()->all();
        $msg = request()->session()->get('error_msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $user_department="";
        $level="";
        $person_id="";
        $user_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $user_department=$user["department"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }

        $departments= array();
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $department) {
                array_push( $departments, array(
                    "no" => $department["no"],
                    "department" => $department["department"],
                ));
                if($department["no"]==$user_department)
                    $department_name=$department["department"];
            }
        }
        $department_personid=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["department"]==$user_department)
            {
                array_push($department_personid,array(
                    'name'=>$user["name"],
                    'id'=>$user["person_id"]
                ));
            }
        }
        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }
        $person_name="";
        $persons=array();
        $person_1=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person){
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }
                if($level=="2")
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($person_1,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                elseif($level=="1")
                {
                    if($person["ID"]==$person_id)
                    {
                        array_push($person_1,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                else
                {
                    array_push($person_1,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }
                array_push($persons,array(
                    'name'=>$person["Name"],
                    'id'=>$person["ID"]
                ));
            }
        }

        $rowdata=array();
        $personname="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/overtime/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $overtime){
                foreach ($persons as $person){
                    switch ($overtime["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $d_name="";
                foreach($departments as $department)
                {
                    if($overtime["department_id"]==$department["no"])
                        $d_name=$department["department"];
                }
                $is_key="";
                if($overtime["is_key"]==true)
                    $is_key="有";
                else
                    $is_key="沒有";
                $status="";
                if($overtime["status"]=="1")
                    $status="審核通過";
                elseif($overtime["status"]=="0")
                    $status="審核中";
                else
                    $status="已退件";
                $start_time=$overtime["date"]." ".$overtime["start"];
                $end_time=$overtime["date"]." ".$overtime["end"];
                if($level=="3"or$level=="4")
                {
                    array_push($rowdata,array(
                        'no'=>$overtime["no"],
                        'id'=>$overtime["person_id"],
                        'name'=>$personname,
                        'department_id'=>$overtime["department_id"],
                        'department_name'=>$d_name,
                        'date'=>$overtime["date"],
                        'start'=>$overtime["start"],
                        'start_time'=>$start_time,
                        'end_time'=>$end_time,
                        'end'=>$overtime["end"],
                        'hour'=>$overtime["hour"],
                        'day_category'=>$overtime["day_category"],
                        'reason'=>$overtime["reason"],
                        'is_key'=>$is_key,
                        'status'=>$status,
                        'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改加班\" data-toggle=\"modal\" data-target=\"#ModifyOvertime\" onclick=\"overtime_modify(this)\" >修改</button>"),
                        'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除加班\" onclick=\"delete_overtime(this)\" >刪除</button>"),
                        'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出加班\" onclick=\"overtime_word(this)\" >匯出</button>"),
                    ));
                }
                elseif(in_array ("23" , $user_auth))
                {
                    if(in_array ($overtime["person_id"] , $group_persons))
                    {
                        array_push($rowdata,array(
                            'no'=>$overtime["no"],
                            'id'=>$overtime["person_id"],
                            'name'=>$personname,
                            'department_id'=>$overtime["department_id"],
                            'department_name'=>$d_name,
                            'date'=>$overtime["date"],
                            'start'=>$overtime["start"],
                            'start_time'=>$start_time,
                            'end_time'=>$end_time,
                            'end'=>$overtime["end"],
                            'hour'=>$overtime["hour"],
                            'day_category'=>$overtime["day_category"],
                            'reason'=>$overtime["reason"],
                            'is_key'=>$is_key,
                            'status'=>$status,
                            'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改加班\" data-toggle=\"modal\" data-target=\"#ModifyOvertime\" onclick=\"overtime_modify(this)\">修改</button>"),
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除加班\" onclick=\"delete_overtime(this)\">刪除</button>"),
                            'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出加班\" onclick=\"overtime_word(this)\">匯出</button>"),
                        ));
                    }
                    else
                    {
                        array_push($rowdata,array(
                            'no'=>$overtime["no"],
                            'id'=>$overtime["person_id"],
                            'name'=>$personname,
                            'department_id'=>$overtime["department_id"],
                            'department_name'=>$d_name,
                            'date'=>$overtime["date"],
                            'start'=>$overtime["start"],
                            'start_time'=>$start_time,
                            'end_time'=>$end_time,
                            'end'=>$overtime["end"],
                            'hour'=>$overtime["hour"],
                            'day_category'=>$overtime["day_category"],
                            'reason'=>$overtime["reason"],
                            'is_key'=>$is_key,
                            'status'=>$status,
                            'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改加班\" data-toggle=\"modal\" data-target=\"#ModifyOvertime\" onclick=\"overtime_modify(this)\" disabled>修改</button>"),
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除加班\" onclick=\"delete_overtime(this)\" disabled>刪除</button>"),
                            'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出加班\" onclick=\"overtime_word(this)\" disabled>匯出</button>"),
                        ));
                    }
                }
                else
                {
                    if($overtime["person_id"]==$person_id)
                    {
                        array_push($rowdata,array(
                            'no'=>$overtime["no"],
                            'id'=>$overtime["person_id"],
                            'name'=>$personname,
                            'department_id'=>$overtime["department_id"],
                            'department_name'=>$d_name,
                            'date'=>$overtime["date"],
                            'start'=>$overtime["start"],
                            'start_time'=>$start_time,
                            'end_time'=>$end_time,
                            'end'=>$overtime["end"],
                            'hour'=>$overtime["hour"],
                            'day_category'=>$overtime["day_category"],
                            'reason'=>$overtime["reason"],
                            'is_key'=>$is_key,
                            'status'=>$status,
                            'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改加班\" data-toggle=\"modal\" data-target=\"#ModifyOvertime\" onclick=\"overtime_modify(this)\">修改</button>"),
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除加班\" onclick=\"delete_overtime(this)\">刪除</button>"),
                            'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出加班\" onclick=\"overtime_word(this)\">匯出</button>"),
                        ));
                    }
                    else
                    {
                        array_push($rowdata,array(
                            'no'=>$overtime["no"],
                            'id'=>$overtime["person_id"],
                            'name'=>$personname,
                            'department_id'=>$overtime["department_id"],
                            'department_name'=>$d_name,
                            'date'=>$overtime["date"],
                            'start'=>$overtime["start"],
                            'start_time'=>$start_time,
                            'end_time'=>$end_time,
                            'end'=>$overtime["end"],
                            'hour'=>$overtime["hour"],
                            'day_category'=>$overtime["day_category"],
                            'reason'=>$overtime["reason"],
                            'is_key'=>$is_key,
                            'status'=>$status,
                            'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改加班\" data-toggle=\"modal\" data-target=\"#ModifyOvertime\" onclick=\"overtime_modify(this)\" disabled>修改</button>"),
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除加班\" onclick=\"delete_overtime(this)\" disabled>刪除</button>"),
                            'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出加班\" onclick=\"overtime_word(this)\" disabled>匯出</button>"),
                        ));
                    }
                }
            }
        }

        //超過5:30不能申請
      date_default_timezone_set("Asia/Taipei");
        $checkDay = date('Y-m-d ',time());
        $checkTime=strtotime($checkDay."17:30:00");
        $this_time =  time();
        if($this_time>$checkTime)
            $check="超過";
        else
            $check="沒超過";
        //判斷是否為全部資料
        $type="2";
//        dd($rowdata);
        $check_c=0;
        return view("Person_Overtime",['title'=>'員工加班','level'=>$level,'rowdata'=>$rowdata,'person_id'=>$person_id,'person_name'=>$person_name,'user_department'=>$user_department,'department_name'=>$department_name,'persons'=>$person_1,'departments'=>$departments,'authority'=>$authority,'check'=>$check,'type'=>$type,'check_c'=>$check_c]);
    }
    //查詢加班記錄
    public function select_overtime(Request $request)
    {
        // 表單傳值回帶
        session()->flashInput($request->input());
        $request->session()->all();
        $msg = request()->session()->get('error_msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $user_department="";
        $level="";
        $person_id="";
        $user_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $user_department=$user["department"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }


        $departments= array();
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $department) {
                array_push( $departments, array(
                    "no" => $department["no"],
                    "department" => $department["department"],
                ));
                if($department["no"]==$user_department)
                    $department_name=$department["department"];
            }
        }
        $department_personid=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["department"]==$user_department)
            {
                array_push($department_personid,array(
                    'name'=>$user["name"],
                    'id'=>$user["person_id"]
                ));
            }
        }
        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }
        $person_name="";
        $persons=array();
        $person_1=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person){
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }
                if($level=="2")
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($person_1,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                elseif($level=="1")
                {
                    if($person["ID"]==$person_id)
                    {
                        array_push($person_1,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                else
                {
                    array_push($person_1,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }
                array_push($persons,array(
                    'name'=>$person["Name"],
                    'id'=>$person["ID"]
                ));
            }
        }

        $rowdata=array();
        $personname="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/overtime/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $overtime){
                $start=$overtime["date"];
                $end=$overtime["date"];
                if(strtotime($request->start)<=strtotime($start) and strtotime($request->end)>=strtotime($end))
                {
                }
                else
                    continue 1;
                foreach ($persons as $person){
                    switch ($overtime["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $d_name="";
                foreach($departments as $department)
                {
                    if($overtime["department_id"]==$department["no"])
                        $d_name=$department["department"];
                }
                $is_key="";
                if($overtime["is_key"]==true)
                    $is_key="有";
                else
                    $is_key="沒有";
                $status="";
                if($overtime["status"]=="1")
                    $status="審核通過";
                elseif($overtime["status"]=="0")
                    $status="審核中";
                else
                    $status="已退件";
                $start_time=$overtime["date"]." ".$overtime["start"];
                $end_time=$overtime["date"]." ".$overtime["end"];
                if($level=="3" or $level=="4")
                {
                    array_push($rowdata,array(
                        'no'=>$overtime["no"],
                        'id'=>$overtime["person_id"],
                        'name'=>$personname,
                        'department_id'=>$overtime["department_id"],
                        'department_name'=>$d_name,
                        'date'=>$overtime["date"],
                        'start'=>$overtime["start"],
                        'start_time'=>$start_time,
                        'end_time'=>$end_time,
                        'end'=>$overtime["end"],
                        'hour'=>$overtime["hour"],
                        'day_category'=>$overtime["day_category"],
                        'reason'=>$overtime["reason"],
                        'is_key'=>$is_key,
                        'status'=>$status,
                        'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改加班\" data-toggle=\"modal\" data-target=\"#ModifyOvertime\" onclick=\"overtime_modify(this)\">修改</button>"),
                        'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除加班\" onclick=\"delete_overtime(this)\">刪除</button>"),
                        'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出加班\" onclick=\"overtime_word(this)\">匯出</button>"),
                    ));
                }
                elseif(in_array ("23" , $user_auth))
                {
                    if(in_array ($overtime["person_id"] , $group_persons))
                    {
                        array_push($rowdata,array(
                            'no'=>$overtime["no"],
                            'id'=>$overtime["person_id"],
                            'name'=>$personname,
                            'department_id'=>$overtime["department_id"],
                            'department_name'=>$d_name,
                            'date'=>$overtime["date"],
                            'start'=>$overtime["start"],
                            'start_time'=>$start_time,
                            'end_time'=>$end_time,
                            'end'=>$overtime["end"],
                            'hour'=>$overtime["hour"],
                            'day_category'=>$overtime["day_category"],
                            'reason'=>$overtime["reason"],
                            'is_key'=>$is_key,
                            'status'=>$status,
                            'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改加班\" data-toggle=\"modal\" data-target=\"#ModifyOvertime\" onclick=\"overtime_modify(this)\">修改</button>"),
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除加班\" onclick=\"delete_overtime(this)\">刪除</button>"),
                            'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出加班\" onclick=\"overtime_word(this)\">匯出</button>"),
                        ));
                    }
                    else
                    {
                        array_push($rowdata,array(
                            'no'=>$overtime["no"],
                            'id'=>$overtime["person_id"],
                            'name'=>$personname,
                            'department_id'=>$overtime["department_id"],
                            'department_name'=>$d_name,
                            'date'=>$overtime["date"],
                            'start'=>$overtime["start"],
                            'start_time'=>$start_time,
                            'end_time'=>$end_time,
                            'end'=>$overtime["end"],
                            'hour'=>$overtime["hour"],
                            'day_category'=>$overtime["day_category"],
                            'reason'=>$overtime["reason"],
                            'is_key'=>$is_key,
                            'status'=>$status,
                            'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改加班\" data-toggle=\"modal\" data-target=\"#ModifyOvertime\" onclick=\"overtime_modify(this)\" disabled>修改</button>"),
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除加班\" onclick=\"delete_overtime(this)\" disabled>刪除</button>"),
                            'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出加班\" onclick=\"overtime_word(this)\" disabled>匯出</button>"),
                        ));
                    }
                }
                else
                {
                    if($overtime["person_id"]==$person_id)
                    {
                        array_push($rowdata,array(
                            'no'=>$overtime["no"],
                            'id'=>$overtime["person_id"],
                            'name'=>$personname,
                            'department_id'=>$overtime["department_id"],
                            'department_name'=>$d_name,
                            'date'=>$overtime["date"],
                            'start'=>$overtime["start"],
                            'start_time'=>$start_time,
                            'end_time'=>$end_time,
                            'end'=>$overtime["end"],
                            'hour'=>$overtime["hour"],
                            'day_category'=>$overtime["day_category"],
                            'reason'=>$overtime["reason"],
                            'is_key'=>$is_key,
                            'status'=>$status,
                            'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改加班\" data-toggle=\"modal\" data-target=\"#ModifyOvertime\" onclick=\"overtime_modify(this)\">修改</button>"),
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除加班\" onclick=\"delete_overtime(this)\">刪除</button>"),
                            'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出加班\" onclick=\"overtime_word(this)\">匯出</button>"),
                        ));
                    }
                    else
                    {
                        array_push($rowdata,array(
                            'no'=>$overtime["no"],
                            'id'=>$overtime["person_id"],
                            'name'=>$personname,
                            'department_id'=>$overtime["department_id"],
                            'department_name'=>$d_name,
                            'date'=>$overtime["date"],
                            'start'=>$overtime["start"],
                            'start_time'=>$start_time,
                            'end_time'=>$end_time,
                            'end'=>$overtime["end"],
                            'hour'=>$overtime["hour"],
                            'day_category'=>$overtime["day_category"],
                            'reason'=>$overtime["reason"],
                            'is_key'=>$is_key,
                            'status'=>$status,
                            'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改加班\" data-toggle=\"modal\" data-target=\"#ModifyOvertime\" onclick=\"overtime_modify(this)\" disabled>修改</button>"),
                            'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除加班\" onclick=\"delete_overtime(this)\" disabled>刪除</button>"),
                            'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出加班\" onclick=\"overtime_word(this)\" disabled>匯出</button>"),
                        ));
                    }
                }
            }
        }

        //超過5:30不能申請
        date_default_timezone_set("Asia/Taipei");
        $checkDay = date('Y-m-d ',time());
        $checkTime=strtotime($checkDay."17:30:00");
        $this_time =  time();
        if($this_time>$checkTime)
            $check="超過";
        else
            $check="沒超過";
        //判斷是否為全部資料
        $type="2";
//        dd($rowdata);
        $check_c=0;
        return view("Person_Overtime",['title'=>'員工加班','level'=>$level,'rowdata'=>$rowdata,'person_id'=>$person_id,'person_name'=>$person_name,'user_department'=>$user_department,'department_name'=>$department_name,'persons'=>$persons,'departments'=>$departments,'authority'=>$authority,'check'=>$check,'type'=>$type,'check_c'=>$check_c]);

    }
    //查詢某人加班
    public function select_overtime_personal(Request $request)
    {
        // 表單傳值回帶
        session()->flashInput($request->input());
        $request->session()->all();
        $msg = request()->session()->get('error_msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $user_department="";
        $level="";
        $person_id="";
        $user_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $user_department=$user["department"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }


        $departments= array();
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $department) {
                array_push( $departments, array(
                    "no" => $department["no"],
                    "department" => $department["department"],
                ));
                if($department["no"]==$user_department)
                    $department_name=$department["department"];
            }
        }
        $department_personid=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["department"]==$user_department)
            {
                array_push($department_personid,array(
                    'name'=>$user["name"],
                    'id'=>$user["person_id"]
                ));
            }
        }
        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }
        $person_name="";
        $person_1=array();
        $persons=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person){
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }
                if($level=="2")
                {
                    if(in_array ($person["ID"] , $group_persons))
                    {
                        array_push($person_1,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                elseif($level=="1")
                {
                    if($person["ID"]==$person_id)
                    {
                        array_push($person_1,array(
                            'name'=>$person["Name"],
                            'id'=>$person["ID"]
                        ));
                    }
                }
                else
                {
                    array_push($person_1,array(
                        'name'=>$person["Name"],
                        'id'=>$person["ID"]
                    ));
                }
                array_push($persons,array(
                    'name'=>$person["Name"],
                    'id'=>$person["ID"]
                ));
            }
        }

        $rowdata=array();
        $personname="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/overtime/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $overtime){
                $start=$overtime["date"];
                $end=$overtime["date"];
                if(strtotime($request->start)<=strtotime($start) and strtotime($request->end)>=strtotime($end))
                {
                }
                else
                    continue 1;
                foreach ($persons as $person){
                    switch ($overtime["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $d_name="";
                foreach($departments as $department)
                {
                    if($overtime["department_id"]==$department["no"])
                        $d_name=$department["department"];
                }
                $is_key="";
                if($overtime["is_key"]==true)
                    $is_key="有";
                else
                    $is_key="沒有";
                $status="";
                if($overtime["status"]=="1")
                    $status="審核通過";
                elseif($overtime["status"]=="0")
                    $status="審核中";
                else
                    $status="已退件";
                $start_time=$overtime["date"]." ".$overtime["start"];
                $end_time=$overtime["date"]." ".$overtime["end"];
                if($overtime["person_id"]==$request->person)
                {
                    array_push($rowdata,array(
                        'no'=>$overtime["no"],
                        'id'=>$overtime["person_id"],
                        'name'=>$personname,
                        'department_id'=>$overtime["department_id"],
                        'department_name'=>$d_name,
                        'date'=>$overtime["date"],
                        'start'=>$overtime["start"],
                        'start_time'=>$start_time,
                        'end_time'=>$end_time,
                        'end'=>$overtime["end"],
                        'hour'=>$overtime["hour"],
                        'day_category'=>$overtime["day_category"],
                        'reason'=>$overtime["reason"],
                        'is_key'=>$is_key,
                        'status'=>$status,
                        'modify'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"修改加班\" data-toggle=\"modal\" data-target=\"#ModifyOvertime\" onclick=\"overtime_modify(this)\">修改</button>"),
                        'delete'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"刪除加班\" onclick=\"delete_overtime(this)\">刪除</button>"),
                        'export'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"匯出加班\" onclick=\"overtime_word(this)\">匯出</button>"),
                    ));
                }
            }
        }

        //超過5:30不能申請
        date_default_timezone_set("Asia/Taipei");
        $checkDay = date('Y-m-d ',time());
        $checkTime=strtotime($checkDay."17:30:00");
        $this_time =  time();
        if($this_time>$checkTime)
            $check="超過";
        else
            $check="沒超過";
        //判斷是否為全部資料
        $type="2";
//        dd($rowdata);
        $check_c=1;
        return view("Person_Overtime",['title'=>'員工加班','level'=>$level,'rowdata'=>$rowdata,'person_id'=>$person_id,'person_name'=>$person_name,'user_department'=>$user_department,'department_name'=>$department_name,'persons'=>$person_1,'departments'=>$departments,'authority'=>$authority,'check'=>$check,'type'=>$type,'check_c'=>$check_c]);
    }
    //新增加班
    public function insert_overtime(Request $request)
    {
        date_default_timezone_set("Asia/Taipei");
        $checkDay = date('Y-m-d ',time());
        $checkTime=strtotime($checkDay."17:30:00");
        $this_time =  time();
        if($this_time>$checkTime)
            $check="超過";
        else
            $check="沒超過";
        if($check=="超過")
        {
            $msg="超過可申請時間(17:30)";
            return redirect()->route('overtime_index')->with(["msg" => $msg]);
        }
        $start_time=$request->start_time;
        $end_time=$request->end_time;
        if(strtotime($start_time)<$checkTime)
        {
            $msg="不能申請過去的加班";
            return redirect()->route('overtime_index')->with(["msg" => $msg]);
        }
        $srart_a = explode(" ", $start_time);
        $end_a = explode(" ", $end_time);
        //dd($srart_a);
        $key="";
        if($request->is_key=="有")
            $key="1";
        //新增加班
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/overtime/insert", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST",
            "multipart",
            [
                [
                    'name'=>"person_id",
                    'contents'=>$request->person
                ],
                [
                    'name'=>"department_id",
                    'contents'=>$request->department
                ],
                [
                    'name'=>"date",
                    'contents'=>$srart_a[0]
                ],
                [
                    'name'=>"start",
                    'contents'=>$srart_a[1]
                ],
                [
                    'name'=>"end",
                    'contents'=>$end_a[1]
                ],
                [
                    'name'=>"hour",
                    'contents'=>$request->hour
                ],
                [
                    'name'=>"day_category",
                    'contents'=>$request->day_category
                ],
                [
                    'name'=>"reason",
                    'contents'=>$request->reason
                ],
                [
                    'name'=>"is_key",
                    'contents'=>$key
                ],
                [
                    'name'=>"status",
                    'contents'=>"0"
                ],
            ]);
        $jsondata=json_decode($res->getBody()->__toString(),true);
        $msg=$jsondata["Message"];
        $return_msg="";
        if(strpos($msg,"inserted") !== false)
            $return_msg="新增加班成功";
        elseif(strpos($msg,"database") !== false)
            $return_msg="加班資料已存在";
        else
            $return_msg="新增加班失敗";

        //mail通知
        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$request->person)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }
        $group_users=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        foreach ($jsondata["Data"] as $user_1) {
            if(in_array ($user_1["person_id"] , $group_persons))
            {
                array_push( $group_users,$user_1["id"]);
            }
        }
        $auth_user=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user_authority) {
            if(in_array ($user_authority["user_id"] , $group_users) and $user_authority["features_id"]=="23")
            {
                array_push( $auth_user,$user_authority["user_id"]);
            }
        }
        $mail=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        foreach ($jsondata["Data"] as $user) {
            if(in_array ($user["id"] , $auth_user) and $user["email"]!="")
            {
                array_push($mail, array(
                    "name" => $user["name"],
                    'mail' => $user["email"],
                ));
            }
        }
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        foreach ($jsondata["Data"] as $department) {
            if($department["no"]==$request->department)
            {
                $department_name=$department["department"];
            }
        }
        $person_name="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all" ,env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person) {
                if($person["ID"]==$request->person)
                {
                    $person_name=$person["Name"];
                }
            }
        }
//        dd($mail);
        if(!is_null($mail))
        {
            foreach($mail as $mailto)
            {
                $data=[
                    'mange'=>$mailto["name"],   //主管名字
                    'context'=>"加班列表已新增一筆，請進入系統審核",   //內容
                    'dart'=>$department_name,    //部門名稱
                    'name'=>$person_name,     //加班員工名字
                    'date'=>$srart_a[0],     //加班日期
                    'time'=>$srart_a[1]."-".$end_a[1],     //加班時間
                    'reason'=>$request->reason,       //加班原因
                    'key'=>$request->is_key,   //有無鑰匙
                ];
                $email=$mailto["mail"];
                Mail::send('overtime_mail',$data, function($message) use ($email) {
                    $message->to($email)->subject('差勤系統請加班審核');
                });
            }
        }
        return redirect()->route('overtime_index')->with(["msg" => $return_msg]);
    }
    //修改加班
    public function update_overtime(Request $request)
    {
        $start_time=$request->start_time;
        $end_time=$request->end_time;
        date_default_timezone_set("Asia/Taipei");
        $checkDay = date('Y-m-d ',time());
        $checkTime=strtotime($checkDay."17:30:00");
        if(strtotime($start_time)<$checkTime)
        {
            $msg="不能申請過去的加班";
            return redirect()->route('overtime_index')->with(["msg" => $msg]);
        }
        $srart_a = explode(" ", $start_time);
        $end_a = explode(" ", $end_time);
        //dd($srart_a);
        $key="";
        if($request->is_key=="有")
            $key="1";
        //新增假單(出差)
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/overtime/update", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST",
            "multipart",
            [
                [
                    'name'=>"no",
                    'contents'=>$request->no
                ],
                [
                    'name'=>"person_id",
                    'contents'=>$request->person
                ],
                [
                    'name'=>"department_id",
                    'contents'=>$request->department
                ],
                [
                    'name'=>"date",
                    'contents'=>$srart_a[0]
                ],
                [
                    'name'=>"start",
                    'contents'=>$srart_a[1]
                ],
                [
                    'name'=>"end",
                    'contents'=>$end_a[1]
                ],
                [
                    'name'=>"hour",
                    'contents'=>$request->hour
                ],
                [
                    'name'=>"day_category",
                    'contents'=>$request->day_category
                ],
                [
                    'name'=>"reason",
                    'contents'=>$request->reason
                ],
                [
                    'name'=>"is_key",
                    'contents'=>$key
                ],
                [
                    'name'=>"status",
                    'contents'=>"0"
                ],
            ]);
        $jsondata=json_decode($res->getBody()->__toString(),true);
        $msg=$jsondata["Message"];
        $return_msg="";
        if(strpos($msg,"failed") !== false)
            $return_msg="修改加班失敗";
        elseif(strpos($msg,"database") !== false)
            $return_msg="加班資料不存在";
        else
            $return_msg="修改加班成功";
        return redirect()->route('overtime_index')->with(["msg" => $return_msg]);
    }
    //刪除加班
    public function delete_overtime(Request $request){
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/overtime/delete", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST",
            "multipart",
            [
                [
                    'name'=>"no",
                    "contents"=>$request->selectedId
                ],
            ]
        );
        $jsondata=json_decode($res->getBody()->__toString(),true);
        $msg=$jsondata["Message"];
        $return_msg="";
        if(strpos($msg,"deleted") !== false)
            $return_msg="刪除加班成功";
        elseif(strpos($msg,"database") !== false)
            $return_msg="加班資料不存在";
        else
            $return_msg="刪除加班失敗";
        return redirect()->route('overtime_index')->with(["msg" => $return_msg]);
    }
    //匯出加班
    public function export_overtime(Request $request)
    {
        //dd($request->overtime_id);
        $overtime_id=$request->overtime_id;
        $person_id="";
        $person_name="";
        $department_id="";
        $department="";
        $date="";
        $day_category="";
        $start_time="";
        $end_time="";
        $hour="";
        $reason="";

        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/overtime/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $overtime)
            {
                if($overtime["no"]==$overtime_id)
                {
                    $person_id=$overtime["person_id"];
                    $department_id=$overtime["department_id"];
                    $date=$overtime["date"];
                    $day_category=$overtime["day_category"];
                    $start_time=$overtime["start"];
                    $end_time=$overtime["end"];
                    $hour=$overtime["hour"];
                    $reason=$overtime["reason"];
                }
            }
        }


        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] != null){
            foreach ($jsondata["Data"] as $departments) {
                if($department_id==$departments["no"])
                {
                    $department=$departments["department"];
                }
            }
        }

        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user){
            if($person_id==$user["person_id"]){
                $person_name=$user["name"];
            }
        }

        $filename = sprintf("../storage/export/加班單%s.docx",$overtime_id);
        $file = fopen($filename, 'w');
        $client = new \GuzzleHttp\Client();
        $res=$client->request('POST', sprintf("http://%s:%s/overtime/word",env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),[
            'form_params'=>[
                'overtime_id'=>$overtime_id,
                'person_id'=>$person_id,
                'person_name'=>$person_name,
                'department'=>$department,
                'date'=>$date,
                'day_category'=>$day_category,
                'start_time'=>$start_time,
                'end_time'=>$end_time,
                'hour'=>$hour,
                'reason'=>$reason,
            ],
            'save_to' => $file
        ]);
        return response()->download($filename);

    }
    //審核加班首頁
    public function check_overtime(Request $request)
    {
        $request->session()->all();
        $msg = request()->session()->get('msg');
        $username=$request->session()->get('Tusername');    //帳號
        $role="";
        $level="";
        $person_id="";
        $user_id="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        foreach ($jsondata["Data"] as $user) {
            if($user["username"]==$username)
            {
                $person_id=$user["person_id"];
                $role=$user["role"];
                $user_id=$user["id"];
            }
        }
        if($role=="7")
        {
            $level="4";
        }
        elseif ($role=="3")
        {
            $level="3";
        }
        elseif ($role=="6")
        {
            $level="2";
        }
        elseif($role=="5")
        {
            $level="1";
        }
        //取得權限
        $authority=array();
        $user_auth=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/role/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $role_authority) {
                if($role_authority["role_id"]==$role)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $role_authority["features_id"],
                    ));
                    array_push( $user_auth,$role_authority["features_id"]);
                }
            }
        }
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/features/user/relation/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $user_authority) {
                if($user_authority["user_id"]==$user_id)
                {
                    array_push( $authority, array(
//                    "no" => $role_authority["no"],
                        "features_id" => $user_authority["features_id"],
                    ));
                    array_push( $user_auth,$user_authority["features_id"]);
                }
            }
        }
        $persons=array();
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person){
                array_push($persons,array(
                    'name'=>$person["Name"],
                    'id'=>$person["ID"]
                ));
            }
        }

        $group_id="";
        $person_group_relation=array();
        $group_persons=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/person/group/relation/all",env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person_group) {
                array_push( $person_group_relation, array(
                    "person_id" => $person_group["PersonID"],
                    "group_id" => $person_group["PersonGroupID"],
                ));
                if($person_group["PersonID"]==$person_id)
                {
                    $group_id=$person_group["PersonGroupID"];
                }
            }
            foreach ($person_group_relation as $person_group_1) {
                if($person_group_1["group_id"]==$group_id)
                {
                    array_push( $group_persons,$person_group_1["person_id"]);
                }
            }
        }
        $rowdata=array();
        $personname="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/overtime/all", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST");
        $jsondata=json_decode($res->getBody()->__toString(),true);
        if($jsondata["Data"]!=null)
        {
            foreach ($jsondata["Data"] as $overtime){
                foreach ($persons as $person){
                    switch ($overtime["person_id"]){
                        case $person["id"]:
                            $personname= $person["name"];
                            break;
                    }
                }
                $is_key="";
                if($overtime["is_key"]==true)
                    $is_key="有";
                else
                    $is_key="沒有";
                if($overtime["status"]=="0" and in_array ("19" , $user_auth))
                {
                    array_push($rowdata,array(
                        'no'=>$overtime["no"],
                        'id'=>$overtime["person_id"],
                        'name'=>$personname,
                        'date'=>$overtime["date"],
                        'start'=>$overtime["start"],
                        'end'=>$overtime["end"],
                        'reason'=>$overtime["reason"],
                        'agree'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"同意加班\" onclick=\"agree_overtime(this)\">同意</button>"),
                        'disagree'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"駁回加班\" data-toggle=\"modal\" data-target=\"#DisagreeOvertime\" onclick=\"disagree_overtime(this)\">退回</button>"),
                    ));
                }
                elseif($overtime["status"]=="0" and  in_array ($overtime["person_id"] , $group_persons))
                {
                    array_push($rowdata,array(
                        'no'=>$overtime["no"],
                        'id'=>$overtime["person_id"],
                        'name'=>$personname,
                        'date'=>$overtime["date"],
                        'start'=>$overtime["start"],
                        'end'=>$overtime["end"],
                        'reason'=>$overtime["reason"],
                        'agree'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"同意加班\" onclick=\"agree_overtime(this)\">同意</button>"),
                        'disagree'=>sprintf("<button class=\"btn btn-outline-dark\" title=\"駁回加班\" data-toggle=\"modal\" data-target=\"#DisagreeOvertime\" onclick=\"disagree_overtime(this)\">退回</button>"),
                    ));
                }
            }
        }
        if($msg!=null)
            return view("Person_Overtime_Check",['title'=>'加班審核','level'=>$level,'error_msg'=>$msg,'rowdata'=>$rowdata,'authority'=>$authority]);
        else
            return view("Person_Overtime_Check",['title'=>'加班審核','level'=>$level,'rowdata'=>$rowdata,'authority'=>$authority]);

    }
    //退回加班
    public function disagree_overtime(Request $request)
    {
        $no=$request->no;
        $person_id="";
        $department_id="";
        $date="";
        $start="";
        $end="";
        $hour="";
        $day_category="";
        $reason="";
        $is_key="";
        $status="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/overtime/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $overtime) {
                if($overtime["no"]==$no)
                {
                    $person_id=$overtime["person_id"];
                    $department_id=$overtime["department_id"];
                    $date=$overtime["date"];
                    $start=$overtime["start"];
                    $end=$overtime["end"];
                    $hour=$overtime["hour"];
                    $day_category=$overtime["day_category"];
                    $reason=$overtime["reason"];
                    $is_key=$overtime["is_key"];
                    $status=$overtime["status"];
                }
            }
        }

        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/overtime/update", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST",
            "multipart",
            [
                [
                    'name'=>"no",
                    'contents'=>$no
                ],
                [
                    'name'=>"person_id",
                    'contents'=>$person_id
                ],
                [
                    'name'=>"department_id",
                    'contents'=>$department_id
                ],
                [
                    'name'=>"date",
                    'contents'=>$date
                ],
                [
                    'name'=>"start",
                    'contents'=>$start
                ],
                [
                    'name'=>"end",
                    'contents'=>$end
                ],
                [
                    'name'=>"hour",
                    'contents'=>$hour
                ],
                [
                    'name'=>"day_category",
                    'contents'=>$day_category
                ],
                [
                    'name'=>"reason",
                    'contents'=>$reason
                ],
                [
                    'name'=>"is_key",
                    'contents'=>$is_key
                ],
                [
                    'name'=>"status",
                    'contents'=>$request->disagree
                ],
            ]);
        $jsondata=json_decode($res->getBody()->__toString(),true);
        $msg=$jsondata["Message"];
        $return_msg="";
        if(strpos($msg,"failed") !== false)
            $return_msg="退回加班失敗";
        elseif(strpos($msg,"database") !== false)
            $return_msg="加班資料不存在";
        else
            $return_msg="退回加班成功";

        $mail=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        foreach ($jsondata["Data"] as $user) {
            if($user["person_id"]==$person_id and $user["email"]!="")
            {
                array_push($mail, array(
                    "name" => $user["name"],
                    'mail' => $user["email"],
                ));
            }
        }
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $department) {
                if($department["no"]==$department_id)
                {
                    $department_name=$department["department"];
                }
            }
        }
        $person_name="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all" ,env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person) {
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }
            }
        }

        $key="";
        if($is_key=="1")
            $key="有";
        else
            $key="沒有";

        if(!is_null($mail))
        {
            foreach($mail as $mailto)
            {
                $data=[
                    'mange'=>$mailto["name"],   //主管名字
                    'context'=>"加班審核已被退件，退件原因：".$request->disagree,   //內容
                    'dart'=>$department_name,    //部門名稱
                    'name'=>$person_name,     //加班員工名字
                    'date'=>$date,     //加班日期
                    'time'=>$start."-".$end,     //加班時間
                    'reason'=>$reason,       //加班原因
                    'key'=>$key,   //有無鑰匙
                ];
                $email=$mailto["mail"];
                Mail::send('overtime_mail',$data, function($message) use ($email) {
                    $message->to($email)->subject('差勤系統請加班審核');
                });
            }
        }

        return redirect()->route('check_overtime')->with(["msg" => $return_msg]);
    }
    //同意加班
    public function agree_overtime(Request $request)
    {
        $no=$request->no;
        $person_id="";
        $department_id="";
        $date="";
        $start="";
        $end="";
        $hour="";
        $day_category="";
        $reason="";
        $is_key="";
        $status="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/overtime/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $overtime) {
                if($overtime["no"]==$no)
                {
                    $person_id=$overtime["person_id"];
                    $department_id=$overtime["department_id"];
                    $date=$overtime["date"];
                    $start=$overtime["start"];
                    $end=$overtime["end"];
                    $hour=$overtime["hour"];
                    $day_category=$overtime["day_category"];
                    $reason=$overtime["reason"];
                    $is_key=$overtime["is_key"];
                    $status=$overtime["status"];
                }
            }
        }

        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/overtime/update", env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"POST",
            "multipart",
            [
                [
                    'name'=>"no",
                    'contents'=>$no
                ],
                [
                    'name'=>"person_id",
                    'contents'=>$person_id
                ],
                [
                    'name'=>"department_id",
                    'contents'=>$department_id
                ],
                [
                    'name'=>"date",
                    'contents'=>$date
                ],
                [
                    'name'=>"start",
                    'contents'=>$start
                ],
                [
                    'name'=>"end",
                    'contents'=>$end
                ],
                [
                    'name'=>"hour",
                    'contents'=>$hour
                ],
                [
                    'name'=>"day_category",
                    'contents'=>$day_category
                ],
                [
                    'name'=>"reason",
                    'contents'=>$reason
                ],
                [
                    'name'=>"is_key",
                    'contents'=>$is_key
                ],
                [
                    'name'=>"status",
                    'contents'=>"1"
                ],
            ]);
        $jsondata=json_decode($res->getBody()->__toString(),true);
        $msg=$jsondata["Message"];
        $return_msg="";
        if(strpos($msg,"failed") !== false)
            $return_msg="審核加班失敗";
        elseif(strpos($msg,"database") !== false)
            $return_msg="加班資料不存在";
        else
            $return_msg="審核加班成功";

        $mail=array();
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/user/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        foreach ($jsondata["Data"] as $user) {
            if($user["person_id"]==$person_id and $user["email"]!="")
            {
                array_push($mail, array(
                    "name" => $user["name"],
                    'mail' => $user["email"],
                ));
            }
        }
        $department_name="";
        [$ret, $res] = $this->request_server(sprintf("http://%s:%s/department/all", env("IMAGE_SERVER_HOST"), env("IMAGE_SERVER_PORT")), "POST");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $department) {
                if($department["no"]==$department_id)
                {
                    $department_name=$department["department"];
                }
            }
        }
        $person_name="";
        [$ret,$res]=$this->request_server(sprintf("http://%s:%s/person/select/all" ,env("IMAGE_SERVER_HOST"),env("IMAGE_SERVER_PORT")),"GET");
        $jsondata = json_decode($res->getBody()->__toString(), true);
        if($jsondata["Data"] !=null)
        {
            foreach ($jsondata["Data"] as $person) {
                if($person["ID"]==$person_id)
                {
                    $person_name=$person["Name"];
                }
            }
        }

        $key="";
        if($is_key=="1")
            $key="有";
        else
            $key="沒有";

        if(!is_null($mail))
        {
            foreach($mail as $mailto)
            {
                $data=[
                    'mange'=>$mailto["name"],   //主管名字
                    'context'=>"加班審核已通過",   //內容
                    'dart'=>$department_name,    //部門名稱
                    'name'=>$person_name,     //加班員工名字
                    'date'=>$date,     //加班日期
                    'time'=>$start."-".$end,     //加班時間
                    'reason'=>$reason,       //加班原因
                    'key'=>$key,   //有無鑰匙
                ];
                $email=$mailto["mail"];
                Mail::send('overtime_mail',$data, function($message) use ($email) {
                    $message->to($email)->subject('差勤系統請加班審核');
                });
            }
        }
        return redirect()->route('check_overtime')->with(["msg" => $return_msg]);
    }



    //取得API資料的方法
    private function request_server($url,$method,$data_format=null,$data=null){
        $status_code=404;
        $client=new \GuzzleHttp\Client();
        switch ($method){
            case "GET":
                try {
                    $res = $client->request('GET',$url);
                    $status_code=$res->getStatusCode();
                }catch (RequestException $e){
                    if (!$e->hasResponse()) {
                        // 伺服器沒有回應
                        $status_code=503;
                    }
                }
                break;
            case "POST":
                if ($data!=null and $data_format !=null){
                    if ($data_format =="form_params" or $data_format =="multipart"){
                        try {
                            $res=$client->request('POST',$url,[
                                $data_format=>$data
                            ]);
                            $status_code=$res->getStatusCode();
                        }catch (RequestException $e){
                            if (!$e->hasResponse()) {
                                // 伺服器沒有回應
                                $status_code=503;
                            }
                        }
                    }else{
                        $status_code=404;
                    }
                }else{
                    try {
                        $res=$client->request('POST',$url);
                        $status_code=$res->getStatusCode();
                    }catch (RequestException $e){
                        if (!$e->hasResponse()) {
                            // 伺服器沒有回應
                            $status_code=503;
                        }
                    }
                }
                break;
            default:
                break;
        }

        switch ($status_code){
            case 200:
                return [true,$res];
                break;
            case 404:
                return abort("404","查無此頁");
            case 500:
                return abort("500","內部伺服器錯誤");
            case 503:
                return abort("503","伺服器沒有回應");
            default:
                return abort("404","查無此頁");
                break;
        }
    }
}
